﻿var eApp = angular.module('eApp', ['chieffancypants.loadingBar', 'ngDialog', 'angularUtils.directives.dirPagination', 'pascalprecht.translate']);
eApp.controller('HomeContr', function ($rootScope, $scope, $timeout, cfpLoadingBar, CommService, $translate, $sce, $location) {
    debugger
    cfpLoadingBar.start();

    $scope.domain = $sce.trustAsHtml($location.protocol() + "://" + $location.host() + ($location.port() == "" ? "" : ":" + $location.port()) + "/");

    

    $scope.SetLanguage = function (language) {
        window.localStorage.removeItem("Language");
        window.localStorage.setItem("Language", language);
        window.location.reload();
    };
});

eApp.controller('OtherController', function ($scope) {
    $scope.pageChangeHandler = function (num) {
        console.log('going to page ' + num);
    };
});

eApp.controller('Comm-Ctl', function ($scope, $sce, CommService, $location, Excel, $timeout) {

    $('.print_show').css("display", "none");
    $scope.ListWorkStatus = [];
    $scope.ListPageSize = [];
    $scope.ListWorkStatus = [{ "id": "NA", "status": "Initiate" },
                            { "id": "Request", "status": "Request" },
                            { "id": "Approved", "status": "Approved2" }, ]

    $scope.ListPageSize = [
                            { "id": "", "value": "", "text": "All Record" },
                            { "id": "1", "value": "50", "text": "50 Record" },
                            { "id": "2", "value": "100", "text": "100 Record" },
                            { "id": "3", "value": "200", "text": "200 Record" },
                            { "id": "4", "value": "500", "text": "500 Record" }]

    
    $scope.exportData = function (tableId) { // ex: '#my-table'

        var exportHref = Excel.tableToExcel(tableId, 'TPS DoITC');
        
        $timeout(function () { location.href = exportHref; }, 100); // trigger download
    }

    $scope.exportDataDownload = function (tableId, linkID) { // ex: '#my-table'

        var exportHref = Excel.tableToExcel(tableId, 'DoITC_IT_DIR');

        const downloadLink = document.createElement('a');

        //$timeout(function () {
           
        //    downloadLink.href = exportHref;
        //    downloadLink.download = 'download.xls';
        //    downloadLink.click();
            
        //}, 5000);

         downloadLink.href = exportHref;
            downloadLink.download = 'download.xls';
            downloadLink.click();
    }

    $scope.exportDataDownloadNew = function (tableId, linkID) {
        debugger
        var elt = document.getElementById(tableId);
        const elementsToRemove = elt.getElementsByClassName("no-export");
        while (elementsToRemove.length > 0) elementsToRemove[0].remove();

        var exportHref = Excel.tableToExcel(tableId, 'DoITC_IT_DIR');

        const downloadLink = document.createElement('a');
        debugger
        $timeout(function () {

            downloadLink.href = exportHref;
            downloadLink.download = 'download.xls';
            downloadLink.click();

        }, 5000);
    }

    $scope.ExportHTMLToExcel = function (htmlTableObjID) {
    debugger
        var location = 'data:application/vnd.ms-excel;base64,';
        var excelTemplate = '<html> ' +
            '<head> ' +
            '<meta http-equiv="content-type" content="text/plain; charset=UTF-8"/> ' +
            '</head> ' +
            '<body> ' +
            document.getElementById(htmlTableObjID).innerHTML +
            '</body> ' +
            '</html>'
        window.location.href = location + window.btoa(excelTemplate);
    }

    $scope.printGridDiv = function (divName) {
        $('.print_hide').css("display", "none");
        $('.print_show').css("display", "block");
        var printContents = document.getElementById(divName).innerHTML;
        var originalContents = document.body.innerHTML;

        var header = '<div style="padding:10px;width:100%; text-align:center"><img src="assets/img/logo.png" alt="Logo"></div>';

        document.body.innerHTML = header + printContents;
        window.print();
        document.body.innerHTML = originalContents;
        window.location.reload();
    }

    $scope.scroll_top = function () { $('html, body').animate({ scrollTop: 0 }, 500); }

});

eApp.value("eAppVal", { GridPageSize: 50 });

eApp.service('CommService', function ($http, $sce, $rootScope, $location) {
       
    $rootScope.url = "/";

    this.getQueryStrings = function getQueryStrings() {
        var assoc = {};
        var decode = function (s) { return decodeURIComponent(s.replace(/\+/g, " ")); };
        var queryString = location.search.substring(1);
        var keyValues = queryString.split('&');

        for (var i in keyValues) {
            var key = keyValues[i].split('=');
            if (key.length > 1) {
                assoc[decode(key[0])] = decode(key[1]);
            }
        }
        return assoc;
    };
});

eApp.directive('emptyGrid', function () {
    return {
        restrict: 'A',
        template: '<div class="alert alert-info alert-GvEmpty">No Record Found !</div>',
        scope: {
        }
    };
});

eApp.directive('modal', function () {
    return {
        template: '<div class="modal fade">' +
          '<div class="modal-dialog">' +
            '<div class="modal-content">' +
              '<div >' +
                '<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>' +
                '<h4 class="modal-title">{{ title }}</h4>' +
              '</div>' +
              '<div class="modal-body" ng-transclude></div>' +
            '</div>' +
          '</div>' +
        '</div>',
        restrict: 'E',
        transclude: true,
        replace: true,
        scope: true,
        link: function postLink(scope, element, attrs) {
            scope.title = attrs.title;

            scope.$watch(attrs.visible, function (value) {
                if (value == true)
                    $(element).modal('show');
                else
                    $(element).modal('hide');
            });

            $(element).on('shown.bs.modal', function () {
                scope.$apply(function () {
                    scope.$parent[attrs.visible] = true;
                });
            });

            $(element).on('hidden.bs.modal', function () {
                scope.$apply(function () {
                    scope.$parent[attrs.visible] = false;
                });
            });
        }
    };
});

eApp.factory('Excel', function ($window) {
    var uri = 'data:application/vnd.ms-excel;base64,',
        template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>',
        base64 = function (s) { return $window.btoa(unescape(encodeURIComponent(s))); },
        format = function (s, c) { return s.replace(/{(\w+)}/g, function (m, p) { return c[p]; }) };
    return {
        tableToExcel: function (tableId, worksheetName) {

            var filterData = $('#' + tableId);
            $(filterData).find('tr.footerPaging').remove();

            var table = filterData,
                ctx = { worksheet: worksheetName, table: table.html() },
                href = uri + base64(format(template, ctx));
            return href;
        }
    };
})

eApp.directive('allowOnlyNumbers1', function () {
    return {
        restrict: 'A',
        link: function (scope, elm, attrs, ctrl) {
            elm.on('keydown', function (event) {
                if (event.which == 64 || event.which == 16) {
                    // to allow numbers  
                    return false;
                } else if (event.which >= 48 && event.which <= 57) {
                    // to allow numbers  
                    return true;
                } else if (event.which >= 96 && event.which <= 105) {
                    // to allow numpad number  
                    return true;
                } else if ([8, 13, 27, 37, 38, 39, 40].indexOf(event.which) > -1) {
                    // to allow backspace, enter, escape, arrows  
                    return true;
                } else {
                    event.preventDefault();
                    // to stop others  
                    return false;
                }
            });
        }
    }
});

eApp.directive('allowOnlyNumbers', function () {
    return {
        require: 'ngModel',
        link: function (scope) {
            scope.$watch('wks.number', function (newValue, oldValue) {
                var arr = String(newValue).split("");
                if (arr.length === 0) return;
                if (arr.length === 1 && (arr[0] == '-' || arr[0] === '.')) return;
                if (arr.length === 2 && newValue === '-.') return;
                if (isNaN(newValue)) {
                    scope.wks.number = oldValue;
                }
            });
        }
    };
});

function getRandomColor() {
    var letters = '0123456789ABCDEF';
    var color = '#';
    for (var i = 0; i < 6; i++) {
        color += letters[Math.floor(Math.random() * 16)];
    }
    return color;
}
