﻿<%@ WebHandler Language="C#" Class="ITDirectory" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;

public class ITDirectory : IHttpHandler
{
    DataSet dsUser;

    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        context.Response.ContentType = "text/plain";

        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        ClsEmployeeDetailsList objCls = Deserialize<ClsEmployeeDetailsList>(strJson);
        if (objCls != null)
        {
            string Key = objCls.key;
            dsUser = new DataSet();
            try
            {
                if(Key.ToUpper().StartsWith("MASTER_"))
                {
                    dsUser = new APIProcedure().ByProcedure("USP_GET_MASTER_DATA", new string[] { "key" }, new string[] {  objCls.key}, "USPADDSETTING");
                }
                else if(Key.ToUpper() == "GET_EMPLOYEE_LIST")
                {
                    dsUser = new APIProcedure().ByProcedure("USP_GET_EMPLOYEE_LIST",
                    new string[] {
                            "key",
                            "EmployeeName",
                            "DesignationID",
                            "FromOffice",
                            "FromDeptID",
                            "FromPlace",
                            "FromDistrictID",
                            "EmployeeType",
                            "GenderID",
                            "Language",
                            "Action"
                    },
                    new string[] {  objCls.key,
                                    objCls.EmployeeName,
                                    objCls.DesignationID,
                                    objCls.FromOffice,
                                    objCls.FromDeptID,
                                    objCls.FromPlace,
                                    objCls.FromDistrictID,
                                    objCls.EmployeeType,
                                    objCls.GenderID,
                                    objCls.Language,
                                    objCls.Action,
                    }, "USPADDSETTING");
                }
                else if (Key.ToUpper() == "GET_EMP_PERSONAL_DETAIL")
                {
                    dsUser = new APIProcedure().ByProcedure("USP_GET_EMP_PERSONAL_DETAIL", new string[] { "Language", "Action" }, new string[] {  objCls.Language, objCls.Action}, "USPADDSETTING");
                }
                else if (Key.ToUpper() == "GET_EMP_HISTORY")
                {
                    dsUser = new APIProcedure().ByProcedure("USP_GET_EMP_HISTORY", new string[] { "Language", "Action" }, new string[] {  objCls.Language, objCls.Action}, "USPADDSETTING");
                }

                if (dsUser.Tables.Count > 0)
                {
                    context.Response.Write(JsonConvert.ExportToString(dsUser.Tables[0].Rows));
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(JsonConvert.ExportToString("Error"));
                new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
            }
            finally { dsUser.Dispose(); }
        }

    }
    public T Deserialize<T>(string context)
    {
        string jsonData = context;
        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    class ClsEmployeeDetailsList
    {
        public string key { get; set; }
        public string EmployeeName { get; set; }
        public string DesignationID { get; set; }
        public string FromOffice { get; set; }
        public string FromDeptID { get; set; }
        public string FromPlace { get; set; }
        public string FromDistrictID { get; set; }
        public string EmployeeType { get; set; }
        public string GenderID { get; set; }
        public string Language { get; set; }
        public string Action { get; set; }
    }
}
