﻿eApp.controller('ITDirectory-Ctrl', function ($translate, $rootScope, $scope, $timeout, $filter, cfpLoadingBar, CommService, ServiceEmployeeDetailsList, eAppVal, ngDialog, $controller) {
    cfpLoadingBar.start();
    $scope.fakeIntro = true;
    $timeout(function () {
        cfpLoadingBar.complete();
        $scope.fakeIntro = false;
        document.getElementById("wrapper").style.display = "Block";
    }, 750);
    debugger
    var selectedLanguage = window.localStorage.getItem("Language");
    //window.localStorage.setItem("Language", (selectedLanguage == '' || selectedLanguage == 'undefined' || selectedLanguage == null ? 'en' : selectedLanguage));
    $scope.Language = (selectedLanguage == '' || selectedLanguage == 'undefined' || selectedLanguage == null ? 'en' : selectedLanguage);
    
    $scope.currentPage = 1;
    $scope.ddlPageSize = eAppVal.GridPageSize;
    $scope.gvStatus = false;
    $scope.btnProcess = true;
    $scope.ShowAllColumns = false;
    $scope.isShowEmpWiseLatestRecords = true;
    $scope.EmployeeDetailsList = [];
    $scope.ngFormData = {};
    $scope.ngFormData.EmployeeName = "";
    $scope.ngFormData.DesignationID = "";
    $scope.ngFormData.FromOffice = "";
    $scope.ngFormData.FromDeptID = "";
    $scope.ngFormData.FromPlace = "";
    $scope.ngFormData.FromDistrictID = "";
    $scope.ngFormData.EmployeeType = "";
    $scope.ngFormData.GenderID = "";
    $scope.ngFormData.Language = "en";
    $scope.HistoryList = [];
    $scope.EmployeeOtherDetail = [];
    $scope.EmployeeDetailOnHistoryTab = [];

    PageLoad();

    function PageLoad() {

        $translate.use(window.localStorage.getItem("Language"));

        $scope.ngFormData.Language = window.localStorage.getItem("Language");

        FillComboBoxes();

        $scope.EmployeeDetailsList = [];

        var paramApp =
        {
            key: 'GET_EMPLOYEE_LIST',
            EmployeeName: $scope.ngFormData.EmployeeName,
            DesignationID: $scope.ngFormData.DesignationID,
            GenderID: $scope.ngFormData.GenderID,
            FromOffice: $scope.ngFormData.FromOffice,
            FromDeptID: $scope.ngFormData.FromDeptID,
            FromPlace: $scope.ngFormData.FromPlace,
            FromDistrictID: $scope.ngFormData.FromDistrictID,
            EmployeeType: $scope.ngFormData.EmployeeType,
            Language: $scope.ngFormData.Language
        };

        $scope.EmployeeDetailsList = [];
        ServiceEmployeeDetailsList.GetSet(paramApp).then(function (response) {
            if (response.data.length > 0) {
                $scope.EmployeeDetailsList = response.data;

                $scope.gvStatus = true;
            }
            else {
                $scope.gvStatus = false;
            }
        });

    }

    function FillComboBoxes() {

        var paramDes =
        {
            key: 'MASTER_DESIGNATIONS'
        };
        $scope.DesignationList = [];
        ServiceEmployeeDetailsList.GetSet(paramDes).then(function (response) {
            if (response.data.length > 0) {
                $scope.DesignationList = response.data;
            }
        });


        var paramDapt =
        {
            key: 'MASTER_DEPARTMENTS'
        };
        $scope.FromDepartmentList = [];
        ServiceEmployeeDetailsList.GetSet(paramDapt).then(function (response) {
            if (response.data.length > 0) {
                $scope.FromDepartmentList = response.data;
            }
        });

        var paramDist =
        {
            key: 'MASTER_DISTRICTS'
        };
        $scope.FromDistrictList = [];
        ServiceEmployeeDetailsList.GetSet(paramDist).then(function (response) {
            if (response.data.length > 0) {
                $scope.FromDistrictList = response.data;
            }
        });

        var paramGen =
        {
            key: 'MASTER_GENDER'
        };
        $scope.GenderList = [];
        ServiceEmployeeDetailsList.GetSet(paramGen).then(function (response) {
            if (response.data.length > 0) {
                $scope.GenderList = response.data;
            }
        });
    }

    $scope.GetSetData = function GetSetData(formData) {
        cfpLoadingBar.start();
        $scope.ngFormData = formData;
        var paramApp =
        {
            key: 'GET_EMPLOYEE_LIST',
            EmployeeName: $scope.ngFormData.EmployeeName,
            DesignationID: $scope.ngFormData.DesignationID,
            GenderID: $scope.ngFormData.GenderID,
            FromOffice: $scope.ngFormData.FromOffice,
            FromDeptID: $scope.ngFormData.FromDeptID,
            FromPlace: $scope.ngFormData.FromPlace,
            FromDistrictID: $scope.ngFormData.FromDistrictID,
            EmployeeType: $scope.ngFormData.EmployeeType,
            Language: $scope.ngFormData.Language
        };

        $scope.EmployeeDetailsList = [];
        ServiceEmployeeDetailsList.GetSet(paramApp).then(function (response) {
            if (response.data.length > 0) {
                $scope.EmployeeDetailsList = response.data;
                $scope.gvStatus = true;
            }
            else {
                message_info("No data found for selected criteria!");
                $scope.gvStatus = false;
            }
            cfpLoadingBar.complete();
        });
    }

    $scope.ShowEmployeeHistory = function (x) {
        $scope.EmployeeOtherDetail = [];
        var paramEmpDetail =
        {
            key: 'GET_EMP_PERSONAL_DETAIL',
            Action: x.EmployeeId,
            Language: $scope.ngFormData.Language
        };
        ServiceEmployeeDetailsList.GetSet(paramEmpDetail).then(function (response) {
            if (response.data.length > 0) {
                debugger
                $scope.EmployeeOtherDetail.EmployeeName = response.data[0].EmployeeName;
                $scope.EmployeeOtherDetail.EmployeeFathersName = response.data[0].EmployeeFathersName;
                $scope.EmployeeOtherDetail.EmployeeDesignation = response.data[0].EmployeeDesignation;
                $scope.EmployeeOtherDetail.EmployeeDOB = response.data[0].EmployeeDOB;
                $scope.EmployeeOtherDetail.EmployeeGender = response.data[0].EmployeeGender;
                $scope.EmployeeOtherDetail.EmployeeContactNo = response.data[0].EmployeeContactNo;
                $scope.EmployeeOtherDetail.EmployeeEmailID = response.data[0].EmployeeEmailID;
                $scope.EmployeeOtherDetail.EmployeeSIPFID = response.data[0].EmployeeSIPFID;
            }
            else {
                $scope.EmployeeOtherDetail = [];
                message_info("Employee data not found!");
            }
        });
                
        $scope.EmployeeDetailOnHistoryTab = x;
        var paramHistory =
        {
            key: 'GET_EMP_HISTORY',
            Action: x.EmployeeId
        };
        ServiceEmployeeDetailsList.GetSet(paramHistory).then(function (response) {
            $scope.HistoryList = response.data;
            $('#myHistoryDetailModal').modal('toggle');
        });
    }

    $scope.ResetFilters = function ResetFilters() {
        $scope.ngFormData.EmployeeName = "";
        $scope.ngFormData.DesignationID = "";
        $scope.ngFormData.FromOffice = "";
        $scope.ngFormData.FromDeptID = "";
        $scope.ngFormData.FromPlace = "";
        $scope.ngFormData.FromDistrictID = "";
        $scope.ngFormData.EmployeeType = "";
        $scope.ngFormData.GenderID = "";
    };

    //$scope.ExportFile = function ExportFile(printID, downloadLink) {        
    //    $("#LoadingSpanExport").css('display', 'block');
    //    $scope.exportDataDownload(printID, downloadLink);
    //    $("#LoadingSpanExport").css('display', 'none');        
    //}
});

eApp.filter('unsafe', function ($sce) {
    return function (val) {
        return $sce.trustAsHtml(val);
    };
});

eApp.service("ServiceEmployeeDetailsList", function ($http, $rootScope) {
    var saveSts = '';
    var RspData = [];
    this.GetSet = function (formData) {
        saveSts = $http({
            data: formData,
            method: 'post',
            url: 'Handler/ITDirectory.ashx',
            datatype: "json"
        }).success(function (rsp) {
            RspData = rsp;
            return RspData;
        }).error(function (rsp) {
            alert('Error');
        });
        return saveSts;
    };
});

eApp.config(function ($translateProvider) {
    $translateProvider.translations('en', {

        TipNoteViewPostHistory: 'Click on Employee Name to view service history.',

        SNo: 'S.No.',
        EmpID: 'Emp ID',
        Employee: 'Employee',
        Designation: 'Designation',
        CurrentOffice: 'Current Office',
        CurrentDepartment: 'Current Department',
        CurrentPlace: 'Current Place',
        CurrentDistrict: 'Current District',
        ContactNo: 'Contact No.',
        Email: 'Email',
        Remarks: 'Remarks',

        EmployeeDetail: 'Employee Detail',
        EmployeeName: 'Employee Name :',
        FathersName: 'Fathers Name :',
        DetailDesignation: 'Designation :',
        Gender: 'Gender :',
        DateOfBirth: 'Date Of Birth :',
        DetailContactNo: 'Contact No. :',
        DetailEmail: 'Email :',
        SIPFID: 'SIPF ID :',
        PostingHistory: 'Posting History',
        AgainstPost: 'Against Post',
        Place: 'Place',
        FromDate: 'From Date',
        ToDate: 'To Date',
        TransferPostingOrderNo: 'Transfer / Appointment Order No. and Date',
        Remark: 'Remark'        
    });
    $translateProvider.translations('hi', {
        TipNoteViewPostHistory: 'कार्मिक का पदस्थापन इतिहास देखने के लिए नाम पर क्लिक करें.',
        SNo: 'क्र.सं.',
        EmpID: 'एम्पलॉय आईडी',
        Employee: 'कार्मिक',
        Designation: 'पदनाम',
        CurrentOffice: 'वर्तमान ऑफिस',
        CurrentDepartment: 'वर्तमान विभाग',
        CurrentPlace: 'वर्तमान स्थान',
        CurrentDistrict: 'वर्तमान ज़िला',
        ContactNo: 'संपर्क नं.',
        Email: 'ईमेल',
        Remarks: 'टिप्पणी',

        EmployeeDetail: 'कार्मिक विवरण',
        EmployeeName: 'कार्मिक का नाम :',
        FathersName: 'पिता का नाम :',
        DetailDesignation: 'पद :',
        Gender: 'लिंग :',
        DateOfBirth: 'जन्म दिनांक :',
        DetailContactNo: 'संपर्क नं. :',
        DetailEmail: 'ईमेल :',
        SIPFID: 'रा.बी.प्रा.नि.आईडी :',
        PostingHistory: 'पदस्थापन इतिहास',
        AgainstPost: 'पद के विरुद्ध',
        Place: 'स्थान',
        FromDate: 'दिनांक से',
        ToDate: 'दिनाक तक',
        TransferPostingOrderNo: 'स्थानांतरण / नियुक्ति आदेश क्रमांक व दिनांक',
        Remark: 'टिप्पणी'
    });
    $translateProvider.preferredLanguage('en');
});
