﻿using Newtonsoft.Json.Linq;
using SqlDBHelper;
using System;
using System.Collections.Generic;
using System.Data;
using System.Globalization;
using System.Linq;
using System.Net;
using System.Text;
using System.Web;
using System.Web.Script.Services;
using System.Web.Services;

/// <summary>
/// Summary description for TPSDataProvider
/// </summary>
[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
// [System.Web.Script.Services.ScriptService]
[ScriptService]
public class TPSDataProvider : System.Web.Services.WebService
{
    DataLayer myl = new DataLayer();
    ClsOutPut _output = new ClsOutPut();
    DataSet _dsRequestBody = new DataSet();
    string _returnMsg = string.Empty;

    string _inputDateFormat = "yyyyMMddHHmmss";


    public TPSDataProvider()
    {
        //Uncomment the following line if using designed components 
        //InitializeComponent(); 
    }

    [WebMethod]
    [ScriptMethod(UseHttpGet = false, ResponseFormat = ResponseFormat.Json)]
    public string Greetings(string name)
    {
        return "Hello " + name + ". Greetings!";
    }

    [WebMethod]
    [ScriptMethod(UseHttpGet = false, ResponseFormat = ResponseFormat.Json)]
    public void GetEmployeeList()
    {
        _output.Status = string.Empty;
        _output.RecordCount = string.Empty;
        _output.Message = string.Empty;
        _output.Data = string.Empty;

        DataSet ds = new DataSet();
        string thresholdDate = string.Empty;

        try
        {
            using (System.IO.Stream stream = HttpContext.Current.Request.InputStream)
            using (System.IO.StreamReader reader = new System.IO.StreamReader(stream))
            {
                stream.Seek(0, System.IO.SeekOrigin.Begin);
                string bodyText = reader.ReadToEnd(); //bodyText = bodyText == "" ? "{}" : bodyText;
                dynamic json = JObject.Parse(bodyText);
                thresholdDate = json.ThresholdDate;
            }

            //if (_dsRequestBody.Tables.Count == 0 && _dsRequestBody.Tables[0].Rows.Count == 1 && _dsRequestBody.Tables[0].Columns.Count == 1 && _dsRequestBody.Tables[0].Columns.Contains("ThresholdDate"))
            if(!string.IsNullOrEmpty(thresholdDate))
            {
                //string thresholdDate = _dsRequestBody.Tables[0].Rows[0][0].ToString();
                if (IsValidDate(thresholdDate, _inputDateFormat))
                {
                    ds = new APIProcedure().ByProcedure("USP_API_GET_EMPLOYEE_LIST_DIFFERENTIAL",
                                            new string[] { "thresholdDate" },
                                            new string[] { thresholdDate }, "USPADDSETTING");

                    if (ds.Tables.Count == 1 && ds.Tables[0].Rows.Count > 0)
                    {
                        _output.Status = Convert.ToString(Convert.ToInt32(HttpStatusCode.OK));
                        _output.Message = "Successfully Fetched.";
                        _output.RecordCount = ds.Tables[0].Rows.Count.ToString();
                        _output.Data = DataTableToJsonObj(ds.Tables[0]);
                    }
                    else
                    {
                        _output.Status = Convert.ToString(Convert.ToInt32(HttpStatusCode.OK));
                        _output.Message = "No data found.";
                        _output.RecordCount = "0";
                    }
                }
                else
                {
                    _output.Status = Convert.ToString(Convert.ToInt32(HttpStatusCode.BadRequest));
                    _output.Message = "Bad request: Input Date is not in expected format " + _inputDateFormat;
                }

            }
            else
            {
                _output.Status = Convert.ToString(Convert.ToInt32(HttpStatusCode.BadRequest));
                _output.Message = "Unable to process the request: Please check the provided Json data format OR its keys OR contact to administrator.";
            }
        }
        catch (Exception ex)
        {
            _output.Status = Convert.ToString(Convert.ToInt32(HttpStatusCode.InternalServerError));
            _output.Message = "Exception: " + ex.Message + " Inner Exception: " + ex.InnerException;
        }
        finally
        {
            HttpContext.Current.Response.Clear();
            HttpContext.Current.Response.ContentType = "application/json";
            HttpContext.Current.Response.Write(Newtonsoft.Json.JsonConvert.SerializeObject(_output));
            HttpContext.Current.Response.Flush();
            HttpContext.Current.Response.End();
            Context.Response.Write(_output);
        }
    }

    public bool IsValidDate(string dateString, string dateFormat)
    {
        DateTime outDate = new DateTime();
        return DateTime.TryParseExact(dateString, dateFormat, CultureInfo.CurrentCulture, DateTimeStyles.None, out outDate);
    }

    public string DataTableToJsonObj(DataTable dt)
    {
        DataSet ds = new DataSet();
        ds.Merge(dt);
        StringBuilder JsonString = new StringBuilder();
        if (ds != null && ds.Tables[0].Rows.Count > 0)
        {
            JsonString.Append("[");
            for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
            {
                JsonString.Append("{");
                for (int j = 0; j < ds.Tables[0].Columns.Count; j++)
                {
                    if (j < ds.Tables[0].Columns.Count - 1)
                    {
                        JsonString.Append("\"" + ds.Tables[0].Columns[j].ColumnName.ToString() + "\":" + "\"" + ds.Tables[0].Rows[i][j].ToString() + "\",");
                    }
                    else if (j == ds.Tables[0].Columns.Count - 1)
                    {
                        JsonString.Append("\"" + ds.Tables[0].Columns[j].ColumnName.ToString() + "\":" + "\"" + ds.Tables[0].Rows[i][j].ToString() + "\"");
                    }
                }
                if (i == ds.Tables[0].Rows.Count - 1)
                {
                    JsonString.Append("}");
                }
                else
                {
                    JsonString.Append("},");
                }
            }
            JsonString.Append("]");
            return JsonString.ToString();
        }
        else
        {
            return null;
        }
    }

}
class ClsOutPut
{
    public string Status { get; set; }
    public string Message { get; set; }
    public string RecordCount { get; set; }
    public string Data { get; set; }
}
