using System;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Globalization;
using System.Web.UI.WebControls;

/// <summary>
/// Summary description for DataAccess
/// </summary>
public class DataAccess
{

    public SqlConnection Conn = new SqlConnection();
    SqlCommand Comm = new SqlCommand();
    DataSet Ds = new DataSet();
    DataSet Ds1 = new DataSet();
    SqlDataAdapter daptr = new SqlDataAdapter();
    DataTable dt = new DataTable();
    IFormatProvider Culture = new CultureInfo("fr-FR", true);

    public enum Orderby
    {
        Asc, Desc
    }
    public DataAccess()
    {
        //
        // TODO: Add constructor logic here
        //
    }
    public void OpenConnection()
    {
        if (Conn.State == ConnectionState.Open)
        {
            try { Conn.Close(); }
            catch { }
            finally { Conn.Close(); }
        }
        SqlConnectionStringBuilder builder = new SqlConnectionStringBuilder(ConfigurationManager.ConnectionStrings["conn"].ConnectionString.ToString());
        Conn.ConnectionString = builder.ConnectionString;
        Conn.Open();
    }
    public void closeconnection()
    {
        try { Conn.Close(); }
        catch { }
        finally { Conn.Close(); }
    }
    public void ClearParameters()
    {
        Comm.Parameters.Clear();
    }
    public void fillDataList(string sSql, DataList dtLst)
    {
        try
        {
            dtLst.Equals("");
            OpenConnection();
            Comm.CommandText = sSql;
            daptr.SelectCommand = Comm;
            Comm.Connection = Conn;
            Ds.Clear();
            daptr.Fill(Ds, "table");
            dtLst.DataSource = Ds;
            dtLst.DataBind();
            //Conn.Close();
        }
        catch (Exception ex) { }
        finally { Conn.Close(); }
    }
    public void fillGridViewtosp(string sSql, GridView grdnm)
    {
        try
        {
            //grdnm.Sorted();
            grdnm.Equals("");

            OpenConnection();
            Comm.CommandText = sSql;
            Comm.CommandType = CommandType.StoredProcedure;
            daptr.SelectCommand = Comm;
            Comm.Connection = Conn;
            Ds.Clear();
            daptr.Fill(Ds, "table");
            grdnm.DataSource = Ds;
            grdnm.DataBind();
            //grdnm.DataBinding();
            daptr.Dispose();
            //Conn.Close();
        }
        catch (Exception ex)
        {
            ClearParameters();
            Problem("Fails");
        }
        finally { Conn.Close(); }
    }


    public DataTable fillGridView1(string sSql, GridView grdnm)
    {
        try
        {
            grdnm.Equals("");
            OpenConnection();
            Comm.CommandText = sSql;
            Comm.CommandType = CommandType.Text;
            daptr.SelectCommand = Comm;
            Comm.Connection = Conn;
            Ds.Clear();
            daptr.Fill(Ds, "table");
            grdnm.DataSource = Ds;
            grdnm.DataBind();
            daptr.Dispose();
            return ((DataTable)Ds.Tables[0]);
        }
        finally
        {
            Conn.Close();
        }
    }

    public DataView fillGridViewSorted(DataTable dt, string Order, GridView grdnm)
    {
        DataView myDataView = new DataView();

        if (dt != null)
        {
            if (dt.Rows.Count > 0)
            {

                myDataView = dt.DefaultView;
                myDataView.Sort = Order;
                grdnm.DataSource = myDataView;
                grdnm.DataBind();
            }

        }
        return myDataView;

    }

    public DataTable FillDataTable(String sql)
    {
        try
        {
            OpenConnection();
            DataTable dtt = new DataTable();
            dtt.Clear();
            Comm.CommandType = CommandType.Text;
            Comm.CommandText = sql;
            Comm.Connection = Conn;
            daptr.SelectCommand = Comm;
            daptr.Fill(dtt); return dtt;
        }
        finally
        {
            Conn.Close();
        }
    }


    public DataSet GetData(string GetSql, DataSet DSS, string tbname)
    {
        try
        {
            OpenConnection();
            Comm.CommandText = GetSql;
            Comm.Connection = Conn;
            Comm.CommandType = CommandType.Text;
            daptr.SelectCommand = Comm;
            //  DSS.Clear();
            daptr.Fill(DSS, tbname);
            return DSS;
        }
        catch (Exception ex)
        {
            return DSS;
        }
    }
    public DataSet GetDatatrn(string GetSql, DataSet DSS)
    {
        // OpenConnection();
        Comm.CommandText = GetSql;
        Comm.Connection = Conn;
        Comm.CommandType = CommandType.Text;
        daptr.SelectCommand = Comm;
        DSS.Clear();
        daptr.Fill(DSS, "Table");
        return DSS;
    }
    public DataSet GetDatatrn(string GetSql, DataSet DSS, string tbname)
    {
        // OpenConnection();
        Comm.CommandText = GetSql;
        Comm.Connection = Conn;
        Comm.CommandType = CommandType.Text;
        daptr.SelectCommand = Comm;
        // DSS.Clear();
        daptr.Fill(DSS, tbname);
        return DSS;
    }
    public DataSet GetData(DataSet DSS, string sp)
    {
        OpenConnection();
        Comm.CommandText = sp;
        Comm.Connection = Conn;
        Comm.CommandType = CommandType.StoredProcedure;
        daptr.SelectCommand = Comm;
        DSS.Clear();
        daptr.Fill(DSS, "Table");
        return DSS;
    }

    public string Save1(string SpName, string action)
    {
        try
        {
            Comm.Parameters.Add("@action", action);
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = SpName;
            Comm.CommandType = CommandType.StoredProcedure;
            Comm.ExecuteNonQuery();
            return ("Successfully Saved.");
        }
        catch (Exception ex)
        {
            ClearParameters();
            Problem("Fails");
            return ("Fails :");
        }
        finally { Conn.Close(); }
    }

    public SqlTransaction trn()
    {
        SqlTransaction mytrn = Conn.BeginTransaction();
        Comm.Transaction = mytrn;
        return mytrn;
    }

    public string Save(string SpName, string action)
    {
        try
        {
            Comm.Parameters.Add("@action", action);
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = SpName;
            Comm.CommandType = CommandType.StoredProcedure;
            Comm.ExecuteNonQuery();
            //Conn.Close();
            return ("Successfully Saved.");
        }
        catch (Exception ex)
        {
            ClearParameters();
            Problem("Fails.");
            return ("Fails :");
        }
        finally { Conn.Close(); }
    }
    public string Savetrn(string SpName, string action)
    {
        try
        {
            Comm.Parameters.Add("@action", action);
            //OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = SpName;
            Comm.CommandType = CommandType.StoredProcedure;
            Comm.ExecuteNonQuery();
            //  Conn.Close();
            return ("Successfully Saved.");
        }
        catch (Exception ex)
        {
            ClearParameters();
            Problem(ex.ToString());
            return ("Fails :");
        }
        //finally { Conn.Close(); }
    }
    public string RetValueFromQry(string qry)
    {
        try
        {
            OpenConnection();
            SqlDataReader rdr;
            Comm.CommandType = CommandType.Text;
            Comm.CommandText = qry;
            Comm.Connection = Conn;
            rdr = Comm.ExecuteReader(CommandBehavior.CloseConnection);
            if (rdr.Read())
            {
                return (Convert.ToString(rdr[0]));
            }
            else
                return ("0");
        }
        catch (Exception ex)
        {
            ClearParameters();
            Problem("Fails");
            return ("Fails :");
        }

    }
    public string RetValueFromQry1(string qry)
    {
        try
        {
            OpenConnection();

            SqlDataReader rdr;
            Comm.CommandType = CommandType.Text;
            Comm.CommandText = qry;
            Comm.Connection = Conn;
            rdr = Comm.ExecuteReader(CommandBehavior.CloseConnection);
            if (rdr.Read())
            {
                return (Convert.ToString(rdr[0]));
            }
            else
                return ("");
        }
        catch (Exception ex)
        {
            ClearParameters();
            Problem("fails");
            return ("Fails :");
        }

    }
    public string RetValueFromQrytrn(string qry)
    {
        try
        {
            // OpenConnection();
            Comm.CommandType = CommandType.Text;
            Comm.CommandText = qry;
            Comm.Connection = Conn;

            daptr.SelectCommand = Comm;
            DataSet DS = new DataSet();
            DS.Clear();
            daptr.Fill(DS, "Table");
            if (DS.Tables["Table"].Rows.Count > 0)
                return (Convert.ToString(DS.Tables["Table"].Rows[0][0].ToString()));
            else
                return ("");
        }
        catch (Exception ex)
        {
            ClearParameters();
            Problem("Fails.");
            return ("Fails :");
        }
    }

    public void AddParameters(String Field, object Value)
    {
        Comm.Parameters.Add(new SqlParameter(Field, Value));
    }
    public void AddParameters(String Field, object Value, SqlDbType typ, int siz)
    {
        SqlParameter myParameter = new SqlParameter(Field, typ, siz);
        myParameter.Value = Value;
        // myParameter
        //   myParameter.IsNullable = true; 
        Comm.Parameters.Add(myParameter);
    }
    public void AddParameters(String Field, object Value, SqlDbType typ)
    {
        SqlParameter myParameter = new SqlParameter(Field, typ);
        myParameter.Value = Value;
        // myParameter
        //   myParameter.IsNullable = true; 
        Comm.Parameters.Add(myParameter);
    }
    public void AddParameters(SqlParameter Field)
    {
        Comm.Parameters.Add(Field);
    }
    //public string GetParameterValue(String Field)
    //{
    //    return (Comm.Parameters[Field].Value.ToString());
    //}
    public string ExecuteRecord(String sSql)
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandType = CommandType.Text;
            Comm.CommandText = sSql;
            Comm.ExecuteNonQuery();
            //Conn.Close();
            return ("Success");
        }
        catch (Exception ex)
        {
            ClearParameters();
            Problem("Fails");
            return ("Fail :");
        }
        finally { Conn.Close(); }
    }
    public string ExecuteRecordtrn(String sSql)
    {
        try
        {
            // OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandType = CommandType.Text;
            Comm.CommandText = sSql;
            Comm.ExecuteNonQuery();
            // Conn.Close();
            return ("Success");
        }
        catch (Exception ex)
        {
            ClearParameters();
            Problem("Fails");
            return ("Fail :");
        }
    }
    public string Problem(string pr)
    {
        try
        {
            Comm.Parameters.Add("@Problem", pr);
            //OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "Set_Tbl_Problem";
            Comm.CommandType = CommandType.StoredProcedure;
            Comm.ExecuteNonQuery();
            // Conn.Close();
            return ("Successfully Saved.");
        }
        catch (Exception ex)
        {
            return ("Fails :");
        }
    }
    public void FillCheckBoxLst(CheckBoxList chkLst, String isql, string strValueField, string strTextField)
    {
        try
        {
            OpenConnection();
            SqlDataReader drFillCombo;
            // isql = isql + " where deleted=0";
            Comm.Connection = Conn;
            Comm.CommandType = CommandType.Text;
            Comm.CommandText = isql;
            //Comm.CommandType = CommandType.Text;
            drFillCombo = Comm.ExecuteReader();
            chkLst.DataSource = drFillCombo;
            chkLst.DataValueField = strValueField;
            chkLst.DataTextField = strTextField;
            chkLst.DataBind();
            drFillCombo.Close();
            //Conn.Close();
        }
        catch (Exception rx)
        { }
        finally { Conn.Close(); }
    }

    //***************************************
    public DataTable GetDistinct(string table, DataTable source, string field)
    {
        //new DataTable to hold the distinct values
        DataTable newDT = new DataTable(table);

        //add a new column to the DataTable (column we are searching in)
        newDT.Columns.Add(field, source.Columns[field].DataType);

        //get an array of DataRows that match the search criteria
        DataRow[] rows = source.Select("", field);

        object value = null;

        //loop through all the rows
        foreach (DataRow row in rows)
        {
            if (value == null || !(AreEqual(value, row[field])))
            {
                value = row[field];
                newDT.Rows.Add(new object[] { value });

            }
        }
        return newDT;
    }

    /// <summary>
    /// method to compare two objects to see if they are equal (also handles DBNull.Value values)
    /// </summary>
    /// <param name="obj1">object we're comparing to</param>
    /// <param name="obj2">object we're comparing</param>
    /// <returns></returns>
    private bool AreEqual(object obj1, object obj2)
    {
        //both columns are DBNull.Value
        if (object.ReferenceEquals(obj1, DBNull.Value) & object.ReferenceEquals(obj2, DBNull.Value))
            return true;
        //only one column is DBNull.Value
        if (object.ReferenceEquals(obj1, DBNull.Value) | object.ReferenceEquals(obj2, DBNull.Value))
            return false;

        //if we make it this far then we just do a standard comparison
        return obj1 == obj2;
    }
    //*****************************************
    public bool chkdate(string dt)
    {


        try
        {
            DateTime dts = Convert.ToDateTime(dt.ToString(), Culture);

            return true;
        }
        catch
        {
            return false;
        }
    }
    public SqlDataReader readData(string sql)
    {
        SqlDataReader rdr;
        try
        {
            OpenConnection();
            Comm.CommandType = CommandType.Text;
            Comm.CommandText = sql;
            Comm.Connection = Conn;
            rdr = Comm.ExecuteReader(CommandBehavior.CloseConnection);
            return rdr;

        }
        catch (Exception ex)
        {
            throw ex;
        }
    }

    //#region  for SMS functions
    ////********************************************************************************************sms****************************
    //public int sendsmstodistrict(string evnt, string msg, string desgtype, string dist, string path, TextWriter tw, TextWriter twivrs, int smscount)
    //{
    //    DataSet dsms = new DataSet();
    //    string qry = "select distinct mobile_no, landline_no, ivrs_mobile_act, ivrs_landline_act, sms_mobile_act from trn_permsn_sms left outer join trn_sms_contacts on trn_sms_contacts.designation_id = trn_permsn_sms.designation_id  where " + evnt + " = 1 and district_code in (" + dist + ") and contact_type = 'D' ";
    //    GetDatatrn(qry, dsms);
    //    // string path = Server.MapPath("~\\admin\\smsfile.txt");
    //    //TextWriter tw = new StreamWriter(path);

    //    for (int i = 0; i < dsms.Tables[0].Rows.Count; i++)
    //    {
    //        // tw.NewLine = "\r\n";
    //        if (dsms.Tables[0].Rows[i]["sms_mobile_act"].ToString() == "Y")
    //        {
    //            smscount += 1;
    //            // tw.WriteLine("0000000000000" + smscount + " " + DateTime.Now.Date.ToString("dd/MM/yyyy") + " " + DateTime.Now.Date.ToString("hh") + ":" + DateTime.Now.Date.ToString("mm") + " " + evnt + " "  + dsms.Tables[0].Rows[i]["mobile_no"].ToString() +" "+ msg);
    //            tw.WriteLine("0000000000000" + smscount + " " + DateTime.Now.Date.ToString("dd/MM/yyyy") + " " + DateTime.Now.Date.ToString("hh") + ":" + DateTime.Now.Date.ToString("mm") + " " + evnt + " 8560911000 " + msg);
    //            // tw.WriteLine(msg);
    //            tw.NewLine = "\r\n";
    //        }
    //    }
    //    // tw.Close();
    //    return smscount;

    //}
    //public int sendsmstoblock(string evnt, string msg, string desgtype, string dist, string block, string path, TextWriter tw, TextWriter twivrs, int smscount)
    //{
    //    DataSet dsms = new DataSet();
    //    string qry = "select distinct mobile_no, landline_no, ivrs_mobile_act, ivrs_landline_act, sms_mobile_act from trn_permsn_sms left outer join trn_sms_contacts on trn_sms_contacts.designation_id = trn_permsn_sms.designation_id  where " + evnt + " = 1 and district_code in (" + dist + ") and block_code in (" + block + ")  and contact_type = 'B' ";
    //    GetDatatrn(qry, dsms);
    //    // string path = Server.MapPath("~\\admin\\smsfile.txt");
    //    // TextWriter tw = new StreamWriter(path);
    //    for (int i = 0; i < dsms.Tables[0].Rows.Count; i++)
    //    {
    //        // tw.NewLine = "\r\n";
    //        if (dsms.Tables[0].Rows[i]["sms_mobile_act"].ToString() == "Y")
    //        {
    //            smscount += 1;
    //            tw.WriteLine("0000000000000" + smscount + " " + DateTime.Now.Date.ToString("dd/MM/yyyy") + " " + DateTime.Now.Hour.ToString() + ":" + DateTime.Now.Minute.ToString() + " " + evnt + " " + dsms.Tables[0].Rows[i]["mobile_no"].ToString() + " " + msg);
    //            // tw.WriteLine(msg);
    //            tw.NewLine = "\r\n";
    //        }

    //    }
    //    // tw.Close();
    //    return smscount;
    //}
    //public int sendsmstopanchayat(string evnt, string msg, string desgtype, string dist, string block, string panchayat, string path, TextWriter tw, TextWriter twivrs, int smscount)
    //{
    //    DataSet dsms = new DataSet();
    //    string qry = "select distinct mobile_no, landline_no, ivrs_mobile_act, ivrs_landline_act, sms_mobile_act from trn_permsn_sms left outer join trn_sms_contacts on trn_sms_contacts.designation_id = trn_permsn_sms.designation_id  where " + evnt + " = 1 and district_code in (" + dist + ") and block_code in (" + block + ") and panchayat_code in (" + panchayat + ")  and contact_type = 'P'  ";
    //    GetDatatrn(qry, dsms);

    //    // string path = Server.MapPath("~\\admin\\smsfile.txt");
    //    //TextWriter tw = new StreamWriter(path);
    //    for (int i = 0; i < dsms.Tables[0].Rows.Count; i++)
    //    {
    //        //  tw.NewLine = "\r\n";
    //        if (dsms.Tables[0].Rows[i]["sms_mobile_act"].ToString() == "Y")
    //        {
    //            smscount += 1;
    //            tw.WriteLine("0000000000000" + smscount + " " + DateTime.Now.Date.ToString("dd/MM/yyyy") + " " + DateTime.Now.Date.ToString("hh") + ":" + DateTime.Now.Date.ToString("ss") + " " + evnt + " " + dsms.Tables[0].Rows[i]["mobile_no"].ToString() + " " + msg);
    //            // tw.WriteLine(msg);
    //            tw.NewLine = "\r\n";
    //        }

    //    }
    //    // tw.Close();
    //    return smscount;
    //}

    //public int sendsmstovillage(string evnt, string msg, string desgtype, string dist, string block, string panchayat, string village, string path, TextWriter tw, TextWriter twivrs, int smscount)
    //{
    //    DataSet dsms = new DataSet();
    //    string qry = "select distinct  mobile_no, landline_no, ivrs_mobile_act, ivrs_landline_act, sms_mobile_act from trn_permsn_sms left outer join trn_sms_contacts on trn_sms_contacts.designation_id = trn_permsn_sms.designation_id  where " + evnt + " = 1 and district_code in (" + dist + ") and block_code in (" + block + ") and panchayat_code in (" + panchayat + ") and village_code in (" + village + ")  and contact_type = 'V'  ";
    //    GetDatatrn(qry, dsms);
    //    //   string path = Server.MapPath("~\\admin\\smsfile.txt");
    //    // TextWriter tw = new StreamWriter(path);
    //    for (int i = 0; i < dsms.Tables[0].Rows.Count; i++)
    //    {
    //        // tw.NewLine = "\r\n";

    //        if (dsms.Tables[0].Rows[i]["sms_mobile_act"].ToString() == "Y")
    //        {
    //            smscount += 1;
    //            tw.WriteLine("0000000000000" + smscount + " " + DateTime.Now.Date.ToString("dd/MM/yyyy") + " " + DateTime.Now.Hour.ToString() + ":" + DateTime.Now.Minute.ToString() + " " + evnt + " " + dsms.Tables[0].Rows[i]["mobile_no"].ToString() + " " + msg);
    //            // tw.WriteLine(msg);
    //            tw.NewLine = "\r\n";
    //        }
    //        if (dsms.Tables[0].Rows[i]["ivrs_landline_act"].ToString() == "Y")
    //        {
    //            twivrs.WriteLine(HttpUtility.HtmlEncode(dsms.Tables[0].Rows[i]["mobile_no"].ToString()) + HttpUtility.HtmlEncode(msg));
    //            // tw.WriteLine(msg);
    //            twivrs.NewLine = "\r\n";
    //        }

    //    }
    //    //    tw.Close();
    //    return smscount;
    //}

    ////*************************************************

    //public int sendsmstodistrict(string evnt, string msg, string desgtype, string dist, string path, TextWriter tw, TextWriter twivrs, string ivrsmsg, int smscount)
    //{
    //    DataSet dsms = new DataSet();
    //    string qry = "select distinct mobile_no, landline_no, ivrs_mobile_act, ivrs_landline_act, sms_mobile_act from trn_permsn_sms left outer join trn_sms_contacts on trn_sms_contacts.designation_id = trn_permsn_sms.designation_id  where " + evnt + " = 1 and district_code in (" + dist + ") and contact_type = 'D' ";
    //    GetDatatrn(qry, dsms);
    //    // string path = Server.MapPath("~\\admin\\smsfile.txt");
    //    //TextWriter tw = new StreamWriter(path);

    //    for (int i = 0; i < dsms.Tables[0].Rows.Count; i++)
    //    {
    //        // tw.NewLine = "\r\n";
    //        if (dsms.Tables[0].Rows[i]["sms_mobile_act"].ToString() == "Y")
    //        {
    //            smscount += 1;
    //            tw.WriteLine("0000000000000" + smscount + " " + DateTime.Now.Date.ToString("dd/MM/yyyy") + " " + DateTime.Now.Hour.ToString() + ":" + DateTime.Now.Minute.ToString() + " " + evnt + " " + dsms.Tables[0].Rows[i]["mobile_no"].ToString() + " " + msg);
    //            // tw.WriteLine(msg);
    //            tw.NewLine = "\r\n";
    //        }
    //        if (dsms.Tables[0].Rows[i]["ivrs_landline_act"].ToString() == "Y")
    //        {
    //            twivrs.WriteLine(HttpUtility.HtmlEncode(dsms.Tables[0].Rows[i]["landline_no"].ToString()) + HttpUtility.HtmlEncode(ivrsmsg));
    //            // tw.WriteLine(msg);
    //            twivrs.NewLine = "\r\n";
    //        }
    //    }
    //    // tw.Close();
    //    return smscount;

    //}
    //public int sendsmstoblock(string evnt, string msg, string desgtype, string dist, string block, string path, TextWriter tw, TextWriter twivrs, string ivrsmsg, int smscount)
    //{
    //    DataSet dsms = new DataSet();
    //    string qry = "select distinct mobile_no, landline_no, ivrs_mobile_act, ivrs_landline_act, sms_mobile_act from trn_permsn_sms left outer join trn_sms_contacts on trn_sms_contacts.designation_id = trn_permsn_sms.designation_id  where " + evnt + " = 1 and district_code in (" + dist + ") and block_code in (" + block + ")  and contact_type = 'B' ";
    //    GetDatatrn(qry, dsms);
    //    // string path = Server.MapPath("~\\admin\\smsfile.txt");
    //    // TextWriter tw = new StreamWriter(path);
    //    for (int i = 0; i < dsms.Tables[0].Rows.Count; i++)
    //    {
    //        // tw.NewLine = "\r\n";
    //        if (dsms.Tables[0].Rows[i]["sms_mobile_act"].ToString() == "Y")
    //        {
    //            smscount += 1;
    //            tw.WriteLine("0000000000000" + smscount + " " + DateTime.Now.Date.ToString("dd/MM/yyyy") + " " + DateTime.Now.Hour.ToString() + ":" + DateTime.Now.Minute.ToString() + " " + evnt + " " + dsms.Tables[0].Rows[i]["mobile_no"].ToString() + " " + msg);
    //            // tw.WriteLine(msg);
    //            tw.NewLine = "\r\n";
    //        }

    //        if (dsms.Tables[0].Rows[i]["ivrs_landline_act"].ToString() == "Y")
    //        {
    //            twivrs.WriteLine(HttpUtility.HtmlEncode(dsms.Tables[0].Rows[i]["landline_no"].ToString()) + HttpUtility.HtmlEncode(ivrsmsg));
    //            // tw.WriteLine(msg);
    //            twivrs.NewLine = "\r\n";
    //        }

    //    }
    //    // tw.Close();
    //    return smscount;

    //}
    //public int sendsmstopanchayat(string evnt, string msg, string desgtype, string dist, string block, string panchayat, string path, TextWriter tw, TextWriter twivrs, string ivrsmsg, int smscount)
    //{
    //    DataSet dsms = new DataSet();
    //    string qry = "select distinct mobile_no, landline_no, ivrs_mobile_act, ivrs_landline_act, sms_mobile_act from trn_permsn_sms left outer join trn_sms_contacts on trn_sms_contacts.designation_id = trn_permsn_sms.designation_id  where " + evnt + " = 1 and district_code in (" + dist + ") and block_code in (" + block + ") and panchayat_code in (" + panchayat + ")  and contact_type = 'P'  ";
    //    GetDatatrn(qry, dsms);

    //    // string path = Server.MapPath("~\\admin\\smsfile.txt");
    //    //TextWriter tw = new StreamWriter(path);
    //    for (int i = 0; i < dsms.Tables[0].Rows.Count; i++)
    //    {
    //        //  tw.NewLine = "\r\n";
    //        if (dsms.Tables[0].Rows[i]["sms_mobile_act"].ToString() == "Y")
    //        {
    //            smscount += 1;
    //            tw.WriteLine("0000000000000" + smscount + " " + DateTime.Now.Date.ToString("dd/MM/yyyy") + " " + DateTime.Now.Hour.ToString() + ":" + DateTime.Now.Minute.ToString() + " " + evnt + " " + dsms.Tables[0].Rows[i]["mobile_no"].ToString() + " " + msg);
    //            // tw.WriteLine(msg);
    //            tw.NewLine = "\r\n";
    //        }
    //        if (dsms.Tables[0].Rows[i]["ivrs_landline_act"].ToString() == "Y")
    //        {
    //            twivrs.WriteLine(HttpUtility.HtmlEncode(dsms.Tables[0].Rows[i]["landline_no"].ToString()) + HttpUtility.HtmlEncode(ivrsmsg));
    //            // tw.WriteLine(msg);
    //            twivrs.NewLine = "\r\n";
    //        }

    //    }
    //    return smscount;
    //    // tw.Close();

    //}

    //public int sendsmstovillage(string evnt, string msg, string desgtype, string dist, string block, string panchayat, string village, string path, TextWriter tw, TextWriter twivrs, string ivrsmsg, int smscount)
    //{
    //    DataSet dsms = new DataSet();
    //    string qry = "select distinct  mobile_no, landline_no, ivrs_mobile_act, ivrs_landline_act, sms_mobile_act from trn_permsn_sms left outer join trn_sms_contacts on trn_sms_contacts.designation_id = trn_permsn_sms.designation_id  where " + evnt + " = 1 and district_code in (" + dist + ") and block_code in (" + block + ") and panchayat_code in (" + panchayat + ") and village_code in (" + village + ")  and contact_type = 'V'  ";
    //    GetDatatrn(qry, dsms);
    //    //   string path = Server.MapPath("~\\admin\\smsfile.txt");
    //    // TextWriter tw = new StreamWriter(path);
    //    for (int i = 0; i < dsms.Tables[0].Rows.Count; i++)
    //    {
    //        // tw.NewLine = "\r\n";
    //        if (dsms.Tables[0].Rows[i]["sms_mobile_act"].ToString() == "Y")
    //        {
    //            smscount += 1;
    //            tw.WriteLine("0000000000000" + smscount + " " + DateTime.Now.Date.ToString("dd/MM/yyyy") + " " + DateTime.Now.Hour.ToString() + ":" + DateTime.Now.Minute.ToString() + " " + evnt + " " + dsms.Tables[0].Rows[i]["mobile_no"].ToString() + " " + msg);
    //            // tw.WriteLine(msg);
    //            tw.NewLine = "\r\n";
    //        }
    //        if (dsms.Tables[0].Rows[i]["ivrs_landline_act"].ToString() == "Y")
    //        {
    //            twivrs.WriteLine(HttpUtility.HtmlEncode(dsms.Tables[0].Rows[i]["landline_no"].ToString()) + HttpUtility.HtmlEncode(ivrsmsg));
    //            // tw.WriteLine(msg);
    //            twivrs.NewLine = "\r\n";
    //        }

    //    }
    //    //    tw.Close();
    //    return smscount;
    //}
    ////***********************************************************8

    //#endregion

    //BSR

    public string AddEditLabourType()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditLabourType";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            //Conn.Close();
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditLabourRates()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditLabourRates";
            //Comm.CommandText = "spTemp";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string EnterProposedDate()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spEnterProposedDate";
            //Comm.CommandText = "spTemp";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditTaskMaster()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditTaskMaster";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditEWMaster()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditEWMaster";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string UpdateremarkEWMaster()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spUpdateremarkEWMaster";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string UpdateremarkTaskMaster()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spUpdateremarkTaskMaster";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string UpdateremarkEstimat()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spUpdateremarkEstimat";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }


    public DataSet GetData(string GetSql, DataSet DSS)
    {
        try
        {
            OpenConnection();
            Comm.CommandText = GetSql;
            Comm.Connection = Conn;
            Comm.CommandType = CommandType.Text;
            daptr.SelectCommand = Comm;
            DSS.Clear();
            daptr.Fill(DSS, "Table");
            return DSS;
        }
        catch (Exception ex)
        {
            return null;
        }
    }

    public void FillDropDown(DropDownList Ddl, string isql, string strValueField, string strTextField)
    {
        try
        {
            OpenConnection();

            SqlDataReader drFillDdl;
            //SqlCommand cmdFillDdl = new SqlCommand(isql, Conn);
            Comm.CommandType = CommandType.Text;
            Comm.CommandText = isql;
            Comm.Connection = Conn;
            drFillDdl = Comm.ExecuteReader();
            Ddl.DataSource = drFillDdl;
            Ddl.DataValueField = strValueField;
            Ddl.DataTextField = strTextField;
            Ddl.DataBind();
            drFillDdl.Close();
        }
        catch { }
        finally { Conn.Close(); }
    }

    public void fillGridView(string sSql, GridView grdnm)
    {
        try
        {
            //grdnm.Sorted();
            grdnm.Equals("");
            OpenConnection();
            Comm.CommandText = sSql;
            Comm.CommandType = CommandType.Text;
            daptr.SelectCommand = Comm;
            Comm.Connection = Conn;
            Ds.Clear();
            daptr.Fill(Ds, "table");
            grdnm.DataSource = Ds;
            grdnm.DataBind();
            //grdnm.DataBinding();
            daptr.Dispose();
        }
        catch (Exception ex)
        {
            ClearParameters();
            Problem(ex.ToString());
        }
        finally { Conn.Close(); }
    }


    public string AddEditMaterial()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditMaterial";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditExtraCharge()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditExtraCharge";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditMarquee()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditMarquee";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditEqvipment()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditEqvipment";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditFY()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditFY";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditPercent()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditPercent";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditMatRates()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditMatRates";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditPriviligeMatRates()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditPriviligeMatRates";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditEqvipmentRates()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditEqvipmentRates";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string EditMatRates()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spEditMatRates";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string EditEqvipmentRates()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spEditEqvipmentRates";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string EditMaterialTodate()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spEditMaterialTodate";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }


    public string EditEqvipmentTodate()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spEditEqvipmentTodate";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditTransactionTaskEstimate()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditTransactionTaskEstimate";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditTransactionTaskLabour()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditTransactionTaskLabour";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditTransactionTaskMaterial()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditTransactionTaskMaterial";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditTransactionEstimate()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditTransactionEstimate";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditTransactionTaskExtraCharges()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditTransactionTaskExtraCharges";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditTransactionTaskEqvipment()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditTransactionTaskEqvipment";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }


    public string AddEditStateLabourRates()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditStateLabourRates";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string EditLabourTodate()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spEditLabourTodate";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string EditStateLabourTodate()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spEditStateLabourTodate";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string EditLabourRates()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spEditLabourRates";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string EditStateLabourRates()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spEditStateLabourRates";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }



    public string Updatetrntaskmaterial()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spUpdatetrntaskmaterial";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string UpdatetrntaskEstimate()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spUpdatetrntaskEstimate";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string Updatetrntasklabour()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spUpdatetrntasklabour";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }
    public string Updatetrntaskextracharge()
    {

        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spUpdatetrntaskextracharge";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string Updatetrntaskeqvipment()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spUpdatetrntaskeqvipment";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }



    public string Updatetaskdescription()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spUpdatetaskdescription";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEdittrntasktransport()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEdittrntasktransport";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public void FillCheckBoxLst_sp(CheckBoxList chkLst, String sp, string strValueField, string strTextField)
    {
        try
        {
            OpenConnection();
            SqlDataReader drFillCombo;
            // isql = isql + " where deleted=0";
            Comm.Connection = Conn;
            Comm.CommandType = CommandType.StoredProcedure;
            Comm.CommandText = sp;
            //Comm.CommandType = CommandType.Text;
            drFillCombo = Comm.ExecuteReader();
            chkLst.DataSource = drFillCombo;
            chkLst.DataValueField = strValueField;
            chkLst.DataTextField = strTextField;
            chkLst.DataBind();
            drFillCombo.Close();
        }
        catch (Exception rx) { }
        finally { Conn.Close(); }
    }

    public DataSet filldata(string strsql)
    {
        try
        {
            DataSet ds = new DataSet();
            OpenConnection();
            Comm.CommandType = CommandType.Text;
            Comm.CommandText = strsql;
            Comm.Connection = Conn;
            daptr.SelectCommand = Comm;
            daptr.Fill(ds);
            return ds;
        }
        finally
        {
            Conn.Close();
        }
    }

    public string Save(string SpName, string action, SqlTransaction sqtr)
    {
        try
        {
            Comm.Parameters.Add("@action", action);
            OpenConnection();
            sqtr = Conn.BeginTransaction();
            Comm.Connection = Conn;
            Comm.Transaction = sqtr;
            Comm.CommandText = SpName;
            Comm.CommandType = CommandType.StoredProcedure;
            Comm.ExecuteNonQuery();
            return ("Successfully Saved.");
        }
        catch (Exception ex)
        {
            ClearParameters();
            Problem("Fails");
            return ("Fails :");
        }
        finally { Conn.Close(); }
    }

    public SqlDataReader readDatatrn(string sql)
    {
        SqlDataReader rdr;
        try
        {
            Comm.CommandType = CommandType.Text;
            Comm.CommandText = sql;
            Comm.Connection = Conn;
            rdr = Comm.ExecuteReader();
            return rdr;
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }

    public SqlDataReader readRecords(string sql)
    {
        SqlDataReader rdr;
        try
        {
            OpenConnection();
            Comm.CommandText = sql;
            Comm.CommandType = CommandType.StoredProcedure;
            Comm.Connection = Conn;
            rdr = Comm.ExecuteReader(CommandBehavior.CloseConnection);
            return rdr;
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }
    public string createMenuN()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "sp_CreateMenu";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = Comm.ExecuteNonQuery();
            if (res > 0)
            {
                return ("Menu Created Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            Problem("Fails");
            return ("Fails :");
        }
        finally { Conn.Close(); }
    }

    public string updateMenuOrder(int order, int menuid)
    {
        try
        {
            Comm.Parameters.Add("@order", order);
            Comm.Parameters.Add("@menuId", menuid);
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "sp_UpdateMenuOrder";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = Comm.ExecuteNonQuery();
            if (res > 0)
            {
                return ("Menu order updated Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            Problem("Fails");
            return ("Fails :");
        }
        finally { Conn.Close(); }
    }


    public string Updatetaskdetail()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spUpdatetaskdetail";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string AddEditapprovebsr()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spAddEditapprovebsr";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }

    public string updateBlockLabourApprovaldate()
    {
        try
        {
            OpenConnection();
            Comm.Connection = Conn;
            Comm.CommandText = "spupdateBlockLabourApprovaldate";
            Comm.CommandType = CommandType.StoredProcedure;
            int res = int.Parse(Comm.ExecuteScalar().ToString());
            if (res > 0)
            {
                return ("Successfully");
            }
            else
            {
                return ("failed");
            }
        }
        catch (Exception ex)
        {
            ClearParameters();
            return ("Fails. Try Again.");
        }
        finally { Conn.Close(); }
    }
}
