﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Specialized;
using System.Data;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Web;


/// <summary>
/// Summary description for BSR_Verify
/// </summary>
public class CommonServices
{
    public  CommonServices()
    {
    }   

    public static  DataTable GetLaberData( string bhamashsid)
    {
        DataTable dt = new DataTable();
        try
        {
            dt.Columns.Add(new DataColumn("AdharCard"));
            dt.Columns.Add(new DataColumn("Name"));
            dt.Columns.Add(new DataColumn("Father"));
            dt.Columns.Add(new DataColumn("DOB"));
            dt.Columns.Add(new DataColumn("Gender"));

            var request = (System.Net.HttpWebRequest)System.Net.WebRequest.Create("http://10.68.5.26:8080/Service/details/familydetails/" + bhamashsid);
            var response = (System.Net.HttpWebResponse)request.GetResponse();
            var responseString = new StreamReader(response.GetResponseStream()).ReadToEnd();
            System.Collections.Generic.Dictionary<string, object> values = JsonConvert.DeserializeObject<System.Collections.Generic.Dictionary<string, object>>(responseString);
            int total_family = ((Newtonsoft.Json.Linq.JContainer)(values["family_Details"])).Count();
            string hof_name = ((Newtonsoft.Json.Linq.JContainer)(values["hof_Details"]))["NAME_HND"].ToString();
            string hof_aadhar = ((Newtonsoft.Json.Linq.JContainer)(values["hof_Details"]))["AADHAR_ID"].ToString();
            string hof_father = ((Newtonsoft.Json.Linq.JContainer)(values["hof_Details"]))["FATHER_NAME_HND"].ToString();
            if (values.Count != null)
            {               
                for (int i = 0; i < total_family; i++)
                {
                    DataRow row = dt.NewRow();
                    row[0] = ((Newtonsoft.Json.Linq.JContainer)(values["family_Details"]))[i]["AADHAR_ID"].ToString();
                    row[1] = ((Newtonsoft.Json.Linq.JContainer)(values["family_Details"]))[i]["NAME_ENG"].ToString();
                    row[2] = ((Newtonsoft.Json.Linq.JContainer)(values["family_Details"]))[i]["FATHER_NAME_ENG"].ToString();
                    row[3] = ((Newtonsoft.Json.Linq.JContainer)(values["family_Details"]))[i]["DOB"].ToString();
                    row[4] = ((Newtonsoft.Json.Linq.JContainer)(values["family_Details"]))[i]["GENDER"].ToString();                  
                    dt.Rows.Add(row);
                }
            
            }

        }
        catch
        {
           
        }
        return dt;

 
    }
    public static string WebRequestinJson2(string url, string postData)
    {
        try
        {
            string ret = string.Empty;

            StreamWriter requestWriter;

            var webRequest = System.Net.WebRequest.Create(url) as HttpWebRequest;
            if (webRequest != null)
            {
                var header_bytes = Encoding.UTF8.GetBytes("rcsharma" + ":" + "1f85f003-b2c5-4862-a8d5-8d90372b77f7");
                string headerBase64 = "Basic " + Convert.ToBase64String(header_bytes);
                webRequest.ContentType = "application/x-www-form-urlencoded";
                webRequest.Headers.Add("Authorization", headerBase64);

                webRequest.Method = "POST";
                webRequest.ServicePoint.Expect100Continue = false;
                webRequest.Timeout = 20000;
                using (requestWriter = new StreamWriter(webRequest.GetRequestStream()))
                {
                    requestWriter.Write(postData);
                }
            }

            HttpWebResponse resp = (HttpWebResponse)webRequest.GetResponse();
            Stream resStream = resp.GetResponseStream();
            StreamReader reader = new StreamReader(resStream);
            ret = reader.ReadToEnd();
            return ret;
        }
        catch (WebException wex)
        {
            string pageContent = new StreamReader(wex.Response.GetResponseStream()).ReadToEnd().ToString();
            return pageContent;
        }


    }
    

    public static string CheckoutCodeOnRpp(string outCode)
    {
        string file_status = "NA";
        try
        {

            //Live:
            string url3 = "https://rpp.rajasthan.gov.in/api/v1/funddisbursement/payfile/status/details";           
            NameValueCollection outgoingQueryString = HttpUtility.ParseQueryString(String.Empty);
            outgoingQueryString.Add("fileName", outCode);
            outgoingQueryString.Add("outCode", outCode);
            string json3 = outgoingQueryString.ToString();
            string ss3 = WebRequestinJson3(url3, json3);
            JObject root3 = (JObject)JObject.Parse(ss3);
            foreach (var item_ack in root3)
            {
                if (item_ack.Key.ToLower() == "status")
                {
                    file_status = item_ack.Value.ToString();
                    break;
                }
            }
        }
        catch
        {

        }
        return file_status;
    }
    public static string WebRequestinJson3(string url, string postData)
    {
        try
        {
            string ret = string.Empty;

            StreamWriter requestWriter;

            var webRequest = System.Net.WebRequest.Create(url) as HttpWebRequest;
            if (webRequest != null)
            {
                var header_bytes = Encoding.UTF8.GetBytes("rcsharma" + ":" + "1f85f003-b2c5-4862-a8d5-8d90372b77f7");
                string headerBase64 = "Basic " + Convert.ToBase64String(header_bytes);
                webRequest.ContentType = "application/x-www-form-urlencoded";
                webRequest.Headers.Add("Authorization", headerBase64);

                webRequest.Method = "POST";
                webRequest.ServicePoint.Expect100Continue = false;
                webRequest.Timeout = 20000;
                using (requestWriter = new StreamWriter(webRequest.GetRequestStream()))
                {
                    requestWriter.Write(postData);
                }
            }

            HttpWebResponse resp = (HttpWebResponse)webRequest.GetResponse();
            Stream resStream = resp.GetResponseStream();
            StreamReader reader = new StreamReader(resStream);
            ret = reader.ReadToEnd();
            return ret;
        }
        catch (WebException wex)
        {
            string pageContent = new StreamReader(wex.Response.GetResponseStream()).ReadToEnd().ToString();
            return pageContent;
        }


    }
         

    public static string UploadFileOnEvolt(string pdfBase64,string repodocid)
    {
        string file_status = "NA";
        try
        {
            string url2 = "https://api.sewadwaar.rajasthan.gov.in/app/live/gs/resources/adddocument/generic?client_id=90521ae9-a800-4e3e-8da4-29b9fb49ce39";
            // "metadata": { "FileExtension": ".pdf", "Attributes": [{ "Value": "", "SymbolicName": "DocumentTitle" }], "File": "<Base-64>","MimeType": "application/pdf" },  "classname": "Document","path":"/ePanchayat/...","os":"EP","deptname":"EP","deptkey":" EP516GEN7515SE12","repodocid":"<unique-id>"  }//EP516GEN7515SE12,102585522553
            string json2 = "{\"metadata\":{\"FileExtension\":\".pdf\",\"Attributes\":[{\"Value\":\"\",\"SymbolicName\":\"DocumentTitle\"}],\"File\":\"" + pdfBase64 + "\",\"MimeType\":\"application/pdf\"},\"classname\":\"Document\",\"path\":\"/ePanchayat/\",\"os\":\"EP\",\"deptname\":\"EP\",\"deptkey\":\"EP516GEN7515SE12\",\"repodocid\":\"" + 102585522556 + "\"}";
            string ss2 = WebRequestinJson22(url2, json2);
            JObject root2 = (JObject)JObject.Parse(ss2);

            foreach (var item_ack in root2)
            {
                if (item_ack.Key.ToLower() == "status")
                {
                    file_status = item_ack.Value.ToString();
                    break;
                }
            }
        }
        catch
        {
         
        }
        return file_status;
    }


    public static string GetDocumentFromEvolt(string repodocid)
    {
        string file_status = "NA";
        try
        {
            string url2 = "https://api.sewadwaar.rajasthan.gov.in/app/live/gsresources/getdocument?client_id=90521ae9-a800-4e3e-8da4-29b9fb49ce39";
            string json2 = "{\"repodocid\":\"" + repodocid + "\",\"os\":\"EP\",\"classname\":\"Document\",\"deptkey\":\"EP516GEN7515SE12\",\"version\":\"1\",\"datareq\":\"all\"}";
            string ss2 = WebRequestinJson22(url2, json2);
            JObject root2 = (JObject)JObject.Parse(ss2);

            foreach (var item_ack in root2)
            {
                if (item_ack.Key.ToLower() == "status")
                {
                    file_status = item_ack.Value.ToString();
                    break;
                }
            }
        }
        catch
        {

        }
        return file_status;
    }

    public static string WebRequestinJson22(string url, string postData)
    {
        try
        {
            string ret = string.Empty;
            JObject json = JObject.Parse(postData);
            StreamWriter requestWriter;

            var webRequest = System.Net.WebRequest.Create(url) as HttpWebRequest;
            if (webRequest != null)
            {
                webRequest.Method = "POST";
                webRequest.ServicePoint.Expect100Continue = false;
                webRequest.Timeout = 40000;
                //  webRequest.Headers.Add("client_id", "9a9e8ed9-9474-4c74-b0da-cee9c1d29213");             
                webRequest.ContentType = "application/json";
                //POST the data.
                using (requestWriter = new StreamWriter(webRequest.GetRequestStream()))
                {
                    requestWriter.Write(json);
                }
            }
            HttpWebResponse resp = (HttpWebResponse)webRequest.GetResponse();
            Stream resStream = resp.GetResponseStream();
            StreamReader reader = new StreamReader(resStream);
            ret = reader.ReadToEnd();
            return ret;
        }
        catch (WebException wex)
        {
            /*string pageContent = new StreamReader(wex.Response.GetResponseStream()).ReadToEnd().ToString();
            return pageContent; */
            throw wex;
        }
    }


    public static string ChechuplodedFileinRPP(string fileName)
    {
        string file_status = "NA";
        try
        {

            string url3 = "https://rpp.rajasthan.gov.in/api/v1/funddisbursement/payfile/status/details";        
            NameValueCollection outgoingQueryString = HttpUtility.ParseQueryString(String.Empty);
            outgoingQueryString.Add("fileName", fileName);
            string json3 = outgoingQueryString.ToString();
            string ss3 = WebRequestinJson2(url3, json3);
            JObject root3 = (JObject)JObject.Parse(ss3);
            foreach (var item_ack in root3)
            {
                if (item_ack.Key.ToLower() == "status")
                {
                    file_status = item_ack.Value.ToString();
                    break;
                }
            }
        }
        catch
        {

        }
        return file_status;
    }




}