﻿<%@ WebHandler Language="C#" Class="UserRightsManagement" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;
using System.Collections;
using System.Data.SqlClient;
public class UserRightsManagement : IHttpHandler
{
    DataSet dsAttribute;
    DataSet ds;
    public void ProcessRequest(HttpContext context)
    {

        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }


        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";
        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();
        //deserialize the object
        JavaScriptSerializer json = new JavaScriptSerializer();
        ArrayList arylst = json.Deserialize<ArrayList>(strJson);
        if (arylst.Count == 0)
        {
            ClsUserRights objCls = Deserialize<ClsUserRights>(strJson);
            if (objCls != null)
            {
                dsAttribute = new DataSet();
                try
                {
                    dsAttribute = new APIProcedure().ByProcedure("USP_USER_RIGHTS",
                        new string[] { "type", "parent_menu_id", "child_menu_id", "rights_id", "user_id", "url", "is_insert", "is_update", "is_delete", "is_select", "is_active", "created_by" },
                        new string[] { objCls.Action, objCls.parent_menu_id, objCls.child_menu_id, objCls.rights_id, objCls.user_id,objCls.url,objCls.is_insert,objCls.is_update,objCls.is_delete,objCls.is_select,objCls.is_active,objCls.CreatedBy
                        }, "USPRIGHTSMASTER");

                    if (dsAttribute.Tables.Count > 0)
                    {
                        context.Response.Write(JsonConvert.ExportToString(dsAttribute.Tables[0].Rows));
                    }
                }
                catch (Exception ex)
                {
                    context.Response.Write(JsonConvert.ExportToString("Error"));
                    new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
                }
                finally { dsAttribute.Dispose(); }
            }
        }

        if (arylst.Count > 0)
        {
            string key = "";
            ds = new DataSet();
            if (arylst != null)
            {
                System.Collections.Generic.Dictionary<string, object> dd = (System.Collections.Generic.Dictionary<string, object>)arylst[0];
                DataTable dt = new DataTable();
                dt.Columns.Add("type", typeof(string));
                dt.Columns.Add("parent_menu_id", typeof(string));
                dt.Columns.Add("child_menu_id", typeof(string));
                dt.Columns.Add("rights_id", typeof(string));
                dt.Columns.Add("user_id", typeof(string));
                dt.Columns.Add("url", typeof(string));
                dt.Columns.Add("is_insert", typeof(string));
                dt.Columns.Add("is_update", typeof(string));
                dt.Columns.Add("is_delete", typeof(string));
                dt.Columns.Add("is_select", typeof(string));
                dt.Columns.Add("is_active", typeof(string));
                dt.Columns.Add("created_by", typeof(string));

                for (int i = 0; i <= arylst.Count - 1; i++)
                {
                    dd = (System.Collections.Generic.Dictionary<string, object>)arylst[i];
                    if (dd["type"].ToString() == "SAVE_RIGHTS")
                    {
                        dt.Rows.Add(dd["type"].ToString(),
                                   dd["parent_menu_id"].ToString(),
                                   dd["child_menu_id"].ToString(),
                                   dd["rights_id"].ToString(),
                                   dd["user_id"].ToString(),
                                   dd["url"].ToString(),
                                   dd["is_insert"].ToString(),
                                   dd["is_update"].ToString(),
                                   dd["is_delete"].ToString(),
                                   dd["is_select"].ToString(),
                                   dd["is_active"].ToString(),
                                   dd["created_by"].ToString());
                    }
                }
                ds = SaveData(dt);
                if (ds.Tables.Count > 0)
                {
                    context.Response.Write(JsonConvert.ExportToString(ds.Tables[0].Rows));
                }
            }
        }


    }

    public DataSet SaveData(DataTable Dts)
    {
        string Cn;
        Cn = System.Configuration.ConfigurationManager.ConnectionStrings["conn"].ConnectionString;
        SqlCommand cmd;
        using (SqlConnection cn = new SqlConnection(Cn))
        {
            cmd = new SqlCommand("USP_MANAGE_USER_RIGHTS", cn);
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.Parameters.AddWithValue("@TypeTable", Dts);
            using (SqlDataAdapter adp = new SqlDataAdapter(cmd))
            {
                ds = new DataSet();
                adp.Fill(ds);
            }
        }
        return ds;
    }


    public bool IsReusable
    {
        get
        {
            return false;
        }
    }

    public T Deserialize<T>(string context)
    {
        string jsonData = context;

        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }

    class ClsUserRights
    {
        public string Key { get; set; }
        public string Action { get; set; }
        public string parent_menu_id  { get; set; }
        public string child_menu_id { get; set; }
        public string rights_id  { get; set; }
        public string user_id  { get; set; }
        public string url { get; set; }
        public string is_insert { get; set; }
        public string is_update { get; set; }
        public string is_delete { get; set; }
        public string is_select { get; set; }
        public string is_active{ get; set; }
        public string CreatedBy { get; set; }

    }

}