﻿<%@ WebHandler Language="C#" Class="UserRegistration" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;

public class UserRegistration : IHttpHandler
{
    DataSet dsUser;

    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";
        //context.Response.Write("Hello World");
        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        ClsUserRegistration objCls = Deserialize<ClsUserRegistration>(strJson);
        if (objCls != null)
        {
            string Key = objCls.key;

            dsUser = new DataSet();
            try
            {
                if (Key.ToUpper() == "SELECT")
                {
                    dsUser = new APIProcedure().ByProcedure("USP_USER_REGISTRATION",
                    new string[] { "key", "ssoID", "name", "username", "password", "isActive", "isAdmin", "action", "createdBy" },
                    new string[] { objCls.key, objCls.ssoID, objCls.name, objCls.username, objCls.password, (objCls.isActive == "True" ? "1" : "0"), (objCls.isAdmin == "True" ? "1" : "0"), objCls.action, objCls.createdBy }, "USPADDSETTING");
                }
                else if (Key.ToUpper() == "INSERT")
                {
                    dsUser = new APIProcedure().ByProcedure("USP_USER_REGISTRATION",
                   new string[] { "key", "ssoID", "name","username", "password", "isActive", "isAdmin", "action", "createdBy" },
                   new string[] { objCls.key, objCls.ssoID, objCls.name,objCls.username, objCls.password, (objCls.isActive == "True" ? "1" : "0"), (objCls.isAdmin == "True" ? "1" : "0"), objCls.action, objCls.createdBy }, "USPADDSETTING");
                }
                else if (Key.ToUpper() == "UPDATE")
                {
                    dsUser = new APIProcedure().ByProcedure("USP_USER_REGISTRATION",
                   new string[] { "key", "ssoID", "name","username", "password", "isActive", "isAdmin", "action", "createdBy" },
                   new string[] { objCls.key, objCls.ssoID, objCls.name,objCls.username, objCls.password, (objCls.isActive == "True" ? "1" : "0"), (objCls.isAdmin == "True" ? "1" : "0"), objCls.action, objCls.createdBy }, "USPADDSETTING");
                }
                else if (Key.ToUpper() == "DELETE")
                {
                    dsUser = new APIProcedure().ByProcedure("USP_USER_REGISTRATION",
                   new string[] { "key", "ssoID", "name","username", "password", "isActive", "isAdmin", "action", "createdBy" },
                   new string[] { objCls.key, objCls.ssoID, objCls.name,objCls.username, objCls.password, (objCls.isActive == "True" ? "1" : "0"), (objCls.isAdmin == "True" ? "1" : "0"), objCls.action, objCls.createdBy }, "USPADDSETTING");
                }

                if (dsUser.Tables.Count > 0)
                {
                    context.Response.Write(JsonConvert.ExportToString(dsUser.Tables[0].Rows));
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(JsonConvert.ExportToString("Error"));
                new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
            }
            finally { dsUser.Dispose(); }
        }

    }
    public T Deserialize<T>(string context)
    {
        string jsonData = context;
        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    class ClsUserRegistration
    {
        public string key { get; set; }
        public string ssoID { get; set; }
        public string name { get; set; }
        public string username { get; set; }
        public string password { get; set; }
        public string isActive { get; set; }
        public string isAdmin { get; set; }
        public string action { get; set; }
        public string createdBy { get; set; }
    }
}
