﻿<%@ WebHandler Language="C#" Class="PageAuth" %>

using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;
public class PageAuth : IHttpHandler
{
    DataSet ds;
    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";
        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        //deserialize the object
        ClsPageAuth objUsr = Deserialize<ClsPageAuth>(strJson);
        if (objUsr != null)
        {
             if (objUsr.Key == "CheckPageAuth")
             {
                 ds = new DataSet();
                 try
                 {
                     ds = new APIProcedure().ByProcedure("USP_PAGE_AUTH", new string[] { "PageName", "UserName" }, new string[] { objUsr.PageName, objUsr.UserName }, "BYDataset");
                     if (ds.Tables[0].Rows.Count > 0)
                     {
                         context.Response.Write(JsonConvert.ExportToString(ds.Tables[0].Rows));
                     }
                 }
                 catch (Exception ex)
                 {
                     context.Response.Write(JsonConvert.ExportToString("Error"));
                     new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
                 }
                 finally { ds.Dispose(); }
             }
        }
    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    // we create a userinfo class to hold the JSON value
    public class ClsPageAuth
    {
        public string Key { get; set; }
        public string PageName { get; set; }
        public string CreatedBy { get; set; }
        public string UserName { get; set; }
        
    }

    // Converts the specified JSON string to an object of type T
    public T Deserialize<T>(string context)
    {
        string jsonData = context;

        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
}