﻿<%@ WebHandler Language="C#" Class="TransferProposal" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;

public class TransferProposal : IHttpHandler
{
    DataSet dsUser;

    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";
        //context.Response.Write("Hello World");
        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        ClsTransferProposal objCls = Deserialize<ClsTransferProposal>(strJson);
        if (objCls != null)
        {
            string Key = objCls.key;

            dsUser = new DataSet();
            try
            {
                dsUser = new APIProcedure().ByProcedure("USP_TRANSFER_PROPOSAL",
                new string[] { "key", "proposalName", "proposalDate", "isActive", "action", "remark", "closingDate", "createdBy" },
                new string[] { objCls.key, objCls.proposalName, objCls.proposalDate, (objCls.isActive=="True" ? "1" : "0"), objCls.action, objCls.remark, objCls.closingDate, objCls.createdBy }, "USPADDSETTING");
                
                if (dsUser.Tables.Count > 0)
                {
                    context.Response.Write(JsonConvert.ExportToString(dsUser.Tables[0].Rows));
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(JsonConvert.ExportToString("Error"));
                new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
            }
            finally { dsUser.Dispose(); }
        }

    }
    public T Deserialize<T>(string context)
    {
        string jsonData = context;
        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    class ClsTransferProposal
    {
        public string key { get; set; }
        public string proposalName { get; set; }
        public string proposalDate { get; set; }
        public string isActive { get; set; }
        public string action { get; set; }
        public string remark { get; set; }
        public string closingDate { get; set; }
        public string createdBy { get; set; }
    }
}
