﻿<%@ WebHandler Language="C#" Class="TransferApplicationList" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;

public class TransferApplicationList : IHttpHandler
{
    DataSet dsUser;

    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";

        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        ClsTransferApplicationList objCls = Deserialize<ClsTransferApplicationList>(strJson);
        if (objCls != null)
        {
            string Key = objCls.key;

            dsUser = new DataSet();
            try
            {
                dsUser = new APIProcedure().ByProcedure("USP_TRANSFER_APPLICATION_LIST",
                new string[] {  "key",
                                "applicationDate",
                                "employeeName",
                                "designationID",
                                "genderID",
                                "fromOffice",
                                "fromDeptID",
                                "fromPlace",
                                "fromDistrictID",
                                "toOffice",
                                "toDeptID",
                                "toPlace",
                                "toDistrictID",
                                "isCMO",
                                "isPSITDesire",
                                "isCSITDesire",
                                "isRepDesire",
                                "isOfficerDesire",
                                "isSpouseGovtJob",
                                "isPH",
                                "isMutual",
                                "isCompliance",
                                "isSelfApplication",
                                "isTDJSDesire",
                                "isChronic",
                                "isComplaint",
                                "isInActiveOnly",
                                "otherRemark",
                                "action",
                                "createdBy" },
                new string[] { objCls.key,
                                objCls.applicationDate,
                                objCls.employeeName,
                                objCls.designationID,
                                objCls.genderID,
                                objCls.fromOffice,
                                objCls.fromDeptID,
                                objCls.fromPlace,
                                objCls.fromDistrictID,
                                objCls.toOffice,
                                objCls.toDeptID,
                                objCls.toPlace,
                                objCls.toDistrictID,
                                objCls.isCMO,
                                objCls.isPSITDesire,
                                objCls.isCSITDesire,
                                objCls.isRepDesire,
                                objCls.isOfficerDesire,
                                objCls.isSpouseGovtJob,
                                objCls.isPH,
                                objCls.isMutual,
                                objCls.isCompliance,
                                objCls.isSelfApplication,
                                objCls.isTDJSDesire,
                                objCls.isChronic,
                                objCls.isComplaint,
                                objCls.isInActiveOnly,
                                objCls.otherRemark,
                                objCls.action,
                                objCls.createdBy }, "USPADDSETTING");
                if (dsUser.Tables.Count > 0)
                {
                    context.Response.Write(JsonConvert.ExportToString(dsUser.Tables[0].Rows));
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(JsonConvert.ExportToString("Error"));
                new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
            }
            finally { dsUser.Dispose(); }
        }

    }
    public T Deserialize<T>(string context)
    {
        string jsonData = context;
        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    class ClsTransferApplicationList
    {
        public string key { get; set; }
        public string applicationDate { get; set; }
        public string employeeName { get; set; }
        public string designationID { get; set; }
        public string genderID { get; set; }
        public string fromOffice { get; set; }
        public string fromDeptID { get; set; }
        public string fromPlace { get; set; }
        public string fromDistrictID { get; set; }
        public string toOffice { get; set; }
        public string toDeptID { get; set; }
        public string toPlace { get; set; }
        public string toDistrictID { get; set; }
        public string isCMO { get; set; }
        public string isPSITDesire { get; set; }
        public string isCSITDesire { get; set; }
        public string isRepDesire { get; set; }
        public string isOfficerDesire { get; set; }
        public string isSpouseGovtJob { get; set; }
        public string isPH { get; set; }
        public string isMutual { get; set; }
        public string isCompliance { get; set; }
        public string isSelfApplication { get; set; }
        public string isTDJSDesire { get; set; }
        public string isChronic { get; set; }
        public string isComplaint { get; set; }
        public string isInActiveOnly { get; set; }
        public string otherRemark { get; set; }
        public string action { get; set; }
        public string createdBy { get; set; }
    }
}
