﻿<%@ WebHandler Language="C#" Class="PostingSearchData" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;

public class PostingSearchData : IHttpHandler
{
    DataSet dsUser;

    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";

        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        ClsPostingSearchData objCls = Deserialize<ClsPostingSearchData>(strJson);
        if (objCls != null)
        {
            string Key = objCls.key;

            dsUser = new DataSet();
            try
            {
                dsUser = new APIProcedure().ByProcedure("USP_POSTING_SEARCH_DATA",
                
                new string[] {
                    "key",
                    "EditID",
                    "empID",
                    "employee",
                    "designationID",
                    "departmentID",
                    "districtID",
                    "place",
                    "action",
                    "createdBy"
                },
                new string[] { 
                    objCls.key,
                    objCls.EditID,
                    objCls.empID,
                    objCls.employee,
                    objCls.designationID,
                    objCls.departmentID,
                    objCls.districtID,
                    objCls.place,
                    objCls.action,
                    objCls.createdBy
                }, "USPADDSETTING");
                if (dsUser.Tables.Count > 0)
                {
                    context.Response.Write(JsonConvert.ExportToString(dsUser.Tables[0].Rows));
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(JsonConvert.ExportToString("Error"));
                new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
            }
            finally { dsUser.Dispose(); }
        }

    }
    public T Deserialize<T>(string context)
    {
        string jsonData = context;
        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    class ClsPostingSearchData
    {
        public string key { get; set; }
        public string EditID { get;set; }
        public string empID { get; set; }
        public string employee { get; set; }
        public string designationID { get; set; }
        public string departmentID { get; set; }
        public string districtID { get; set; }
        public string place { get; set; }
        public string action { get; set; }
        public string createdBy { get; set; }
    }
}
