﻿<%@ WebHandler Language="C#" Class="NonJoinersReport" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;

public class NonJoinersReport : IHttpHandler
{
    DataSet dsUser;

    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";

        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        ClsNonJoinersReport objCls = Deserialize<ClsNonJoinersReport>(strJson);
        if (objCls != null)
        {
            string Key = objCls.key;

            dsUser = new DataSet();
            try
            {
                dsUser = new APIProcedure().ByProcedure("USP_NON_JOINERS_REPORT",
                new string[] {
                                "key",
                                "transferProposalIDs",
                                "employeeName",
                                "designationID",
                                "fromOffice",
                                "fromDeptID",
                                "fromPlace",
                                "fromDistrictID",
                                "toOffice",
                                "toDeptID",
                                "toPlace",
                                "toDistrictID",
                                "transferCategory",
                                "isPromotion",
                                "action",
                                "createdBy"
                            },
                new string[] {
                                objCls.key,
                                objCls.transferProposalIDs,
                                objCls.employeeName,
                                objCls.designationID,
                                objCls.fromOffice,
                                objCls.fromDeptID,
                                objCls.fromPlace,
                                objCls.fromDistrictID,
                                objCls.toOffice,
                                objCls.toDeptID,
                                objCls.toPlace,
                                objCls.toDistrictID,
                                objCls.transferCategory,
                                objCls.isPromotion,
                                objCls.action,
                                objCls.createdBy
                            }, "USPADDSETTING");
                if (dsUser.Tables.Count == 1)
                {
                    context.Response.Write(JsonConvert.ExportToString(dsUser.Tables[0].Rows));
                }
                else if (dsUser.Tables.Count > 1)
                {
                    System.Text.StringBuilder sb = new System.Text.StringBuilder();
                    sb.Append("{");
                    for (int i = 0; i < dsUser.Tables.Count; i++)
                    {
                        sb.Append("\"table" + i.ToString() + "\":");
                        sb.Append(JsonConvert.ExportToString(dsUser.Tables[i].Rows));
                        sb.Append(",");
                    }
                    string str = sb.ToString();
                    str = str.Substring(0, str.Length - 1);
                    str += "}";
                    context.Response.Write(str);
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(JsonConvert.ExportToString("Error"));
                new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
            }
            finally { dsUser.Dispose(); }
        }

    }
    public T Deserialize<T>(string context)
    {
        string jsonData = context;
        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    class ClsNonJoinersReport
    {
        public string key { get; set; }
        public string transferProposalIDs { get; set; }
        public string employeeName { get; set; }
        public string designationID { get; set; }
        public string fromOffice { get; set; }
        public string fromDeptID { get; set; }
        public string fromPlace { get; set; }
        public string fromDistrictID { get; set; }
        public string toOffice { get; set; }
        public string toDeptID { get; set; }
        public string toPlace { get; set; }
        public string toDistrictID { get; set; }
        public string transferCategory { get; set; }
        public string isPromotion { get; set; }
        public string action { get; set; }
        public string createdBy { get; set; }
            
    }
}
