﻿<%@ WebHandler Language="C#" Class="MenuMaster" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;
public class MenuMaster : IHttpHandler
{
    DataSet ds;
    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";
        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        //deserialize the object
        ClsMenuMaster objUsr = Deserialize<ClsMenuMaster>(strJson);
        if (objUsr != null)
        {
            string key = "";
            key = objUsr.key;
            if (key == "Save")
            {
                ds = new DataSet();
                try
                {
                    ds = new APIProcedure().ByProcedure("USP_MENU_MASTER",
                                        new string[] { "AppAction", "menu_id", "menu_title", "is_parent", "parent_id", "created_by", "form_path", "form_title","order_by", "IsVisible", "menu_icon" },
                                        new string[] { "SAVE", "1", objUsr.menu_title, objUsr.is_parent, objUsr.parent_id, objUsr.created_by, objUsr.form_path, objUsr.form_title, objUsr.order_by, objUsr.IsVisible, objUsr.menu_icon }, "USPADDSETTING");
                    if (ds.Tables.Count > 0)
                    {
                        context.Response.Write(JsonConvert.ExportToString(ds.Tables[0].Rows));
                    }
                }
                catch (Exception ex)
                {
                    context.Response.Write(JsonConvert.ExportToString("Error"));
                    new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
                }
                finally { ds.Dispose(); }
            }

            else if (key == "LoadData")
            {
                ds = new DataSet();
                try
                {
                    ds = new APIProcedure().ByProcedure("USP_MENU_MASTER", new string[] { "AppAction" },
                        new string[] { "SELECT" }, "USPADDSETTING");

                    if (ds.Tables.Count > 0)
                    {
                        context.Response.Write(JsonConvert.ExportToString(ds.Tables[0].Rows));
                    }
                }
                catch (Exception ex)
                {
                    context.Response.Write(JsonConvert.ExportToString("Error"));
                    new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
                }
                finally { ds.Dispose(); }
            }

            else if (key == "LoadDDLParent")
            {
                ds = new DataSet();
                try
                {
                    ds = new APIProcedure().ByProcedure("USP_MENU_MASTER", new string[] { "AppAction" },
                        new string[] { "SELECTPARENT" }, "USPADDSETTING");

                    if (ds.Tables.Count > 0)
                    {
                        context.Response.Write(JsonConvert.ExportToString(ds.Tables[0].Rows));
                    }
                }
                catch (Exception ex)
                {
                    context.Response.Write(JsonConvert.ExportToString("Error"));
                    new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
                }
                finally { ds.Dispose(); }
            }
            else if (key == "LoadParent")
            {
                ds = new DataSet();
                try
                {
                    ds = new APIProcedure().ByProcedure("USP_MENU_MASTER", new string[] { "AppAction" },
                        new string[] { "SELECTNEWPARENT" }, "USPADDSETTING");

                    if (ds.Tables.Count > 0)
                    {
                        context.Response.Write(JsonConvert.ExportToString(ds.Tables[0].Rows));
                    }
                }
                catch (Exception ex)
                {
                    context.Response.Write(JsonConvert.ExportToString("Error"));
                    new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
                }
                finally { ds.Dispose(); }
            }

            else if (key == "LoadDataById")
            {
                ds = new DataSet();
                try
                {
                    ds = new APIProcedure().ByProcedure("USP_MENU_MASTER", new string[] { "AppAction", "menu_id" },
                        new string[] { "SELECTWHERE", objUsr.menu_id }, "USPADDSETTING");

                    if (ds.Tables.Count > 0)
                    {
                        context.Response.Write(JsonConvert.ExportToString(ds.Tables[0].Rows));
                    }
                }
                catch (Exception ex)
                {
                    context.Response.Write(JsonConvert.ExportToString("Error"));
                    new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
                }
                finally { ds.Dispose(); }
            }
            else if (key == "Update")
            {
                ds = new DataSet();
                try
                {
                    ds = new APIProcedure().ByProcedure("USP_MENU_MASTER",
                        new string[] { "AppAction", "menu_id", "menu_title", "is_parent", "parent_id", "created_by", "form_path", "form_title", "order_by", "IsVisible", "menu_icon"},
                        new string[] { "UPDATE", objUsr.menu_id, objUsr.menu_title, objUsr.is_parent, objUsr.parent_id, objUsr.created_by, objUsr.form_path, objUsr.form_title, objUsr.order_by, objUsr.IsVisible, objUsr.menu_icon }
                        , "USPADDSETTING");
                    if (ds.Tables.Count > 0)
                    {
                        context.Response.Write(JsonConvert.ExportToString(ds.Tables[0].Rows));
                    }
                }
                catch (Exception ex)
                {
                    context.Response.Write(JsonConvert.ExportToString("Error"));
                    new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
                }
                finally { ds.Dispose(); }
            }
            else if (key == "Delete")
            {
                ds = new DataSet();
                try
                {
                    ds = new APIProcedure().ByProcedure("USP_MENU_MASTER",
                         new string[] { "AppAction", "menu_id", "created_by" },
                        new string[] { "DELETE", objUsr.menu_id, objUsr.created_by }, "USPADDSETTING");

                    if (ds.Tables.Count > 0)
                    {
                        context.Response.Write(JsonConvert.ExportToString(ds.Tables[0].Rows));
                    }
                }
                catch (Exception ex)
                {
                    context.Response.Write(JsonConvert.ExportToString("Error"));
                    new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
                }
                finally { ds.Dispose(); }
            }
            else if (key == "SELECTFORM")
            {
                ds = new DataSet();
                try
                {
                    ds = new APIProcedure().ByProcedure("USP_MENU_MASTER", new string[] { "AppAction", "created_by" },
                        new string[] { "SELECTFORM" }, "USPADDSETTING");

                    if (ds.Tables.Count > 0)
                    {
                        context.Response.Write(JsonConvert.ExportToString(ds.Tables[0].Rows));
                    }
                }
                catch (Exception ex)
                {
                    context.Response.Write(JsonConvert.ExportToString("Error"));
                    new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
                }
                finally { ds.Dispose(); }
            }
        }
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    
    public class ClsMenuMaster
    {
        public string key { get; set; }
        public string IsVisible { get; set; }
        public string order_by { get; set; }
        public string menu_title { get; set; }
        public string menu_id { get; set; }
        public string is_parent { get; set; }
        public string parent_id { get; set; }
        public string created_by { get; set; }
        public string form_path { get; set; }
        public string form_title { get; set; }
        public string menu_icon { get; set; }
    }

    // Converts the specified JSON string to an object of type T
    public T Deserialize<T>(string context)
    {
        string jsonData = context;

        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
}