﻿<%@ WebHandler Language="C#" Class="HandlerAdmin" %>

using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;
using System.Linq;

public class HandlerAdmin : IHttpHandler
{
    DataSet ds;
    DataTable dt;
    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";
        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        //deserialize the object
        LoadLogoPath objUsr = Deserialize<LoadLogoPath>(strJson);
        if (objUsr != null)
        {
            string key = "";
            key = objUsr.key;
            if (key == "SSO_LOGIN")
            {
                ds = new DataSet();
                try
                {
                    context.Response.Write(JsonConvert.ExportToString("OK"));
                }
                catch (Exception ex)
                {
                    context.Response.Write(JsonConvert.ExportToString("Error"));
                }
            }
            if (key == "SSO_LOGIN_SECURE")
            {
                ds = new DataSet();
                try
                {
                    if (!string.IsNullOrEmpty(objUsr.UserId) && !string.IsNullOrEmpty(objUsr.Pwd))
                    {
                        RAJSSO.SSO SSO = new RAJSSO.SSO();
                        bool user = SSO.SSOAuthentication(objUsr.UserId, objUsr.Pwd);
                        if (user == true)
                        {
                            objUsr.token = Convert.ToBase64String(Guid.NewGuid().ToByteArray());

                            ds = new APIProcedure().ByProcedure("USP_SSO_LOGIN", new string[] { "key", "ssoID", "token" },
                                new string[] { key, objUsr.UserId, objUsr.token }, "USPSSOLOGIN");

                            if (ds.Tables.Count > 0)
                            {
                                context.Response.Write(JsonConvert.ExportToString(ds.Tables[0].Rows));
                            }
                        }
                    }
                }
                catch (Exception ex)
                {
                    context.Response.Write(JsonConvert.ExportToString("Error"));
                }
                finally { ds.Dispose(); }
            }
            if (key == "LOGIN_SECURE")
            {
                ds = new DataSet();
                try
                {
                    if (!string.IsNullOrEmpty(objUsr.UserId) && !string.IsNullOrEmpty(objUsr.Pwd))
                    {
                        objUsr.token = Convert.ToBase64String(Guid.NewGuid().ToByteArray());

                        ds = new APIProcedure().ByProcedure("USP_SSO_LOGIN", new string[] { "key", "username", "password", "token" },
                            new string[] { key, objUsr.UserId, objUsr.Pwd, objUsr.token }, "USPSSOLOGIN");

                        if (ds.Tables.Count > 0)
                        {
                            context.Response.Write(JsonConvert.ExportToString(ds.Tables[0].Rows));
                        }
                    }
                }
                catch (Exception ex)
                {
                    context.Response.Write(JsonConvert.ExportToString("Error"));
                }
                finally { ds.Dispose(); }
            }
            if (key == "LoadMenu")
            {
                DataTable table = new DataTable();
                table.Columns.Add("MenuId", typeof(string));
                table.Rows.Add(GenerateMenu(objUsr.UserId ?? "0", objUsr.protocol));
                try
                {
                    context.Response.Write(JsonConvert.ExportToString(table.Rows));
                }
                catch (Exception ex)
                {
                    context.Response.Write(JsonConvert.ExportToString("Error"));
                    new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
                }
            }

        }

    }
    // we create a userinfo class to hold the JSON value
    public class LoadLogoPath
    {
        public string key { get; set; }
        public string UserId { get; set; }
        public string Pwd { get; set; }
        public string token { get; set; }
        public string protocol { get; set; }
    }

    public int CheckPath(string FullPath)
    {
        return FullPath.IndexOf("?");
    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }

    // Converts the specified JSON string to an object of type T
    public T Deserialize<T>(string context)
    {
        string jsonData = context;

        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }

    public string GenerateMenu(string UserId, string protocol)
    {
        DataSet ds = new APIProcedure().ByProcedure("USP_GET_MENU", new string[] { "UserId" }, new string[] { UserId }, "USPADDSETTING");
        string LocalHostPath =  protocol + "://" + HttpContext.Current.Request.Url.Authority + "/";

        string HTML = "";

        int counter = 0;
        
        HTML = "<ul>";
        DataRow[] mastermenu = ds.Tables[0].Select("is_parent=0");
        if (mastermenu.Count() > 0)
        {
            foreach (DataRow row in mastermenu)
            {
                string iconClass = row["menu_icon"].ToString();
                if (iconClass == null || iconClass == "")
                {
                    iconClass = "icon-folder";
                }
                DataRow[] submenu = ds.Tables[0].Select("is_parent <> 0 AND parent_id =" + row["menu_id"].ToString());

                if (row["form_path"].ToString() != "#" && row["form_path"].ToString() != "")
                {
                    HTML = HTML + " <li> <a ui-sref='" + LocalHostPath + row["form_path"].ToString() + "' href='" + LocalHostPath + row["form_path"].ToString() + "'><i class='" + iconClass + "'></i><span class='title'>" + row["menu_title"].ToString() + "</span></a></li>";
                }
                else
                {
                    if (submenu.Count() > 0)
                    {
                        HTML = HTML + "<li class='has_sub'> <a class=''><i class='fa " + iconClass + "'></i><span class='title'>" + row["menu_title"].ToString() + "</span><span class='pull-right'><i class='fa fa-angle-down'></i></span></a>";
                    }
                    else
                    {
                        HTML = HTML + "<li> <a><i class='fa " + iconClass + "'></i><span class='title'>" + row["menu_title"].ToString() + "</span></a></li>";
                    }
                }


                if (submenu.Count() > 0)
                {
                    HTML = HTML + "<ul>";

                    foreach (DataRow subrow in submenu)
                    {
                        if (CheckPath(subrow["form_path"].ToString()) != -1)
                        {
                            if (subrow["form_path"].ToString() != "#" && subrow["form_path"].ToString() != "")
                            {
                                HTML = HTML + "<li><a ui-sref='" + LocalHostPath + subrow["form_path"].ToString() + "' href='" + LocalHostPath + subrow["form_path"].ToString() + "'>" + subrow["menu_title"].ToString() + "</a></li>";
                            }
                            else if (subrow["form_path"].ToString() == "#" && subrow["form_path"].ToString().ToString() != "")
                            {
                                DataRow[] subsubmenu = ds.Tables[0].Select("is_parent <> 0 AND parent_id = " + subrow["menu_id"].ToString());
                                if (subsubmenu.Count() > 0)
                                {
                                    if (subrow["menu_title"].ToString().ToString() != "")
                                    {
                                        HTML = HTML + "<li class='has_sub'> <a  class='' ui-sref='" + subrow["form_path"].ToString() + "' class='nav-link nav-toggle' href='#'><span class='title'>" + subrow["menu_title"].ToString().ToString() + "</span><span class='pull-right'><i class='fa fa-angle-down'></i></span></a>";
                                        HTML = HTML + "<ul>";
                                        foreach (DataRow subsubrow in subsubmenu)
                                        {
                                            HTML = HTML + "<li> <a ui-sref='" + LocalHostPath + subsubrow["form_path"].ToString() + "' href='" + LocalHostPath + subsubrow["form_path"].ToString().ToString() + "'><span class='title'>" + subsubrow["menu_title"].ToString().ToString() + "</span></a></li>";
                                        }
                                        HTML = HTML + "</ul></li>";
                                    }
                                }
                            }
                            else
                            {
                                HTML = HTML + "<li><a href='#'>" + subrow["form_path"].ToString() + "</a></li>";
                            }
                        }
                        else
                        {
                            if (subrow["form_path"].ToString() != "#" && subrow["form_path"].ToString() != "")
                            {
                                HTML = HTML + "<li><a ui-sref='" + LocalHostPath + subrow["form_path"].ToString() + "' href='" + LocalHostPath + subrow["form_path"].ToString() + "'>" + subrow["menu_title"].ToString() + "</a></li>";
                            }
                            else if (subrow["form_path"].ToString() == "#" && subrow["form_path"].ToString() != "")
                            {
                                DataRow[] subsubmenu = ds.Tables[0].Select("is_parent <> 0 AND parent_id = " + subrow["menu_id"].ToString());
                                if (subsubmenu.Count() > 0)
                                {
                                    if (subrow["menu_title"].ToString() != "")
                                    {
                                        HTML = HTML + "<li class='has_sub'> <a class='' href='#'><span class='title'>" + subrow["menu_title"].ToString() + "</span><span class='pull-right'><i class='fa fa-angle-down'></i></span></a>";
                                        HTML = HTML + "<ul>";
                                        foreach (DataRow subsubrow in subsubmenu)
                                        {
                                            HTML = HTML + "<li> <a ui-sref='" + LocalHostPath + subsubrow["form_path"].ToString() + "' href='" + LocalHostPath + subsubrow["form_path"].ToString() + "'><span class='title'>" + subsubrow["menu_title"].ToString() + "</span></a></li>";
                                        }
                                        HTML = HTML + "</ul></li>";
                                    }
                                }
                            }
                            else
                            {
                                HTML = HTML + "<li><a href='#'>" + row["menu_title"].ToString() + "</a></li>";
                            }
                        }
                    }
                    HTML = HTML + "</ul></li>";

                }
                counter++;
            }
        }
        else
        {
            HTML = HTML + "</ul>";
        }
        HTML = HTML + "</li></ul>";
        return HTML.ToString();
    }
}