﻿<%@ WebHandler Language="C#" Class="ImportData" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;

public class ImportData : IHttpHandler
{
    DataSet dsUser;

    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";
        //context.Response.Write("Hello World");
        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        ClsImportData objCls = Deserialize<ClsImportData>(strJson);
        if (objCls != null)
        {
            string filePath = HttpContext.Current.Server.MapPath("~") + objCls.excelFilePath;
            //string filePath = objCls.excelFilePath;
            if(!File.Exists(filePath))
            {
                context.Response.Write("File does not exist.");
                return;
            }

            dsUser = new DataSet();
            try
            {
                dsUser = new APIProcedure().ByProcedure("USP_IMPORT_DATA",
                                                        new string[] { "tblName", "excelFilePath", "createdBy" },
                                                        new string[] { objCls.tblName, filePath, objCls.createdBy }, "USPADDSETTING");

                if (dsUser.Tables.Count > 0)
                {
                    context.Response.Write(JsonConvert.ExportToString(dsUser.Tables[0].Rows));
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(JsonConvert.ExportToString("Error"));
                new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
            }
            finally
            {
                dsUser.Dispose();
                if (File.Exists(filePath))
                    File.Delete(filePath);
            }
        }

    }
    public T Deserialize<T>(string context)
    {
        string jsonData = context;
        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    class ClsImportData
    {
        public string tblName { get; set; }
        public string excelFilePath { get; set; }
        public string createdBy { get; set; }
    }
}
