﻿<%@ WebHandler Language="C#" Class="FileUpload" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;

public class FileUpload : IHttpHandler {

    public void ProcessRequest(HttpContext context)
    {

        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        if (context.Request.QueryString["file"] != null)
        {
            System.Threading.Thread.Sleep(1000);
            if (context.Request.QueryString["file"] == "upload")
            {
                int NewFileSizeInKB = 0;
                int MaxFileSizeInKB = 250000;
                if (context.Request.Files.Count > 0)
                {
                    HttpFileCollection files = context.Request.Files;
                    HttpPostedFile file = files[0];
                    string folderPath = context.Request.Form.Get("folderpath");
                    string filePath = file.FileName;
                    string fileExtension = Path.GetExtension(filePath);
                    Guid Guid_id = Guid.NewGuid();
                    string filename = context.Request.Form.Get("filename") + Guid_id + fileExtension;
                    NewFileSizeInKB = MaxFileSizeInKB * 2024; // 20 MB File.
                    int ContentFileSize = file.ContentLength;
                    if (NewFileSizeInKB > ContentFileSize || MaxFileSizeInKB == 0)
                    {
                        if (fileExtension.ToLower() == ".doc" || fileExtension.ToLower() == ".docx" || fileExtension.ToLower() == ".xlsx" || fileExtension.ToLower() == ".xls" || fileExtension.ToLower() == ".txt" || fileExtension.ToLower() == ".csv" || fileExtension.ToLower() == ".jpg" || fileExtension.ToLower() == ".jpeg" || fileExtension.ToLower() == ".pdf" || fileExtension.ToLower() == ".png" || fileExtension.ToLower() == ".gif")
                        {
                            if (!Directory.Exists(HttpContext.Current.Server.MapPath(folderPath))) Directory.CreateDirectory(HttpContext.Current.Server.MapPath(folderPath));
                            //var filelocation = string.Format("{0}/{1}", folderPath, Guid_id + fileExtension);
                            //    string newFileName = Path.Combine(folderPath, Guid_id );
                            //string newFileName = Path.Combine(folderPath, ViewState["equipmentCode"].ToString() + filename + fileExtension);
                            string newFileName = Path.Combine(HttpContext.Current.Server.MapPath(folderPath), filename.Replace(System.DateTime.Now.ToString(), "."));
                            file.SaveAs(newFileName);
                            context.Response.ContentType = "text/plain";
                            context.Response.Write(filename);
                        }
                        else
                        {
                            context.Response.ContentType = "text/plain";
                            context.Response.Write("Invalid file format!#999999#");
                        }
                    }
                    else
                    {
                        context.Response.Write("Maximum length of uploading file should be " + MaxFileSizeInKB + " KB!#999999#");
                    }
                }
            }

            if (context.Request.QueryString["file"] == "delete")
            {
                string filepath = HttpContext.Current.Server.MapPath(context.Request.Form.Get("filepath"));
                if (File.Exists(filepath))
                {
                    File.Delete(filepath);
                    context.Response.Write("File Deleted Successfully!");
                }
                else context.Response.Write("File not exist!");
            }
        }
    }


    public bool IsReusable {
        get {
            return false;
        }
    }

}