﻿<%@ WebHandler Language="C#" Class="EmployeeDetailsList" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;

public class EmployeeDetailsList : IHttpHandler
{
    DataSet dsUser;

    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";

        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        ClsEmployeeDetailsList objCls = Deserialize<ClsEmployeeDetailsList>(strJson);
        if (objCls != null)
        {
              
            string Key = objCls.key;

            dsUser = new DataSet();
            try
            {
                dsUser = new APIProcedure().ByProcedure("USP_EMPLOYEE",
                new string[] {  "key",
                                "employeeId",
                                "employeeName",
                                "designationID",
                                "genderID",
                                "fromOffice",
                                "fromDeptID",
                                "fromPlace",
                                "fromDistrictID",
                                "EmployeeType",
                                "ToDeptID",
                                "ToOffice",
                                "ToDistrictID",
                                "ToPlace",
                                "JoiningDate",
                                "RelivingDate",
                                "OrderDetails",
                                "remarks",
                                "isActive",
                                "action",
                                "createdBy" },
                new string[] { objCls.key,
                                objCls.employeeID,
                                objCls.employeeName,
                                objCls.designationID,
                                objCls.genderID,
                                objCls.fromOffice,
                                objCls.fromDeptID,
                                objCls.fromPlace,
                                objCls.fromDistrictID,
                                objCls.EmployeeType,
                                objCls.ToDeptID,
                                objCls.ToOffice,
                                objCls.ToDistrictID,
                                objCls.ToPlace,
                                objCls.JoiningDate,
                                objCls.RelivingDate,
                                objCls.OrderDetails,
                                objCls.remarks,
                                objCls.IsActive,
                                objCls.action,
                                objCls.createdBy }, "USPADDSETTING");
                if (dsUser.Tables.Count > 0)
                {
                    context.Response.Write(JsonConvert.ExportToString(dsUser.Tables[0].Rows));
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(JsonConvert.ExportToString("Error"));
                new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
            }
            finally { dsUser.Dispose(); }
        }

    }
    public T Deserialize<T>(string context)
    {
        string jsonData = context;
        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    class ClsEmployeeDetailsList
    {
        public string key { get; set; }
        public string employeeID { get; set; }
        public string employeeName { get; set; }
        public string designationID { get; set; }
       
        public string genderID { get; set; }
        public string fromOffice { get; set; }
        public string fromDeptID { get; set; }
        public string fromPlace { get; set; }
        public string fromDistrictID { get; set; }
        
        public string EmployeeType { get; set; }
        public string ToDeptID { get; set; }

        public string ToOffice { get; set; }
        public string ToDistrictID { get; set; }
        public string ToPlace { get; set; }
        public string JoiningDate { get; set; }
        public string RelivingDate { get; set; }
        public string OrderDetails { get; set; }
        public string remarks { get; set; }
        public string IsActive { get; set; }
        public string action { get; set; }
        public string createdBy { get; set; }
    }
}
