﻿<%@ WebHandler Language="C#" Class="Employee" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;

public class Employee : IHttpHandler
{
    DataSet dsUser;

    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";
        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        ClsEmployee objCls = Deserialize<ClsEmployee>(strJson);
        if (objCls != null)
        {
            string Key = objCls.key;

            dsUser = new DataSet();
            try
            {
                dsUser = new APIProcedure().ByProcedure("USP_EMPLOYEE",
                new string[] { "key", "saluteID", "employeename", "designation", "department", "district", "remark", "action", "createdBy" },
                new string[] { objCls.key, objCls.saluteID, objCls.employeename, objCls.designation, objCls.department, objCls.district, objCls.remark, objCls.action, objCls.createdBy }, "USPADDSETTING");

                if (dsUser.Tables.Count > 0)
                {
                    context.Response.Write(JsonConvert.ExportToString(dsUser.Tables[0].Rows));
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(JsonConvert.ExportToString("Error"));
                new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
            }
            finally { dsUser.Dispose(); }
        }

    }
    public T Deserialize<T>(string context)
    {
        string jsonData = context;
        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    class ClsEmployee
    {
        //"key","saluteID","name","designation","constituency","department","district","party","remark","isMinister","action","createdBy"
        public string key { get; set; }
        public string saluteID { get; set; }
        public string employeename { get; set; }
        public string designation { get; set; }
        public string department { get; set; }
        public string district { get; set; }
        public string remark { get; set; }
        public string action { get; set; }
        public string createdBy { get; set; }
    }
}
