﻿<%@ WebHandler Language="C#" Class="DesignationList" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;

public class DesignationList : IHttpHandler
{
    DataSet dsUser;

    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";

        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        ClsDesignationList objCls = Deserialize<ClsDesignationList>(strJson);
        if (objCls != null)
        {
              
            string Key = objCls.key;

            dsUser = new DataSet();
            try
            {
                dsUser = new APIProcedure().ByProcedure("USP_Designation",
                new string[] {  "key",
                                
                                "action",
                                "createdBy" },
                new string[] { objCls.key,
                                
                                objCls.action,
                                objCls.createdBy }, "USPADDSETTING");
                if (dsUser.Tables.Count > 0)
                {
                    context.Response.Write(JsonConvert.ExportToString(dsUser.Tables[0].Rows));
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(JsonConvert.ExportToString("Error"));
                new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
            }
            finally { dsUser.Dispose(); }
        }

    }
    public T Deserialize<T>(string context)
    {
        string jsonData = context;
        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    class ClsDesignationList
    {
        public string key { get; set; }
        public string DesignationName { get; set; }
        public string DesignationShortName { get; set; }
        public string DesignationNameHindi { get; set; }
        public string DesignationPostSeniority { get; set; }
        public string DesignationPromotionID { get; set; }
        public string action { get; set; }
        public string createdBy { get; set; }
    }
}
