﻿<%@ WebHandler Language="C#" Class="CreationList" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;

public class CreationList : IHttpHandler
{
    DataSet dsUser;

    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";

        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        ClsCreationList  objCls = Deserialize<ClsCreationList >(strJson);
        if (objCls != null)
        {
              
            string Key = objCls.key;

            dsUser = new DataSet();
            try
            {
                dsUser = new APIProcedure().ByProcedure("USP_CREATION",
                new string[] {  "key",
                                
                                "designationID",
                                "fromOffice",
                                "fromDepartmentID",
                                "fromPlace",
                                "fromDistrictID",
                                "PostStatus",
                                "PostType",
                                "isExtra",
                                "isRemoved",
                                "action",
                                
                                "createdBy" },
                new string[] { objCls.key,
                               
                                objCls.designationID,
                                objCls.fromOffice,
                                objCls.fromDepartmentID,
                                objCls.fromPlace,
                                objCls.fromDistrictID,
                                objCls.PostStatus,
                                objCls.PostType,
                                objCls.isExtra,
                                objCls.isRemoved,
                                objCls.action,
                                objCls.createdBy }, "USPADDSETTING");
                if (dsUser.Tables.Count > 0)
                {
                    context.Response.Write(JsonConvert.ExportToString(dsUser.Tables[0].Rows));
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(JsonConvert.ExportToString("Error"));
                new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
            }
            finally { dsUser.Dispose(); }
        }

    }
    public T Deserialize<T>(string context)
    {
        string jsonData = context;
        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    class ClsCreationList
    {
        public string key { get; set; }
        
        public string designationID { get; set; }
       
        public string fromOffice { get; set; }
        public string fromDepartmentID { get; set; }
        public string fromPlace { get; set; }
        public string fromDistrictID { get; set; }
       
        public string PostStatus { get; set; }
        public string PostType { get; set; }
        public string isExtra { get; set; }
        public string isRemoved { get; set; }
        public string action { get; set; }
        public string createdBy { get; set; }
    }
}
