﻿<%@ WebHandler Language="C#" Class="ComplianceReport" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;

public class ComplianceReport : IHttpHandler
{
    DataSet dsUser;

    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";
        //context.Response.Write("Hello World");
        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        ClsComplianceReport objCls = Deserialize<ClsComplianceReport>(strJson);
        if (objCls != null)
        {
            string Key = objCls.key;

            dsUser = new DataSet();
            try
            {
                dsUser = new APIProcedure().ByProcedure("USP_COMPLIANCE_TRANSFER",
                new string[] { "key", "proposalID", "complianceRemark", "action", "createdBy" },
                new string[] { objCls.key, objCls.proposalID, objCls.complianceRemark, objCls.action, objCls.createdBy }, "USPADDSETTING");
                
                if (dsUser.Tables.Count > 0)
                {
                    context.Response.Write(JsonConvert.ExportToString(dsUser.Tables[0].Rows));
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(JsonConvert.ExportToString("Error"));
                new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
            }
            finally { dsUser.Dispose(); }
        }

    }
    public T Deserialize<T>(string context)
    {
        string jsonData = context;
        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    class ClsComplianceReport
    {
        public string key { get; set; }
        public string proposalID { get; set; }
        public string complianceRemark { get; set; }
        public string action { get; set; }
        public string createdBy { get; set; }
    }
}
