﻿<%@ WebHandler Language="C#" Class="TransferList" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;

public class TransferList : IHttpHandler
{
    DataSet dsUser;

    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";

        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        ClsTransferList objCls = Deserialize<ClsTransferList>(strJson);
        if (objCls != null)
        {
            string Key = objCls.key;

            dsUser = new DataSet();
            try
            {
                dsUser = new APIProcedure().ByProcedure("USP_MANAGE_TRANSFER_APPLICATION",
                new string[] {  "key",
                                "employeeID",
                                "fromOffice",
                                "fromDepartmentID",
                                "fromPlace",
                                "fromDistrictID",
                                "toOffice",
                                "toDepartmentID",
                                "toPlace",
                                "toDistrictID",
                                "toOtherAlternates",
                                "applicationDate",
                                "pageNumber",
                                "normalReason",
                                "specialReason",
                                "isSpouseGovtJob",
                                "isPH",
                                "isFemale",
                                "isCMO",
                                "isPSITDesire",
                                "isCSITDesire",
                                "isTDJSDesire",
                                "isChronic",
                                "isSelfApplication",
                                "isComplaint",
                                "isMutual",
                                "mutualEmployeeID ",
                                "departmentalRequirement",
                                "representativeID ",
                                "representativeRemark1",
                                "representativeRemark2",
                                "officerID ",
                                "officerRemark1",
                                "officerRemark2",
                                "otherRemark",
                                "action",
                                "createdBy"  },
                new string[] {  objCls.key,
                                objCls.employeeID,
                                objCls.fromOffice,
                                objCls.fromDepartmentID,
                                objCls.fromPlace,
                                objCls.fromDistrictID,
                                objCls.toOffice,
                                objCls.toDepartmentID,
                                objCls.toPlace,
                                objCls.toDistrictID,
                                objCls.toOtherAlternates,
                                objCls.applicationDate,
                                objCls.pageNumber,
                                objCls.normalReason,
                                objCls.specialReason,
                                objCls.isSpouseGovtJob,
                                objCls.isPH,
                                objCls.isFemale,
                                objCls.isCMO,
                                objCls.isPSITDesire,
                                objCls.isCSITDesire,
                                objCls.isTDJSDesire,
                                objCls.isChronic,
                                objCls.isSelfApplication,
                                objCls.isComplaint,
                                objCls.isMutual,
                                objCls.mutualEmployeeID ,
                                objCls.departmentalRequirement,
                                objCls.representativeID ,
                                objCls.representativeRemark1,
                                objCls.representativeRemark2,
                                objCls.officerID ,
                                objCls.officerRemark1,
                                objCls.officerRemark2,
                                objCls.otherRemark,
                                objCls.action,
                                objCls.createdBy
                                 }, "USPADDSETTING");

                if (dsUser.Tables.Count == 1)
                {
                    context.Response.Write(JsonConvert.ExportToString(dsUser.Tables[0].Rows));
                }
                else if (dsUser.Tables.Count > 1)
                {
                    System.Text.StringBuilder sb = new System.Text.StringBuilder();
                    sb.Append("{");
                    for (int i = 0; i < dsUser.Tables.Count; i++)
                    {
                        sb.Append("\"table" + i.ToString() + "\":");
                        sb.Append(JsonConvert.ExportToString(dsUser.Tables[i].Rows));
                        sb.Append(",");
                    }
                    string str = sb.ToString();
                    str = str.Substring(0, str.Length - 1);
                    str += "}";
                    context.Response.Write(str);
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(JsonConvert.ExportToString("Error"));
                new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
            }
            finally { dsUser.Dispose(); }
        }

    }
    public T Deserialize<T>(string context)
    {
        string jsonData = context;
        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    class ClsTransferList
    {
        public string key { get; set; }
        public string employeeID { get; set; }
        public string fromOffice { get; set; }
        public string fromDepartmentID { get; set; }
        public string fromPlace { get; set; }
        public string fromDistrictID { get; set; }
        public string toOffice { get; set; }
        public string toDepartmentID { get; set; }
        public string toPlace { get; set; }
        public string toDistrictID { get; set; }
        public string toOtherAlternates { get; set; }
        public string applicationDate { get; set; }
        public string pageNumber { get; set; }
        public string normalReason { get; set; }
        public string specialReason { get; set; }
        public string isSpouseGovtJob { get; set; }
        public string isPH { get; set; }
        public string isFemale { get; set; }
        public string isCMO { get; set; }
        public string isPSITDesire { get; set; }
        public string isCSITDesire { get; set; }
        public string isSelfApplication { get; set; }
        public string isTDJSDesire { get; set; }
        public string isChronic { get; set; }
        public string isComplaint { get; set; }
        public string isMutual { get; set; }
        public string mutualEmployeeID { get; set; }
        public string departmentalRequirement { get; set; }
        public string representativeID { get; set; }
        public string representativeRemark1 { get; set; }
        public string representativeRemark2 { get; set; }
        public string officerID { get; set; }
        public string officerRemark1 { get; set; }
        public string officerRemark2 { get; set; }
        public string otherRemark { get; set; }
        public string action { get; set; }
        public string createdBy { get; set; }
    }
}
