﻿<%@ WebHandler Language="C#" Class="AddEditEmployee" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;

public class AddEditEmployee : IHttpHandler
{
    DataSet dsUser;

    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";

        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        ClsAddEditEmployee objCls = Deserialize<ClsAddEditEmployee>(strJson);
        if (objCls != null)
        {
            string Key = objCls.key;

            dsUser = new DataSet();
            try
            {
                dsUser = new APIProcedure().ByProcedure("USP_EMPLOYEE",
                new string[] {  "key",
                                "employeeName",
                                "employeeID",
                                "DesignationID",
                                "genderID",
                                "IsTSP",
                                "isPH",
                                "isDDP",
                                "EmpnameHindi",
                                "EmpFatherName",
                                "SaluteID",
                                "EmpnameFatherHindi",
                                "CategoryID",
                                "DOB",
                                "DOR",
                                "DOE",
                                "SIPFId",
                                "Qualification",
                                "CAddress",
                                "PAddress",
                                "HomeTown",
                                "State",
                                "Nationality",
                                "IPNumber",
                                "Mobile",
                                "PEmailId",
                                "OEmailId",
                                "Seniority",
                                "Remarks",
                                "action",
                                "createdBy"  },
                new string[] {  objCls.key,

                                objCls.employeeName,
                                objCls.employeeID,
                                objCls.DesignationID,
                                objCls.genderID,
                                objCls.IsTSP,
                                objCls.isPH,
                                objCls.isDDP,
                                objCls.EmpnameHindi,
                                objCls.EmpFatherName,
                                objCls.SaluteID,
                                objCls.EmpnameFatherHindi,
                                objCls.CategoryID,
                                objCls.DOB,
                                objCls.DOR,
                                objCls.DOE,

                                objCls.SIPFId,
                                objCls.Qualification,
                                objCls.CAddress,
                                objCls.PAddress,
                                objCls.HomeTown,
                                objCls.State,
                                objCls.Nationality,
                                objCls.IPNumber,
                                objCls.Mobile,
                                objCls.PEmailId,
                                objCls.OEmailId,
                                objCls.Seniority,
                                objCls.Remarks,
                                
                                objCls.action,
                                objCls.createdBy
                                 }, "USPADDSETTING");

                if (dsUser.Tables.Count == 1)
                {
                    context.Response.Write(JsonConvert.ExportToString(dsUser.Tables[0].Rows));
                }
                else if (dsUser.Tables.Count > 1)
                {
                    System.Text.StringBuilder sb = new System.Text.StringBuilder();
                    sb.Append("{");
                    for (int i = 0; i < dsUser.Tables.Count; i++)
                    {
                        sb.Append("\"table" + i.ToString() + "\":");
                        sb.Append(JsonConvert.ExportToString(dsUser.Tables[i].Rows));
                        sb.Append(",");
                    }
                    string str = sb.ToString();
                    str = str.Substring(0, str.Length - 1);
                    str += "}";
                    context.Response.Write(str);
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(JsonConvert.ExportToString("Error"));
                new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
            }
            finally { dsUser.Dispose(); }
        }

    }
    public T Deserialize<T>(string context)
    {
        string jsonData = context;
        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    class ClsAddEditEmployee
    {
        public string key { get; set; }
        public string employeeID { get; set; }
        public string employeeName { get; set; }

            public string DesignationID { get; set; }
            public string genderID { get; set; }
            public string IsTSP { get; set; }
            public string isPH { get; set; }
            public string isDDP { get; set; }
            public string EmpnameHindi { get; set; }
            public string EmpFatherName { get; set; }
            public string SaluteID { get; set; }
            public string EmpnameFatherHindi { get; set; }
            public string CategoryID { get; set; }
            public string DOB { get; set; }
            public string DOR { get; set; }
            public string DOE { get; set; }

            public string SIPFId { get; set; }
            public string Qualification { get; set; }
            public string CAddress { get; set; }
            public string PAddress { get; set; }
            public string HomeTown { get; set; }
            public string State { get; set; }
            public string Nationality { get; set; }
            public string IPNumber { get; set; }
            public string Mobile { get; set; }
            public string PEmailId { get; set; }
            public string OEmailId { get; set; }
            public string Seniority { get; set; }
            public string Remarks { get; set; }
            public string action { get; set; }
            public string createdBy { get; set; }
    }
}
