﻿<%@ WebHandler Language="C#" Class="AddEditDepartmentList" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;

public class AddEditDepartmentList : IHttpHandler
{
    DataSet dsUser;

    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";

        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        ClsAddEditDepartmentList objCls = Deserialize<ClsAddEditDepartmentList>(strJson);
        if (objCls != null)
        {
            string Key = objCls.key;

            dsUser = new DataSet();
            try
            {
                dsUser = new APIProcedure().ByProcedure("USP_Department",
                new string[] {  "key",
                "EditID",
                                "DepartmentName",
                                "DepartmentShortName",
                                "DepartmentNameHindi",
                                
                                "action",
                                "createdBy"  },
                new string[] {  objCls.key,
                                objCls.EditID,
                                objCls.DepartmentName,
                                objCls.DepartmentShortName,
                                objCls.DepartmentNameHindi,
                                                              
                                objCls.action,
                                objCls.createdBy
                                 }, "USPADDSETTING");

                if (dsUser.Tables.Count == 1)
                {
                    context.Response.Write(JsonConvert.ExportToString(dsUser.Tables[0].Rows));
                }
                else if (dsUser.Tables.Count > 1)
                {
                    System.Text.StringBuilder sb = new System.Text.StringBuilder();
                    sb.Append("{");
                    for (int i = 0; i < dsUser.Tables.Count; i++)
                    {
                        sb.Append("\"table" + i.ToString() + "\":");
                        sb.Append(JsonConvert.ExportToString(dsUser.Tables[i].Rows));
                        sb.Append(",");
                    }
                    string str = sb.ToString();
                    str = str.Substring(0, str.Length - 1);
                    str += "}";
                    context.Response.Write(str);
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(JsonConvert.ExportToString("Error"));
                new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
            }
            finally { dsUser.Dispose(); }
        }

    }
    public T Deserialize<T>(string context)
    {
        string jsonData = context;
        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    class ClsAddEditDepartmentList
    {
        public string key { get; set; } 
        public string EditID { get; set; }
        public string DepartmentName { get; set; }
        public string DepartmentShortName { get; set; }
        public string DepartmentNameHindi { get; set; }
           
        public string action { get; set; }
        public string createdBy { get; set; }
    }
}
