﻿<%@ WebHandler Language="C#" Class="AddEditCreation" %>
using System;
using System.Web;
using System.Data;
using System.IO;
using System.Web.Script.Serialization;
using Jayrock.Json.Conversion;

public class AddEditCreation : IHttpHandler
{
    DataSet dsUser;

    public void ProcessRequest(HttpContext context)
    {
        if (!HttpContext.Current.Request.Url.Host.Equals(System.Configuration.ConfigurationManager.AppSettings["IPaddress"]))
        {
            context.Response.Redirect("/404.html");
            return;
        }

        if (!OnlineUserCs.CheckToken(context))
        {
            context.Response.Write(JsonConvert.ExportToString("TokenExpire"));
            return;
        }
        context.Response.ContentType = "text/plain";

        string strJson = new StreamReader(context.Request.InputStream).ReadToEnd();

        ClsAddEditCreation  objCls = Deserialize<ClsAddEditCreation >(strJson);
        if (objCls != null)
        {
              
            string Key = objCls.key;

            dsUser = new DataSet();
            try
            {
                dsUser = new APIProcedure().ByProcedure("USP_CREATION",
                new string[] {  "key",
                "EditID",
                                "CreationDate",
                                "CreationOrderNo",
                                "CreationYear",
                                "AdminDep",
                                "designationID",
                                "FromOffice",
                                "FromDepartmentID",
                                "txtOfficeNameHindi",
                                "FromPlace",
                                "txtPlaceNameHindi",
                                "FromDistrictID",
                                "txtBudget",
                                "txtFinanceID",
                                "txtFinanceIDDate",
                                "PostPlan",
                                "PostDeputationType",
                                "PostAbolish",
                                "KeptInAbayence",
                                "Permanent",
                                "PostStatus",
                                "PostType",
                                "postRemark",
"txtNoPost",
                                "isExtra",
                                "action",
                                
                                "createdBy" },
                new string[] { objCls.key,
                               objCls.EditID,
                               objCls.CreationDate,
                               objCls.CreationOrderNo,
                               objCls.CreationYear,
                               objCls.AdminDep,
                               objCls.designationID,
                               objCls.FromOffice,
                               objCls.FromDepartmentID,
                               objCls.txtOfficeNameHindi,
                               objCls.FromPlace,
                               objCls.txtPlaceNameHindi,
                               objCls.FromDistrictID,
                               objCls.txtBudget,
                               objCls.txtFinanceID,
                               objCls.txtFinanceIDDate,
                               objCls.PostPlan,
                               objCls.PostDeputationType,
                               objCls.PostAbolish,
                               objCls.KeptInAbayence,
                               objCls.Permanent,
                               objCls.PostStatus,
                               objCls.PostType,
                               objCls.postRemark,
			       objCls.txtNoPost,
                               objCls.isExtra,
                               objCls.action,
                               objCls.createdBy }, "USPADDSETTING");
                if (dsUser.Tables.Count > 0)
                {
                    context.Response.Write(JsonConvert.ExportToString(dsUser.Tables[0].Rows));
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(JsonConvert.ExportToString("Error"));
                new APIProcedure().WriteLog(" Error Msg :" + ex.Message + "\n" + "Event Info :" + ex.StackTrace);
            }
            finally { dsUser.Dispose(); }
        }

    }
    public T Deserialize<T>(string context)
    {
        string jsonData = context;
        //cast to specified objectType
        var obj = (T)new JavaScriptSerializer().Deserialize<T>(jsonData);
        return obj;
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    class ClsAddEditCreation
    {
        public string key { get; set; }
        public string EditID { get; set; }
             public string CreationDate  { get; set; }
             public string CreationOrderNo { get; set; }
             public string CreationYear { get; set; }
             public string AdminDep { get; set; }
             public string designationID { get; set; }
             public string FromOffice { get; set; }
             public string FromDepartmentID { get; set; }
             public string txtOfficeNameHindi { get; set; }
             public string FromPlace { get; set; }
             public string txtPlaceNameHindi { get; set; }
             public string FromDistrictID { get; set; }
             public string txtBudget { get; set; }
             public string txtFinanceID { get; set; }
             public string txtFinanceIDDate { get; set; }
             public string PostPlan { get; set; }
             public string PostDeputationType { get; set; }
             public string PostAbolish { get; set; }
             public string KeptInAbayence { get; set; }
             public string Permanent { get; set; }
             public string PostStatus { get; set; }
            public string PostType { get; set; }
             public string postRemark { get; set; }
             public string txtNoPost { get; set; }
             public string isExtra { get; set; }

        public string action { get; set; }
        public string createdBy { get; set; }
    }
}
