﻿eApp.controller('UserRightsManagementCtrl', function ($translate, $rootScope, $scope, $timeout, cfpLoadingBar, CommService, ServiceUserRights, eAppVal, ngDialog, $controller, $compile) {
    cfpLoadingBar.start();
    $scope.fakeIntro = true;
    $timeout(function () {
        cfpLoadingBar.complete();
        $scope.fakeIntro = false;
        document.getElementById("wrapper").style.display = "Block";
    }, 750);

    $scope.currentPage = 1;
    $scope.ddlPageSize = eAppVal.GridPageSize;
    $scope.gvStatus = false;
    $("#gvStatus").css("display", "block");
    
    var rights_id = '0';
    var ActionName = 'SELECT';
   
    $scope.GetRights = [];
    $scope.FillUsers = [];
    $scope.FillModule = [];

    $scope.ShowPage = false;
    $scope.ShowBtnInsert = false;
    $scope.ShowBtnUpdate = false;
    $scope.ShowBtnDelete = false;

    CheckPageAuthentication();

    PageLoad();

    function CheckPageAuthentication() {
        CommService.CheckPageAuth('UserRightsManagement.html', CommService.GetUserId()).then(function (Rsp) {
            if (Rsp.data[0].PageDisplayStatus == "OK") {
                $scope.ShowPage = (Rsp.data[0].CanView == '0' || Rsp.data[0].CanView == 'false') ? false : true;
                $scope.ShowBtnInsert = (Rsp.data[0].CanInsert == '0' || Rsp.data[0].CanInsert == 'false') ? false : true;
                $scope.ShowBtnUpdate = (Rsp.data[0].CanUpdate == '0' || Rsp.data[0].CanUpdate == 'false') ? false : true;
                $scope.ShowBtnDelete = (Rsp.data[0].CanDelete == '0' || Rsp.data[0].CanDelete == 'false') ? false : true;
            }
            else {
                window.location.href = "401.html";
            }
        });
    }


    function PageLoad() {
        $scope.btnProcess = true;
        $scope.btnShow = true;
        $scope.btnAncShow = true;
        FillControll(); // Filling  Drop Down list
        if (rights_id == "0" || rights_id == null || rights_id == undefined) {
            $scope.btnClass = 'btn btn-success';
            $scope.btnLengText = "ApbtnSave";
        }
        else if (ActionName == "EDIT") {

            $scope.btnClass = 'btn btn-warning';
            $scope.btnLengText = "ApbtnUpdate";
        }
    }
    $scope.FillRights = function () {
        GetUserRights($scope.ddlModule == '' || $scope.ddlModule == 'undefined' || $scope.ddlModule == null ? '0' : $scope.ddlModule);
    }
    
    //OK
    $scope.FN_Check_All = function () {
        angular.forEach($scope.GetRights, function (value, index) {
            if ($scope.chkFSelectAll) value.can_insert = false;
            else value.can_insert = true;
        });
    }

    //OK
    $scope.UPDATE_Check_All = function () {
        angular.forEach($scope.GetRights, function (value, index) {
            if ($scope.chkUSelectAll) value.can_update = false;
            else value.can_update = true;
        });
    }
    
    //OK
    $scope.DELETE_Check_All = function () {
        angular.forEach($scope.GetRights, function (value, index) {
            if ($scope.chkDSelectAll) value.can_delete = false;
            else value.can_delete = true;
        });
    }

    //OK
    $scope.SELECT_Check_All = function () {
        angular.forEach($scope.GetRights, function (value, index) {
            if ($scope.chkSSelectAll) value.can_select = false;
            else value.can_select = true;
        });
    }
    
    //OK
    function GetUserRights(Module) {        
        $scope.GetRights = [];
        var userID = $scope.ddlUser == '' || $scope.ddlUser == 'undefined' || $scope.ddlUser == null ? '0' : $scope.ddlUser;
        if (userID != '0')
        {
            if (Module == '0') {
                ServiceUserRights.Save('GET_RIGHTS_FOR_VIEW', Module, '0', '0', userID, '', '', '', '', '', '', CommService.GetUserId()).then(function (response) {
                    $scope.GetRights = response.data;
                    FilterByUsers();
                    $scope.gvStatus = false;
                });
            }
            else {
                if ($scope.ShowBtnUpdate == false && $scope.ShowBtnInsert == false) {
                    message_warning("Unauthorized!", "You are not authorized to do this action.");
                    return;
                }
                $("#dvResult").html('');
                ServiceUserRights.Save('GET_RIGHTS_FOR_MODIFY', Module, '0', '0', userID, '', '', '', '', '', '', CommService.GetUserId()).then(function (response) {
                    $scope.GetRights = response.data;
                    debugger
                    if ($scope.GetRights.length > 0) {
                        $scope.gvStatus = true;
                    }
                    else {
                        $scope.gvStatus = false;
                    }
                });
            }
        }        
    }

    //OK
    function FilterByUsers() {
        debugger
        $scope.GetRightsParent = []
        $scope.GetChildofParent = []
        $scope.GetSubChildParent = []
        $("#dvResult").html('');
        //$("#gvStatus").css("display", "none");
        if ($scope.ddlUser == '') {
            //$("#gvStatus").css("display", "block");
        }
        if ($scope.GetRights.length > 0) {
            $scope.GetRightsParent = $scope.GetRights.filter(function (x) { return x.is_parent == false || x.is_parent == "0" });
            var list = "<div class='panel-group' id='accordion'>   "
            angular.forEach($scope.GetRightsParent, function (parent, index) {
                if (parent.rights_id > 0) {

                    list += "<div class='panel panel-default'>"
                    list += "<div class='panel-heading'>"
                    list += "<h4 class='panel-title'>"
                    list += "<a class='collapsed' data-toggle='collapse' data-parent='#accordion' href='#collapseTwo_" + parent.rights_id + "'>"
                    list += "<i class='more-less glyphicon glyphicon-plus'></i> " + parent.menu_title + ""
                    list += "</a>"
                    list += "</h4>"
                    list += "</div>"
                    list += "<!--/.panel-heading -->"
                    list += "<div id='collapseTwo_" + parent.rights_id + "' class='panel-collapse collapse'>"
                    list += "<div class='panel-body'>"

                    $scope.GetChildofParent = $scope.GetRights.filter(function (x) { return x.is_parent == true && x.parent_id == parent.menu_id && x.form_path == '#' });
                    if ($scope.GetChildofParent.length > 0) {

                        list += "<!-- nested -->"
                        list += "<div class='panel-group' id='nested_" + parent.rights_id + "'>"
                        angular.forEach($scope.GetChildofParent, function (child, child_index) {
                            list += "<div class='panel panel-default'>"
                            list += "<div class='panel-heading'>"
                            list += "<h4 class='panel-title'>"
                            list += "<a data-toggle='collapse' data-parent='#nested_" + parent.rights_id + "' href='#nested-collapseOne_" + child.rights_id + "'>"
                            list += "<i class='more-less glyphicon glyphicon-plus'></i> " + child.menu_title + ""
                            list += "</a>"
                            list += "</h4>"
                            list += "</div>"
                            list += "<!--/.panel-heading -->"
                            $scope.GetSubChildParent = $scope.GetRights.filter(function (x) { return x.is_parent == true && x.parent_id == child.menu_id && x.form_path !== '#' });
                            
                            if ($scope.GetSubChildParent.length > 0) {
                                list += "<div id='nested-collapseOne_" + child.rights_id + "' class='panel-collapse collapse in'>"
                                list += "<div class='panel-body'>"
                                list += "<div class='form-group'>"
                                list += "    <table width='100%' class='table table-striped table-bordered table-hover' id='dataTables-example'>"
                                list += " <thead>"
                                list += "                       <tr>"
                                list += "                           <th>S.No.</th>"
                                list += "                           <th>Page Title</th>"
                                list += "                           <th>Can Insert</th>"
                                list += "                           <th>Can Update</th>"
                                list += "                           <th>Can Delete</th>"
                                list += "                           <th>Can View</th>"
                                list += "                       </tr>"
                                list += "                   </thead>"
                                angular.forEach($scope.GetSubChildParent, function (SubChild, SubChildof_index) {
                                    list += "    <tr>"
                                    list += "        <td class='ng-binding'>" + parseInt(SubChildof_index + 1) + " <input type='hidden' ng-model='x.menu_id' value='x.menu_id' class='ng-pristine ng-valid'></td>"
                                    list += "        <td class='ng-binding'>" + SubChild.menu_title + "</td>"
                                    list += "        <td><input type='checkbox'  ng-checked='" + Boolean(SubChild.can_insert) + "' class='ng-pristine ng-valid' value='" + Boolean(SubChild.can_insert) + "' disabled></td>"
                                    list += "        <td><input type='checkbox'  ng-checked='" + SubChild.can_update + "' class='ng-pristine ng-valid' value='" + SubChild.can_update + "' disabled> </td>"
                                    list += "        <td><input type='checkbox'  ng-checked='" + SubChild.can_delete + "' class='ng-pristine ng-valid' value='" + SubChild.can_delete + "' disabled> </td>"
                                    list += "        <td><input type='checkbox'  ng-checked='" + SubChild.can_select + "' class='ng-pristine ng-valid' value='" + SubChild.can_select + "' disabled> </td>"
                                    list += "    </tr>"
                                });
                                list += "</table>"
                                list += "</div>"
                                list += "<!--/.panel-body -->"
                                list += "</div>"
                                list += "<!--/.panel-collapse --> "
                                list += "</div>"
                                list += "<!-- /.panel -->"
                                list += "</div>"
                            }
                        });
                        $scope.GetSubChildofParent = $scope.GetRights.filter(function (x) { return x.is_parent == true && x.parent_id == parent.parent_id && x.form_path !== '#' });
                        if ($scope.GetSubChildofParent.length > 0) {

                            list += "<div class='form-group'>"
                            list += "    <table width='100%' class='table table-striped table-bordered table-hover' id='dataTables-example'>"
                            list += " <thead>"
                            list += "                       <tr>"
                            list += "                           <th>S.No.</th>"
                            list += "                           <th>Page Title</th>"
                            list += "                           <th>Can Insert</th>"
                            list += "                           <th>Can Update</th>"
                            list += "                           <th>Can Delete</th>"
                            list += "                           <th>Can View</th>"
                            list += "                       </tr>"
                            list += "                   </thead>"
                            angular.forEach($scope.GetSubChildofParent, function (SubChildof, SubChildof_index) {
                                list += "    <tr>"
                                list += "        <td class='ng-binding'>" + parseInt(SubChildof_index + 1) + " <input type='hidden' ng-model='x.menu_id' value='x.menu_id' class='ng-pristine ng-valid'></td>"
                                list += "        <td class='ng-binding'>" + SubChildof.menu_title + "</td>"
                                list += "        <td><input type='checkbox'  ng-checked='" + SubChildof.can_insert + "' class='ng-pristine ng-valid' disabled></td>"
                                list += "        <td><input type='checkbox'  ng-checked='" + SubChildof.can_update + "' class='ng-pristine ng-valid' disabled> </td>"
                                list += "        <td><input type='checkbox'  ng-checked='" + SubChildof.can_delete + "' class='ng-pristine ng-valid' disabled> </td>"
                                list += "        <td><input type='checkbox'  ng-checked='" + SubChildof.can_select + "' class='ng-pristine ng-valid' disabled> </td>"
                                list += "    </tr>"
                            });
                            list += "</table>"
                            list += "</div>"
                        }

                        list += "</div>"
                        list += "<!-- /.panel-group -->"
                        list += "<!-- nested -->"

                    }
                    else {

                        $scope.GetSubChildParent = $scope.GetRights.filter(function (x) { return x.is_parent == true && x.parent_id == parent.menu_id && x.form_path !== '#' });
                        if ($scope.GetSubChildParent.length == 0) {
                            list += "<div class='form-group'>"
                            list += "    <table width='100%' class='table table-striped table-bordered table-hover' id='dataTables-example'>"
                            list += " <thead>"
                            list += "                       <tr>"
                            list += "                           <th>S.No.</th>"
                            list += "                           <th>Page Title</th>"
                            list += "                           <th>Can Insert</th>"
                            list += "                           <th>Can Update</th>"
                            list += "                           <th>Can Delete</th>"
                            list += "                           <th>Can View</th>"
                            list += "                       </tr>"
                            list += "                   </thead>"
                            list += "    <tr>"
                            list += "        <td class='ng-binding'>" + parseInt(1) + " <input type='hidden' ng-model='x.menu_id' value='x.menu_id' class='ng-pristine ng-valid'></td>"
                            list += "        <td class='ng-binding'>" + parent.menu_title + "</td>"
                            list += "        <td><input type='checkbox'  ng-checked='" + Boolean(parent.can_insert) + "' class='ng-pristine ng-valid' value='" + Boolean(parent.can_insert) + "' disabled></td>"
                            list += "        <td><input type='checkbox'  ng-checked='" + parent.can_update + "' class='ng-pristine ng-valid' value='" + parent.can_update + "'disabled> </td>"
                            list += "        <td><input type='checkbox'  ng-checked='" + parent.can_delete + "' class='ng-pristine ng-valid' value='" + parent.can_delete + "'disabled> </td>"
                            list += "        <td><input type='checkbox'  ng-checked='" + parent.can_select + "' class='ng-pristine ng-valid' value='" + parent.can_select + "'disabled> </td>"
                            list += "    </tr>"
                            list += "</table>"
                            list += "</div>"
                        }
                        else {
                            list += "<div class='form-group'>"
                            list += "    <table width='100%' class='table table-striped table-bordered table-hover' id='dataTables-example'>"
                            list += " <thead>"
                            list += "                       <tr>"
                            list += "                           <th>S.No.</th>"
                            list += "                           <th>Page Title</th>"
                            list += "                           <th>Can Insert</th>"
                            list += "                           <th>Can Update</th>"
                            list += "                           <th>Can Delete</th>"
                            list += "                           <th>Can View</th>"
                            list += "                       </tr>"
                            list += "                   </thead>"
                            angular.forEach($scope.GetSubChildParent, function (SubChild, SubChildof_index) {
                                list += "    <tr>"
                                list += "        <td class='ng-binding'>" + parseInt(SubChildof_index + 1) + " <input type='hidden' ng-model='x.menu_id' value='x.menu_id' class='ng-pristine ng-valid'></td>"
                                list += "        <td class='ng-binding'>" + SubChild.menu_title + "</td>"
                                list += "        <td><input type='checkbox'  ng-checked='" + Boolean(SubChild.can_insert) + "' class='ng-pristine ng-valid' value='" + Boolean(SubChild.can_insert) + "' disabled></td>"
                                list += "        <td><input type='checkbox'  ng-checked='" + SubChild.can_update + "' class='ng-pristine ng-valid' value='" + SubChild.can_update + "' disabled> </td>"
                                list += "        <td><input type='checkbox'  ng-checked='" + SubChild.can_delete + "' class='ng-pristine ng-valid' value='" + SubChild.can_delete + "' disabled> </td>"
                                list += "        <td><input type='checkbox'  ng-checked='" + SubChild.can_select + "' class='ng-pristine ng-valid' value='" + SubChild.can_select + "' disabled> </td>"
                                list += "    </tr>"
                            });
                            list += "</table>"
                            list += "</div>"
                        }
                    }
                    list += "</div>"
                    list += "<!--/.panel-body -->"
                    list += "</div>"
                    list += "<!--/.panel-collapse -->"
                    list += "</div>"
                    list += "<!-- /.panel -->"
                }

            });
            list += " </div>"
            list += "<!-- /.panel-group -->"
            list += "<!-- /.panel-group -->"
            if ($scope.GetRights.length > 0) $compile($("#dvResult").append(list))($scope);

            if ($scope.GetRights.length > 0) {
                debugger
                $scope.gvStatus = true;
                if ($scope.GetRights[0] == "Error") {
                    $("#gvStatus").css("display", "block");
                }
                if ($scope.ddlUser == '') {
                    $("#gvStatus").css("display", "block");
                    // alert()
                }
            }
            else {
                $scope.gvStatus = false;
                $("#gvStatus").css("display", "block");
            }
        }
        else {
            $("#dvResult").html('');
            $("#gvStatus").css("display", "block");

        }

        if (list == "<div class='panel-group' id='accordion'>    </div><!-- /.panel-group --><!-- /.panel-group -->") {
            $("#gvStatus").css("display", "block");
        }
    }

    //OK
    function FillControll() {
        $scope.ddlUserType = '';
        ServiceUserRights.Save('GET_USERS', '0', '0', '0', '0', '0', '0', '', '', '', '', '', '', CommService.GetUserId()).then(function (response) {
            $scope.FillUsers = response.data;
        });
        $scope.ddlModule = '';
        ServiceUserRights.Save('GET_MODULE', '0', '0', '0', '0', '0', '0', '', '', '', '', '', '', CommService.GetUserId()).then(function (response) {
            $scope.FillModule = response.data;
        });
        document.getElementById("ddlModule").disabled = true;
    }

    $scope.EnableModule = function () {
        if ($scope.ddlUser == '' || $scope.ddlUser == 'undefined' || $scope.ddlUser == '0' || $scope.ddlUser == null) {
            $scope.ddlModule = '';
            document.getElementById("ddlModule").disabled = true;
            $("#dvResult").html('');
            $scope.gvStatus = false;
        }
        else {
            document.getElementById("ddlModule").disabled = false;
        }
        $scope.FillRights();
    }

    //OK
    $scope.Reset = function Reset() {
        $scope.btnProcess = true;
        $scope.ddlUser = '';       
        $scope.ddlModule = '';
        $scope.FillUsers = [];      
        $scope.FillModule = [];
        $scope.GetRights = [];
        $scope.btnClass = 'btn btn-success';
        $scope.btnLengText = "ApbtnSave";
        PageLoad();
    }

    $scope.Save_Click = function () {
        $scope.btnProcess = false;
        var frmData = [];
        var myData = new Object();
        $scope.DataRights = [];

        $scope.GetRights.forEach(function (el) {
            myData = new Object();
            myData.type = "SAVE_RIGHTS";
            myData.parent_menu_id = "0";
            myData.child_menu_id = el.menu_id;
            myData.rights_id = "0";
            myData.user_id = $scope.ddlUser;
            myData.url = el.menu_id;
            myData.is_insert = el.can_insert;
            myData.is_update = el.can_update;
            myData.is_delete = el.can_delete;
            myData.is_select = el.can_select;
            myData.is_active = "1";
            myData.created_by = CommService.GetUserId();
            frmData.push(myData);
        });

        ServiceUserRights.SaveType(frmData).then(function (Rsp) {
            if (Rsp.data[0].Msg == 'ADDED') {
                message_success("Success", "Record Saved Successfully.");
                $scope.btnProcess = true;

            }
            else if (Rsp.data[0].Msg == 'Already Exist, Please Edit the Rights.') {
                message_success("Error", response.data[0].Msg);
                $scope.btnProcess = true;
            }
            else {
                message_success("Error", Rsp.data[0].Msg);
                $scope.btnProcess = true;
            }
        });
    };

    $scope.GoToUpdate = function (id, Action) {
        rights_id = id;
        ActionName = Action;
        PageLoad();
    };

    $scope.GoToDelete = function (id) {
        var r = '';
        rights_id = id;
        r = confirm('Are your sure you want to delete this record...!!!')
        if (r == true) {
            ServiceUserRights.Save('DELETE', rights_id, '', '0', '0', '0.0', '0.0', '', '', '', CommService.GetUserId()).then(function (response) {

                message_success("Delete", "Record Deleted Successfully.");
                rights_id = "0";
                PageLoad();
            });
        }
        rights_id = "0";
        PageLoad();
    };
});

eApp.service("ServiceUserRights", function ($http, $rootScope) {
    var saveSts = '';
    var RspData = [];
    this.SaveType = function (frmData) {
        saveSts = $http({
            method: 'post',
            data: angular.toJson(frmData),
            url: 'Handler/UserRightsManagement.ashx',
            datatype: "json"
        }).success(function (rsp) {
            if (rsp == "TokenExpire") {
                message_error("Token Expired", "Oops! You are not authorized to process any request. Login again.", function () { $rootScope.signOut(); });
            }
            else {
                RspData = rsp;
                return RspData;
            }
        }).error(function (rsp) {
            alert('Error');
        });
        return saveSts;
    };
    this.Save = function (Action, parent_menu_id, child_menu_id, rights_id, user_id, url, is_insert, is_update, is_delete, is_select, is_active, created_by) {
        var formData = new FormData();

        formData.Action = Action;
        formData.parent_menu_id = parent_menu_id;
        formData.child_menu_id = child_menu_id;
        formData.rights_id = rights_id;
        formData.user_id = user_id;
        formData.url = url;
        formData.is_insert = is_insert;
        formData.is_update = is_update;
        formData.is_delete = is_delete;
        formData.is_select = is_select;
        formData.is_active = is_active;
        formData.CreatedBy = created_by;

        saveSts = $http({
            data: formData,
            method: 'post',
            url: 'Handler/UserRightsManagement.ashx',
            datatype: "json"
        }).success(function (rsp) {
            if (rsp == "TokenExpire") {
                message_error("Token Expired", "Oops! You are not authorized to process any request. Login again.", function () { $rootScope.signOut(); });
            }
            else {
                RspData = rsp;
                return RspData;
            }
        }).error(function (rsp) {
            alert('Error');
        });
        return saveSts;
    };


});