﻿eApp.controller('UserRegistration-Ctrl', function ($translate, $rootScope, $scope, $timeout, $filter, cfpLoadingBar, CommService, ServiceUserRegistration, eAppVal, ngDialog, $controller) {
    cfpLoadingBar.start();
    $scope.fakeIntro = true;
    $timeout(function () {
        cfpLoadingBar.complete();
        $scope.fakeIntro = false;
        document.getElementById("wrapper").style.display = "Block";
    }, 750);
    var rec_user_id = "1"
    $scope.currentPage = 1;
    $scope.ddlPageSize = eAppVal.GridPageSize;
    $scope.gvStatus = false;

    var _key = 'SELECT';
    $scope.EditID = '0';
    $scope.IsPwdMatched = 'X'

    $scope.btnProcess = true;
    $scope.btnShow = true;
    $scope.txtSSOId = '';
    $scope.txtName = '';
    $scope.IsActive = 0;
    $scope.IsAdmin = 0;
    $scope.IsLoginUserAdmin = false;
    $scope.ShowPage = false;
    $scope.ShowBtnInsert = false;
    $scope.ShowBtnUpdate = false;
    $scope.ShowBtnDelete = false;

    $scope.UserList = [];
    debugger
    if ((window.localStorage.getItem("isLoginUserAdmin") != null
        && window.localStorage.getItem("isLoginUserAdmin") != 'undefined'
        && window.localStorage.getItem("isLoginUserAdmin") == '1')) {
        $scope.IsLoginUserAdmin = true;
    }

    CheckPageAuthentication();

    PageLoad();

    function CheckPageAuthentication() {
        //For Add/Edit pages, provide the parent page name
        CommService.CheckPageAuth('UserRegistration.html', CommService.GetUserId()).then(function (Rsp) {
            if (Rsp.data[0].PageDisplayStatus == "OK") {
                $scope.ShowPage = (Rsp.data[0].CanView == '0' || Rsp.data[0].CanView == 'false') ? false : true;
                $scope.ShowBtnInsert = (Rsp.data[0].CanInsert == '0' || Rsp.data[0].CanInsert == 'false') ? false : true;
                $scope.ShowBtnUpdate = (Rsp.data[0].CanUpdate == '0' || Rsp.data[0].CanUpdate == 'false') ? false : true;
                $scope.ShowBtnDelete = (Rsp.data[0].CanDelete == '0' || Rsp.data[0].CanDelete == 'false') ? false : true;
            }
            else {
                window.location.href = "401.html";
            }
        });
    }

    $scope.OnSearchBy = function () {
        filtergrid();
    }

    function PageLoad() {

        $("#IsPwdMatched").html("");

        $scope.UserList = [];
        ServiceUserRegistration.GetSet('SELECT', $scope.txtSSOId, $scope.txtName, $scope.IsActive, $scope.IsAdmin, $scope.EditID, CommService.GetUserId()).then(function (response) {
            debugger
            $scope.UserList = response.data;
            if ($scope.UserList.length > 0) {
                $scope.gvStatus = true;
                $scope.txtSSOId = '';
                $scope.txtName = '';
                $scope.txtUserName = '';
                $scope.txtPassword = '';
                $scope.txtConfirmPassword = '';
                $scope.IsActive = false;
                $scope.IsAdmin = false;
                document.getElementById("IsPwdMatched").value = '';
                document.getElementById("txtUserName").disabled = false;
                document.getElementById("txtPassword").disabled = false;
                document.getElementById("txtConfirmPassword").disabled = false;
            }
            else {
                $scope.gvStatus = false;
            }
        });
    }

    $scope.Save_Click = function () {
        debugger
        $scope.GetSetData($scope.EditID == '0' ? 'INSERT' : 'UPDATE', $scope.EditID);
    };

    $scope.GetSetData = function GetSetData(key, id) {

        debugger
        if (key == 'SELECT') {
            $scope.UserList = [];
            ServiceUserRegistration.GetSet(key, $scope.txtSSOId, $scope.txtName, $scope.txtUserName, $scope.txtPassword, $scope.IsActive, $scope.IsAdmin, id, CommService.GetUserId()).then(function (response) {
                debugger
                $scope.UserList = response.data;
                if ($scope.UserList.length > 0) {
                    $scope.gvStatus = true;
                }
                else {
                    $scope.gvStatus = false;
                }
            });
        }
        else if (key == 'INSERT') {
            if ($scope.ShowBtnInsert == false) {
                message_warning("Unauthorized!", "You are not authorized to do this action.");
                return;
            }
            $scope.btnProcess = false;
            if ($scope.txtPassword != $scope.txtConfirmPassword) {
                message_warning("Validation", "Password Not Matched");
                return;
            }
            ServiceUserRegistration.GetSet(key, $scope.txtSSOId, $scope.txtName, $scope.txtUserName, $scope.txtPassword, $scope.IsActive, $scope.IsAdmin, id, CommService.GetUserId()).then(function (response) {
                if (response.data[0].Msg == 'OK') {
                    message_success("Success", "Record Saved Successfully.");
                    $scope.btnProcess = true;
                    PageLoad();
                } else {
                    message_warning("Error", response.data[0].Msg);
                    $scope.btnProcess = true;
                }
            })
        }
        else if (key == 'UPDATE') {
            if ($scope.ShowBtnUpdate == false) {
                message_warning("Unauthorized!", "You are not authorized to do this action.");
                return;
            }
            $scope.btnProcess = false;
            if ($scope.txtPassword != $scope.txtConfirmPassword) {
                message_warning("Validation", "Password Not Matched");
                return;
            }
            ServiceUserRegistration.GetSet(key, $scope.txtSSOId, $scope.txtName, $scope.txtUserName, $scope.txtPassword, $scope.IsActive, $scope.IsAdmin, id, CommService.GetUserId()).then(function (response) {
                if (response.data[0].Msg == 'OK') {
                    message_success("Success", "Record Updated Successfully.");
                    $scope.btnProcess = true;
                    PageLoad();
                } else {
                    message_warning("Error", response.data[0].Msg);
                    $scope.btnProcess = true;
                }
            })
        }
        else if (key == 'DELETE') {
            if ($scope.ShowBtnDelete == false) {
                message_warning("Unauthorized!", "You are not authorized to do this action.");
                return;
            }
            if (confirm("Are you sure you want to delete this record?")) {
                ServiceUserRegistration.GetSet(key, $scope.txtSSOId, $scope.txtName, $scope.txtUserName, $scope.txtPassword, $scope.IsActive, $scope.IsAdmin, id, CommService.GetUserId()).then(function (response) {
                    if (response.data[0].Msg == 'OK') {
                        message_success("Success", "Record Updated Successfully.");
                        $scope.btnProcess = true;
                        PageLoad();
                    } else {
                        message_warning("Error", response.data[0].Msg);
                        $scope.btnProcess = true;
                    }
                });
            }
        }
    }

    $scope.FillValuesForEdit = function FillValuesForEdit(x) {
        $scope.EditID = x.Id;
        $scope.txtSSOId = x.SSOID;
        $scope.txtName = x.Name;
        $scope.IsActive = x.IsActive == 1 ? true : false;
        $scope.IsAdmin = x.IsAdmin == 1 ? true : false;
        $scope.txtUserName = x.Username;
    }

    $scope.Reset = function Reset() {
        $scope.EditID = '';
        $scope.txtSSOId = '';
        $scope.txtName = '';
        $scope.txtUserName = '';
        $scope.txtPassword = '';
        $scope.txtConfirmPassword = '';
        $scope.IsActive = false;
        $scope.IsAdmin = false;
        document.getElementById("txtUserName").disabled = false;
        document.getElementById("txtPassword").disabled = false;
        document.getElementById("txtConfirmPassword").disabled = false;
    }
});
eApp.service("ServiceUserRegistration", function ($http, $rootScope) {
    var saveSts = '';
    var RspData = [];
    this.GetSet = function (key, ssoID, name,  username, password, isActive, isAdmin, action, createdBy) {
        var formData = new FormData();
        formData.key = key;
        formData.action = action;
        formData.ssoID = ssoID;
        formData.createdBy = createdBy;
        formData.name = name;
        formData.username = username;
        formData.password = password;
        formData.isActive = isActive;
        formData.isAdmin = isAdmin;
        saveSts = $http({
            data: formData,
            method: 'post',
            url: 'Handler/UserRegistration.ashx',
            datatype: "json"
        }).success(function (rsp) {
            if (rsp == "TokenExpire") {
                message_error("Token Expired", "Oops! You are not authorized to process any request. Login again.", function () { $rootScope.signOut(); });
            }
            else {
                RspData = rsp;
                return RspData;
            }
        }).error(function (rsp) {
            alert('Error');
        });
        return saveSts;
    };
});
eApp.config(function ($translateProvider) {
    $translateProvider.translations('en', {
        UserSSOMappingMaster: 'User / SSO Mapping Master'
        , Department: 'Department'
        , SSUserType: 'User Type'
        , SSRole: 'User Role'
        , SSRoleType: 'Designation / Authorized'
        , Module: 'Module'
        , SubModule: 'Sub Module'
        , SubSubModule: 'Sub Sub Module'
        , form: 'Form'
        , SSOid: 'SSO ID'
        , zp: 'District'
        , ps: 'Panchayat Samiti'
        , gp: 'Gram Panchayat'
    });
    $translateProvider.translations('de', {
        UserSSOMappingMaster: 'यूजर / एस. एस. ओ. मैपिंग मास्टर'
        , Department: 'विभाग'
        , SSUserType: 'यूजर का प्रकार'
        , SSRole: 'यूजर रोल'
        , SSRoleType: 'पद / अधिकृत'
        , Module: 'मोड्यूल'
        , SubModule: 'सब मोड्यूल'
        , SubSubModule: 'सब सब मोड्यूल'
        , form: 'फॉर्म'
        , SSOid: 'एस. एस. ओ. आई डी'
        , zp: 'जिला परिषद्'
        , ps: 'पंचायत समिति'
        , gp: 'ग्राम पंचायत'
    });
    $translateProvider.preferredLanguage('en');
});