﻿eApp.controller('TransferProposal-Ctrl', function ($translate, $rootScope, $scope, $timeout, $filter, cfpLoadingBar, CommService, ServiceTransferProposal, eAppVal, ngDialog, $controller) {
    cfpLoadingBar.start();
    $scope.fakeIntro = true;
    $timeout(function () {
        cfpLoadingBar.complete();
        $scope.fakeIntro = false;
        document.getElementById("wrapper").style.display = "Block";
    }, 750);
    var rec_user_id = "1"
    $scope.currentPage = 1;
    $scope.currentPageDetail = 1;
    $scope.ddlPageSize = eAppVal.GridPageSize;
    $scope.ddlPageSizeDetail = eAppVal.GridPageSize;
    $scope.gvStatus = false;
    $scope.ngClose = {};

    $scope.EditID = '0';

    $scope.ShowPage = false;
    $scope.ShowBtnInsert = false;
    $scope.ShowBtnUpdate = false;
    $scope.ShowBtnDelete = false;

    $scope.btnProcess = true;
    $scope.btnShow = true;
    $scope.txtProposalName = '';
    $scope.txtProposalDate = '';
    $scope.IsActive = 0;
    $scope.ShowAll = false;
    $scope.IsLoginUserAdmin = false;


    $scope.ProposalList = [];
    $scope.TransferDetailList = [];
    
   
    CheckPageAuthentication();

    PageLoad();

    function CheckPageAuthentication() {
        //For Add/Edit pages, provide the parent page name
        CommService.CheckPageAuth('TransferProposal.html', CommService.GetUserId()).then(function (Rsp) {
            if (Rsp.data[0].PageDisplayStatus == "OK") {
                $scope.ShowPage = (Rsp.data[0].CanView == '0' || Rsp.data[0].CanView == 'false') ? false : true;
                $scope.ShowBtnInsert = (Rsp.data[0].CanInsert == '0' || Rsp.data[0].CanInsert == 'false') ? false : true;
                $scope.ShowBtnUpdate = (Rsp.data[0].CanUpdate == '0' || Rsp.data[0].CanUpdate == 'false') ? false : true;
                $scope.ShowBtnDelete = (Rsp.data[0].CanDelete == '0' || Rsp.data[0].CanDelete == 'false') ? false : true;
            }
            else {
                window.location.href = "401.html";
            }
        });
    }

    $scope.OnSearchBy = function () {
        filtergrid();
    }

    function PageLoad() {
        $scope.ProposalList = [];
        ServiceTransferProposal.GetSet($scope.ShowAll == true ? 'SELECT_ALL' : 'SELECT', $scope.txtProposalName, document.getElementById('txtProposalDate').value, $scope.IsActive, $scope.EditID, "", "", CommService.GetUserId()).then(function (response) {
            
            $scope.ProposalList = response.data;
            if ($scope.ProposalList.length > 0) {
                $scope.gvStatus = true;
                $scope.txtProposalName = '';
                $scope.txtProposalDate = '';
                document.getElementById('txtProposalDate').value = '';
                $scope.IsActive = 0;
            }
            else {
                $scope.gvStatus = false;
            }
        });
    }

    $scope.Save_Click = function () {
        
        $scope.GetSetData($scope.EditID == '0' ? 'INSERT' : 'UPDATE', $scope.EditID);
    };

    $scope.GetSetData = function GetSetData(key, x_id) {
        if (key == 'SELECT') {
            $scope.ProposalList = [];
            ServiceTransferProposal.GetSet(key, $scope.txtProposalName, document.getElementById('txtProposalDate').value, $scope.IsActive, x_id, "", "", CommService.GetUserId()).then(function (response) {
                
                $scope.ProposalList = response.data;
                if ($scope.ProposalList.length > 0) {
                    $scope.gvStatus = true;
                }
                else {
                    $scope.gvStatus = false;
                }
            });
        }
        else if (key == 'INSERT') {
            if ($scope.ShowBtnInsert == false) {
                message_warning("Unauthorized!", "You are not authorized to do this action.");
                return;
            }
            $scope.btnProcess = false;
            ServiceTransferProposal.GetSet(key, $scope.txtProposalName, document.getElementById('txtProposalDate').value, $scope.IsActive, x_id, "", "", CommService.GetUserId()).then(function (response) {
                if (response.data[0].Msg == 'OK') {
                    message_success("Success", "Record Saved Successfully.");
                    $scope.btnProcess = true;
                    PageLoad();
                } else {
                    message_warning("Error", response.data[0].Msg);
                    $scope.btnProcess = true;
                }
            })
        }
        else if (key == 'UPDATE') {
            if ($scope.ShowBtnUpdate == false) {
                message_warning("Unauthorized!", "You are not authorized to do this action.");
                return;
            }
            $scope.btnProcess = false;
            ServiceTransferProposal.GetSet(key, $scope.txtProposalName, document.getElementById('txtProposalDate').value, $scope.IsActive, x_id, "", "", CommService.GetUserId()).then(function (response) {
                if (response.data[0].Msg == 'OK') {
                    message_success("Success", "Record Updated Successfully.");
                    $scope.btnProcess = true;
                    PageLoad();
                } else {
                    message_warning("Error", response.data[0].Msg);
                    $scope.btnProcess = true;
                }
            })
        }
        else if (key == 'DELETE') {
            if ($scope.ShowBtnDelete == false) {
                message_warning("Unauthorized!", "You are not authorized to do this action.");
                return;
            }
            if (confirm("The transfer records under this proposal will also be deleted permanently. Are you sure you want to delete this proposal?")) {
                ServiceTransferProposal.GetSet(key, $scope.txtProposalName, document.getElementById('txtProposalDate').value, $scope.IsActive, x_id, "", "", CommService.GetUserId()).then(function (response) {
                    if (response.data[0].Msg == 'OK') {
                        message_success("Success", "Record Deleted Successfully.");
                        $scope.btnProcess = true;
                        PageLoad();
                    } else {
                        message_warning("Error", response.data[0].Msg);
                        $scope.btnProcess = true;
                    }
                });
            }
        }
        else if (key == 'CLOSE') {
           
            var closingDate = document.getElementById('txtClosingDate').value;

            if (closingDate == null || closingDate == "")
            {
                message_warning("Validation", "Please select closing date");
                return;
            }
            
            if (confirm("Are you sure you want to CLOSE this proposal?")) {
                ServiceTransferProposal.GetSet(key, "", "", "", x_id.Id, $scope.Remark.replace(/\r\n|\r|\n/g, "</br>"), closingDate, CommService.GetUserId()).then(function (response) {
                    if (response.data[0].Msg == 'OK') {
                        message_success("Success", "Proposal Closed Successfully!");
                        $scope.btnProcess = true;
                        $("#myModalProposalClose").modal('toggle');
                        PageLoad();
                    } else {
                        message_warning("Error", response.data[0].Msg);
                        $scope.btnProcess = true;
                    }
                });
            }
        }
    }

    $scope.CheckedChangedShowAll = function CheckedChangedShowAll() {
        $scope.ProposalList = [];
        ServiceTransferProposal.GetSet($scope.ShowAll == true ? 'SELECT_ALL' : 'SELECT', $scope.txtProposalName, document.getElementById('txtProposalDate').value, $scope.IsActive, $scope.EditID, "", "", CommService.GetUserId()).then(function (response) {
            
            $scope.ProposalList = response.data;
            if ($scope.ProposalList.length > 0) {
                $scope.gvStatus = true;
            }
            else {
                $scope.gvStatus = false;
            }
        });
    }

    $scope.FillValuesForEdit = function FillValuesForEdit(x) {
        $scope.EditID = x.Id;
        $scope.txtProposalName = x.ProposalName;
        $scope.txtProposalDate = x.ProposalDate;
        $scope.IsActive = x.IsActive == 1 ? true : false;
    }

    $scope.Reset = function Reset() {
        $scope.EditID = '0';
        $scope.txtProposalName = '';
        $scope.txtProposalDate = '';
        document.getElementById('txtProposalDate').value = '';
        $scope.IsActive = false;
    }

    $scope.ViewClosingModal = function (x) {
        $scope.ngClose = x;
        $("#myModalProposalClose").modal('toggle');
    };

    $scope.OpenTransferListPage = function (Id) {
        window.localStorage.removeItem("SessionTransferProposalID");
        window.localStorage.setItem("SessionTransferProposalID", Id);
        window.location.href = "TransferList.html";
    }

    $scope.OpenTransferDetail = function (x) {

        $("#myHistoryModal").modal('toggle');
        document.getElementById('lblProposalName').innerHTML = x.ProposalName;
        document.getElementById('lblProposalCloseDate').innerHTML = x.ClosingDate;
        document.getElementById('lblProposalRemark').innerHTML = x.Remark;

        $scope.TransferDetailList = [];
        
        ServiceTransferProposal.GetSet("SELECT_TRANSFER_DETAIL", "", "", "", x.Id, "", "", CommService.GetUserId()).then(function (response) {            
            $scope.TransferDetailList = response.data;
        });
    }
});
eApp.filter('unsafe', function ($sce) {
    return function (val) {
        return $sce.trustAsHtml(val);
    };
});
eApp.service("ServiceTransferProposal", function ($http, $rootScope) {
    var saveSts = '';
    var RspData = [];
    this.GetSet = function (key, proposalName, proposalDate, isActive, action, remark, closingDate, createdBy) {
        var formData = new FormData();
        formData.key = key;
        formData.proposalName = proposalName;
        formData.proposalDate = proposalDate;
        formData.isActive = isActive;
        formData.action = action;
        formData.remark = remark;
        formData.closingDate = closingDate;
        formData.createdBy = createdBy;

        saveSts = $http({
            data: formData,
            method: 'post',
            url: 'Handler/TransferProposal.ashx',
            datatype: "json"
        }).success(function (rsp) {
            if (rsp == "TokenExpire") {
                message_error("Token Expired", "Oops! You are not authorized to process any request. Login again.", function () { $rootScope.signOut(); });
            }
            else {
                RspData = rsp;
                return RspData;
            }
        }).error(function (rsp) {
            alert('Error');
        });
        return saveSts;
    };
});
