﻿eApp.controller('TransferList-Ctrl', function ($translate, $rootScope, $scope, $timeout, $filter, cfpLoadingBar, CommService, ServiceTransferList, eAppVal, ngDialog, $controller) {
    cfpLoadingBar.start();
    $scope.fakeIntro = true;
    $timeout(function () {
        cfpLoadingBar.complete();
        $scope.fakeIntro = false;
        document.getElementById("wrapper").style.display = "Block";
    }, 750);
    var rec_user_id = "1"
    $scope.currentPage = 1;
    $scope.ddlPageSize = eAppVal.GridPageSize;
    $scope.gvStatus = false;
    $scope.ShowPage = false;
    $scope.ShowBtnInsert = false;
    $scope.ShowBtnUpdate = false;
    $scope.ShowBtnDelete = false;
    $scope.ngClose = {};

    $scope.EditID = '0';

    $scope.ProposalID = "";
    $scope.ProposalName = "";
    $scope.ShowAll = false;
    $scope.ShowAllColumns = false;
    $scope.IsLoginUserAdmin = false;
    $scope.ProposalList = [];
    $scope.TransferList = [];
    $scope.ngMarkPromotion = {};

    $scope.ngFormData = {};
    $scope.ngFormData.proposalID = window.localStorage.getItem("SessionTransferProposalID") == 'undefined' || window.localStorage.getItem("SessionTransferProposalID") == '0' ? '' : window.localStorage.getItem("SessionTransferProposalID");
    $scope.ngFormData.proposalName = "";
    $scope.ngFormData.employeeName = "";
    $scope.ngFormData.designationID = "";
    $scope.ngFormData.transferCategory = "";
    $scope.ngFormData.fromOffice = "";
    $scope.ngFormData.fromDeptID = "";
    $scope.ngFormData.fromPlace = "";
    $scope.ngFormData.fromDistrictID = "";
    $scope.ngFormData.toOffice = "";
    $scope.ngFormData.toDeptID = "";
    $scope.ngFormData.toPlace = "";
    $scope.ngFormData.toDistrictID = "";
    $scope.ngFormData.isPromotion = false;

    debugger
    if ((window.localStorage.getItem("isLoginUserAdmin") != null
        && window.localStorage.getItem("isLoginUserAdmin") != 'undefined'
        && window.localStorage.getItem("isLoginUserAdmin") == '1')) {
        $scope.IsLoginUserAdmin = true;
    }

    CheckPageAuthentication();

    PageLoad();

    function CheckPageAuthentication() {
        CommService.CheckPageAuth('TransferList.html', CommService.GetUserId()).then(function (Rsp) {

            if (Rsp.data[0].PageDisplayStatus == "OK") {
                $scope.ShowPage = (Rsp.data[0].CanView == '0' || Rsp.data[0].CanView == 'false') ? false : true;
                $scope.ShowBtnInsert = (Rsp.data[0].CanInsert == '0' || Rsp.data[0].CanInsert == 'false') ? false : true;
                $scope.ShowBtnUpdate = (Rsp.data[0].CanUpdate == '0' || Rsp.data[0].CanUpdate == 'false') ? false : true;
                $scope.ShowBtnDelete = (Rsp.data[0].CanDelete == '0' || Rsp.data[0].CanDelete == 'false') ? false : true;
            }
            else {
                window.location.href = "401.html";
            }
        });
    }

    function PageLoad() {

        FillComboBoxes();
        
        $scope.TransferList = [];

        var paramTL =
               {
                   key: 'SELECT_TRANSFER_LIST',
                   transferProposalID: $scope.ngFormData.proposalID,
                   employeeName: $scope.ngFormData.employeeName,
                   designationID: $scope.ngFormData.designationID,
                   fromOffice: $scope.ngFormData.fromOffice,
                   fromDeptID: $scope.ngFormData.fromDeptID,
                   fromPlace: $scope.ngFormData.fromPlace,
                   fromDistrictID: $scope.ngFormData.fromDistrictID,
                   toOffice: $scope.ngFormData.toOffice,
                   toDeptID: $scope.ngFormData.toDeptID,
                   toPlace: $scope.ngFormData.toPlace,
                   toDistrictID: $scope.ngFormData.toDistrictID,
                   toPostID: $scope.ngFormData.toPostID,
                   transferComment: $scope.ngFormData.transferComment,
                   transferCategory: $scope.ngFormData.transferCategory,
                   transferRemark: $scope.ngFormData.transferRemark,
                   isPromotion: $scope.ngFormData.isPromotion == true ? 1 : 0,
                   action: $scope.ngFormData.proposalID,
                   createdBy: CommService.GetUserId()
               };
        ServiceTransferList.GetSet(paramTL).then(function (response) {
            debugger
            $scope.TransferList = response.data;
            if ($scope.TransferList.length > 0) {
                $scope.gvStatus = true;
            }
            else {
                $scope.gvStatus = false;
            }
        });
    }


    function FillComboBoxes() {

        var paramProp =
                {
                    key: 'SELECT_PROPOSALS',
                    createdBy: CommService.GetUserId()
                };
        $scope.ProposalList = [];
        ServiceTransferList.GetSet(paramProp).then(function (response) {
            if (response.data.length > 0) {
                $scope.ProposalList = response.data;
                debugger
                $scope.ngFormData.proposalID = window.localStorage.getItem("SessionTransferProposalID") == 'undefined' || window.localStorage.getItem("SessionTransferProposalID") == '0' ? '' : window.localStorage.getItem("SessionTransferProposalID");
            }
        });

        var paramCat =
                {
                    key: 'SELECT_TRANSFER_CATEGORY',
                    createdBy: CommService.GetUserId()
                };
        $scope.TransferCategoryList = [];
        ServiceTransferList.GetSet(paramCat).then(function (response) {
            if (response.data.length > 0) {
                $scope.TransferCategoryList = response.data;
            }
        });

        var paramDes =
                {
                    key: 'SELECT_DESIGNATIONS',
                    createdBy: CommService.GetUserId()
                };
        $scope.DesignationList = [];
        ServiceTransferList.GetSet(paramDes).then(function (response) {
            if (response.data.length > 0) {
                $scope.DesignationList = response.data;
            }
        });
        
        var paramDapt =
                {
                    key: 'SELECT_DEPARTMENTS',
                    createdBy: CommService.GetUserId()
                };
        $scope.FromDepartmentList = [];
        $scope.ToDepartmentList = [];
        ServiceTransferList.GetSet(paramDapt).then(function (response) {
            if (response.data.length > 0) {
                $scope.FromDepartmentList = response.data;
                $scope.ToDepartmentList = response.data;
            }
        });

        var paramDist =
                {
                    key: 'SELECT_DISTRICTS',
                    createdBy: CommService.GetUserId()
                };
        $scope.FromDistrictList = [];
        $scope.ToDistrictList = [];
        ServiceTransferList.GetSet(paramDist).then(function (response) {
            if (response.data.length > 0) {
                $scope.FromDistrictList = response.data;
                $scope.ToDistrictList = response.data;
            }
        });
    }

    $scope.GetSetData = function GetSetData(key, x_id) {
        if (key == 'SELECT_TRANSFER_LIST') {
            $scope.TransferList = [];
            //key, transferProposalID, empID, toPostID, transferComment, action, createdBy
            var paramTL =
               {
                   key: key,
                   transferProposalID: $scope.ngFormData.proposalID,
                   employeeName: $scope.ngFormData.employeeName,
                   designationID: $scope.ngFormData.designationID,
                   fromOffice: $scope.ngFormData.fromOffice,
                   fromDeptID: $scope.ngFormData.fromDeptID,
                   fromPlace: $scope.ngFormData.fromPlace,
                   fromDistrictID: $scope.ngFormData.fromDistrictID,
                   toOffice: $scope.ngFormData.toOffice,
                   toDeptID: $scope.ngFormData.toDeptID,
                   toPlace: $scope.ngFormData.toPlace,
                   toDistrictID: $scope.ngFormData.toDistrictID,
                   toPostID: $scope.ngFormData.toPostID,
                   transferComment: $scope.ngFormData.transferComment,
                   transferCategory: $scope.ngFormData.transferCategory,
                   transferRemark: $scope.ngFormData.transferRemark,
                   isPromotion: $scope.ngFormData.isPromotion == true ? 1 : 0,
                   action: x_id,
                   createdBy: CommService.GetUserId()
               };
            ServiceTransferList.GetSet(paramTL).then(function (response) {
                debugger
                $scope.TransferList = response.data;
                if ($scope.TransferList.length > 0) {
                    $scope.gvStatus = true;
                }
                else {
                    message_info("No data found for selected criteria")
                    $scope.gvStatus = false;
                }
            });
        }
        if (key == 'MARK_PROMOTION')
        {
            if(!IsCommaSeparatedNumbers(x_id))
            {
                message_warning("Invalid", "Please enter valid comma separated numeric IDs");
                return;
            }
            else if(confirm("Are you sure you want to mark transfers with promotion?"))
            {
                var paramPromo =
                   {
                       key: key,
                       transferProposalID: $scope.ngFormData.proposalID,
                       isPromotion: $scope.ngMarkPromotion.IsPromotion,
                       action: x_id,
                       createdBy: CommService.GetUserId()
                   };
                ServiceTransferList.GetSet(paramPromo).then(function (response) {
                    debugger
                    if (response.data[0].Msg == 'OK') {
                        message_success("Success", "Records updated successfully");
                        $("#myModalMarkPromotion").modal('toggle');
                        $scope.ngMarkPromotion = {};
                        $scope.gvStatus = true;
                        PageLoad();
                    }
                    else {
                        message_warning("Error", response.data[0].Msg);
                        $scope.gvStatus = false;
                    }
                });
            }
        }
    }

    function IsCommaSeparatedNumbers(str) {
        debugger
        if (str.indexOf(",,") !== -1
            || /^[0-9,.]*$/.test(str) == false)
            return false;
        else
            return true;
    }

    $scope.IsPromotionRadioChanged = function (x) {
        $scope.ngMarkPromotion.IsPromotion = x;
    }

    $scope.ProposalChanged = function ProposalChanged(id) {
        debugger
        window.localStorage.removeItem("SessionTransferProposalID");
        window.localStorage.setItem("SessionTransferProposalID", id);
        $scope.GetSetData('SELECT_TRANSFER_LIST', id);
    }

    $scope.EditTransfer = function EditTransfer(x) {

        if ($scope.ShowBtnUpdate == false)
        {
            message_warning("Unauthorized!", "You are not authorized to do this action.");
            return;
        }
        window.localStorage.removeItem("SessionTransferProposalID");
        window.localStorage.setItem("SessionTransferProposalID", x.TransferProposalID);
        window.location = "AddEditTransfer.html?Id=" + x.Id;
    }

    $scope.DeleteTransfer = function DeleteTransfer(x) {

        if ($scope.ShowBtnDelete == false) {
            message_warning("Unauthorized!", "You are not authorized to do this action.");
            return;
        }

        if (!confirm("Are you sure you want to delete this transfer?")) {
            return;
        }
        var paramDel =
                {
                    key: 'DELETE',
			transferProposalID: x.TransferProposalID,
           		empID: x.EmployeeID,
           		toPostID: x.ToPostID,
                    action: x.Id,
                    createdBy: CommService.GetUserId()
                };
        ServiceTransferList.GetSet(paramDel).then(function (response) {
            debugger
            if (response.data[0].Msg == 'OK') {
                message_success("Success", "Record Deleted Successfully.");
                $scope.gvStatus = true;
                PageLoad();
            }
            else {
                message_warning("Error", response.data[0].Msg);
                $scope.gvStatus = false;
            }
        });

    }
   

    $scope.OpenAddEditTranferPage = function (Id) {

        if ($scope.ShowBtnInsert == false) {
            message_warning("Unauthorized!", "You are not authorized to do this action.");
            return;
        }

        if ($scope.ngFormData.proposalID == 0 || $scope.ngFormData.proposalID == 'undefined' || $scope.ngFormData.proposalID == null) {
            message_warning("Please select proposal name");
            return;
        }
        else {
            window.location.href = "AddEditTransfer.html";
        }
    }

    $scope.OpenTransferWithPromotionModal = function () {
        if ($scope.ShowBtnInsert == false) {
            message_warning("Unauthorized!", "You are not authorized to do this action.");
            return;
        }
        if ($scope.ngFormData.proposalID == 0 || $scope.ngFormData.proposalID == 'undefined' || $scope.ngFormData.proposalID == null) {
            message_warning("Please select proposal name");
            return;
        }
        else {
            $scope.ngMarkPromotion = {};
            $scope.ngMarkPromotion.EmployeeIDs = "";
            $scope.ngMarkPromotion.IsPromotion = 1;
            $scope.ProposalName = $("#ProposalID option:selected").text();
            
            $("#myModalMarkPromotion").modal('toggle');
        }

    }

    $scope.ResetFilters = function ResetFilters() {
        $scope.ngFormData.employeeName = "";
        $scope.ngFormData.designationID = "";
        $scope.ngFormData.fromOffice = "";
        $scope.ngFormData.fromDeptID = "";
        $scope.ngFormData.fromPlace = "";
        $scope.ngFormData.fromDistrictID = "";
        $scope.ngFormData.toOffice = "";
        $scope.ngFormData.toDeptID = "";
        $scope.ngFormData.toPlace = "";
        $scope.ngFormData.toDistrictID = "";
        $scope.ngFormData.transferCategory = "";
        $scope.ngFormData.isPromotion = false;
    };

    //$scope.exportDataDownload = (function (tableId) { // ex: '#my-table'
    //    debugger
    //    var uri = 'data:application/vnd.ms-excel;base64,'
    //        , template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>'
    //        , base64 = function (s) { return window.btoa(unescape(encodeURIComponent(s))) }
    //        , format = function (s, c) { return s.replace(/{(\w+)}/g, function (m, p) { return c[p]; }) }
    //    return function (tableId) {
    //        if (!tableId.nodeType) tableId = document.getElementById(tableId)
    //        var ctx = { worksheet: 'download' || 'Worksheet', tableId: tableId.innerHTML }
    //        debugger
    //        document.getElementById('downloadExcelLink').href = uri + base64(format(template, ctx));
    //        document.getElementById('downloadExcelLink').download = 'download';
    //        document.getElementById('downloadExcelLink').click();
    //    }
    //})();

});
eApp.service("ServiceTransferList", function ($http, $rootScope) {
    var saveSts = '';
    var RspData = [];
    this.GetSet = function (formData) {
        saveSts = $http({
            data: formData,
            method: 'post',
            url: 'Handler/TransferList.ashx',
            datatype: "json"
        }).success(function (rsp) {
            if (rsp == "TokenExpire") {
                message_error("Token Expired", "Oops! You are not authorized to process any request. Login again.", function () { $rootScope.signOut(); });
            }
            else {
                RspData = rsp;
                return RspData;
            }
        }).error(function (rsp) {
            alert('Error');
        });
        return saveSts;
    };
//eApp.service("ServiceTransferList", function ($http, $rootScope) {
//    var saveSts = '';
//    var RspData = [];
//    this.GetSet = function (key, transferProposalID, empID, toPostID, transferComment, isPromotion, action, createdBy) {
//        var formData = new FormData();
//        formData.key = key;
//        formData.transferProposalID = transferProposalID;
//        formData.empID = empID;
//        formData.toPostID = toPostID;
//        formData.transferComment = transferComment;
//        formData.isPromotion = isPromotion;
//        formData.action = action;
//        formData.createdBy = createdBy;

//        saveSts = $http({
//            data: formData,
//            method: 'post',
//            url: 'Handler/TransferList.ashx',
//            datatype: "json"
//        }).success(function (rsp) {
//            if (rsp == "TokenExpire") {
//                message_error("Token Expired", "Oops! You are not authorized to process any request. Login again.", function () { $rootScope.signOut(); });
//            }
//            else {
//                RspData = rsp;
//                return RspData;
//            }
//        }).error(function (rsp) {
//            alert('Error');
//        });
//        return saveSts;
//    };
});
