﻿eApp.controller('TransferApplicationList-Ctrl', function ($translate, $rootScope, $scope, $timeout, $filter, cfpLoadingBar, CommService, ServiceTransferApplicationList, eAppVal, ngDialog, $controller) {
    cfpLoadingBar.start();
    $scope.fakeIntro = true;
    $timeout(function () {
        cfpLoadingBar.complete();
        $scope.fakeIntro = false;
        document.getElementById("wrapper").style.display = "Block";
    }, 750);
    
    $scope.currentPage = 1;
    $scope.ddlPageSize = eAppVal.GridPageSize;
    $scope.gvStatus = false;

    $scope.EditID = '0';

    $scope.ShowPage = false;
    $scope.ShowBtnInsert = false;
    $scope.ShowBtnUpdate = false;
    $scope.ShowBtnDelete = false;

    $scope.ShowAll = false;
    $scope.ShowAllColumns = false;
    $scope.IsLoginUserAdmin = false;
    $scope.isShowEmpWiseLatestRecords = true;
    
    $scope.TransferApplicationList = [];

    $scope.ngClose = {};
    $scope.ngFormData = {};
    var yearBeginDate = new Date(new Date().getUTCFullYear(), 0, 2);
    $scope.ngFormData.applicationDate = yearBeginDate.toJSON().slice(0, 10).split('-').reverse().join('-');
    $scope.ngFormData.employeeName = "";
    $scope.ngFormData.designationID = "";
    $scope.ngFormData.genderID = "";
    $scope.ngFormData.fromOffice = "";
    $scope.ngFormData.fromDeptID = "";
    $scope.ngFormData.fromPlace = "";
    $scope.ngFormData.fromDistrictID = "";
    $scope.ngFormData.toOffice = "";
    $scope.ngFormData.toDeptID = "";
    $scope.ngFormData.toPlace = "";
    $scope.ngFormData.toDistrictID = "";
    $scope.ngFormData.isCMO = false;
    $scope.ngFormData.isPSITDesire = false;
    $scope.ngFormData.isCSITDesire = false;
    $scope.ngFormData.isRepDesire = false;
    $scope.ngFormData.isOfficerDesire = false;
    $scope.ngFormData.isSpouseGovtJob = false;
    $scope.ngFormData.isPH = false;
    $scope.ngFormData.isMutual = false;
    $scope.ngFormData.isCompliance = false;
    $scope.ngFormData.isSelfApplication = false;
    $scope.ngFormData.isTDJSDesire = false;
    $scope.ngFormData.isChronic = false;
    $scope.ngFormData.isComplaint = false;
    $scope.ngFormData.isInActiveOnly = false;
    $scope.ngFormData.otherRemark = "";

    
    if ((window.localStorage.getItem("isLoginUserAdmin") != null
        && window.localStorage.getItem("isLoginUserAdmin") != 'undefined'
        && window.localStorage.getItem("isLoginUserAdmin") == '1')) {
        $scope.IsLoginUserAdmin = true;
    }

    CheckPageAuthentication();

    PageLoad();

    function CheckPageAuthentication() {
        //For Add/Edit pages, provide the parent page name
        CommService.CheckPageAuth('TransferApplicationList.html', CommService.GetUserId()).then(function (Rsp) {
            if (Rsp.data[0].PageDisplayStatus == "OK") {
                $scope.ShowPage = (Rsp.data[0].CanView == '0' || Rsp.data[0].CanView == 'false') ? false : true;
                $scope.ShowBtnInsert = (Rsp.data[0].CanInsert == '0' || Rsp.data[0].CanInsert == 'false') ? false : true;
                $scope.ShowBtnUpdate = (Rsp.data[0].CanUpdate == '0' || Rsp.data[0].CanUpdate == 'false') ? false : true;
                $scope.ShowBtnDelete = (Rsp.data[0].CanDelete == '0' || Rsp.data[0].CanDelete == 'false') ? false : true;
            }
            else {
                window.location.href = "401.html";
            }
        });
    }

    function PageLoad() {

        FillComboBoxes();       

        $scope.TransferApplicationList = [];
        
        var paramApp =
                {                    
                    key: $scope.isShowEmpWiseLatestRecords == true ? 'SELECT_APPLICATIONS_LATEST' : 'SELECT_APPLICATIONS_ALL',
                    applicationDate: $scope.ngFormData.applicationDate,
                    employeeName: $scope.ngFormData.employeeName,
                    designationID: $scope.ngFormData.designationID,
                    genderID: $scope.ngFormData.genderID,
                    fromOffice: $scope.ngFormData.fromOffice,
                    fromDeptID: $scope.ngFormData.fromDeptID,
                    fromPlace: $scope.ngFormData.fromPlace,
                    fromDistrictID: $scope.ngFormData.fromDistrictID,
                    toOffice: $scope.ngFormData.toOffice,
                    toDeptID: $scope.ngFormData.toDeptID,
                    toPlace: $scope.ngFormData.toPlace,
                    toDistrictID: $scope.ngFormData.toDistrictID,
                    isCMO: $scope.ngFormData.isCMO == true ? 1 : 0,
                    isPSITDesire: $scope.ngFormData.isPSITDesire == true ? 1 : 0,
                    isCSITDesire: $scope.ngFormData.isCSITDesire == true ? 1 : 0,
                    isRepDesire: $scope.ngFormData.isRepDesire == true ? 1 : 0,
                    isOfficerDesire: $scope.ngFormData.isOfficerDesire == true ? 1 : 0,
                    isSpouseGovtJob: $scope.ngFormData.isSpouseGovtJob == true ? 1 : 0,
                    isPH: $scope.ngFormData.isPH == true ? 1 : 0,
                    isMutual: $scope.ngFormData.isMutual == true ? 1 : 0,
                    isCompliance: $scope.ngFormData.isCompliance == true ? 1 : 0,
                    isSelfApplication: $scope.ngFormData.isSelfApplication == true ? 1 : 0,
                    isTDJSDesire: $scope.ngFormData.isTDJSDesire == true ? 1 : 0,
                    isChronic: $scope.ngFormData.isChronic == true ? 1 : 0,
                    isComplaint: $scope.ngFormData.isComplaint == true ? 1 : 0,
                    action: '',
                    createdBy: CommService.GetUserId()
                };
        
        $scope.TransferApplicationList = [];
        ServiceTransferApplicationList.GetSet(paramApp).then(function (response) {
            if (response.data.length > 0) {
                $scope.TransferApplicationList = response.data;                

                $scope.gvStatus = true;
            }
            else
            {                
                $scope.gvStatus = false;
            }
        });

    }

    function FillComboBoxes() {

        var paramDes =
                {
                    key: 'SELECT_DESIGNATIONS',
                    createdBy: CommService.GetUserId()
                };
        $scope.DesignationList = [];
        ServiceTransferApplicationList.GetSet(paramDes).then(function (response) {
            if (response.data.length > 0) {
                $scope.DesignationList = response.data;
            }
        });


        var paramDapt =
                {
                    key: 'SELECT_DEPARTMENTS',
                    createdBy: CommService.GetUserId()
                };
        $scope.FromDepartmentList = [];
        $scope.ToDepartmentList = [];
        ServiceTransferApplicationList.GetSet(paramDapt).then(function (response) {
            if (response.data.length > 0) {
                $scope.FromDepartmentList = response.data;
                $scope.ToDepartmentList = response.data;
            }
        });

        var paramDist =
                {
                    key: 'SELECT_DISTRICTS',
                    createdBy: CommService.GetUserId()
                };
        $scope.FromDistrictList = [];
        $scope.ToDistrictList = [];
        ServiceTransferApplicationList.GetSet(paramDist).then(function (response) {
            if (response.data.length > 0) {
                $scope.FromDistrictList = response.data;
                $scope.ToDistrictList = response.data;
            }
        });

        var paramGen =
                {
                    key: 'SELECT_GENDER',
                    createdBy: CommService.GetUserId()
                };
        $scope.GenderList = [];
        ServiceTransferApplicationList.GetSet(paramGen).then(function (response) {
            if (response.data.length > 0) {
                $scope.GenderList = response.data;
            }
        });
    }

    $scope.GetSetData = function GetSetData(formData) {
        
        $scope.ngFormData = formData;
        var paramApp =
                {
                    key: $scope.isShowEmpWiseLatestRecords == true ? 'SELECT_APPLICATIONS_LATEST' : 'SELECT_APPLICATIONS_ALL',
                    applicationDate: $('#txtApplicationDate').val(), //$scope.ngFormData.applicationDate,
                    employeeName: $scope.ngFormData.employeeName,
                    designationID: $scope.ngFormData.designationID,
                    genderID: $scope.ngFormData.genderID,
                    fromOffice: $scope.ngFormData.fromOffice,
                    fromDeptID: $scope.ngFormData.fromDeptID,
                    fromPlace: $scope.ngFormData.fromPlace,
                    fromDistrictID: $scope.ngFormData.fromDistrictID,
                    toOffice: $scope.ngFormData.toOffice,
                    toDeptID: $scope.ngFormData.toDeptID,
                    toPlace: $scope.ngFormData.toPlace,
                    toDistrictID: $scope.ngFormData.toDistrictID,
                    isCMO: $scope.ngFormData.isCMO == true ? 1 : 0,
                    isPSITDesire: $scope.ngFormData.isPSITDesire == true ? 1 : 0,
                    isCSITDesire: $scope.ngFormData.isCSITDesire == true ? 1 : 0,
                    isRepDesire: $scope.ngFormData.isRepDesire == true ? 1 : 0,
                    isOfficerDesire: $scope.ngFormData.isOfficerDesire == true ? 1 : 0,
                    isSpouseGovtJob: $scope.ngFormData.isSpouseGovtJob == true ? 1 : 0,
                    isPH: $scope.ngFormData.isPH == true ? 1 : 0,
                    isMutual: $scope.ngFormData.isMutual == true ? 1 : 0,
                    isCompliance: $scope.ngFormData.isCompliance == true ? 1 : 0,
                    isSelfApplication: $scope.ngFormData.isSelfApplication == true ? 1 : 0,
                    isTDJSDesire: $scope.ngFormData.isTDJSDesire == true ? 1 : 0,
                    isChronic: $scope.ngFormData.isChronic == true ? 1 : 0,
                    isComplaint: $scope.ngFormData.isComplaint == true ? 1 : 0,
                    isInActiveOnly: $scope.ngFormData.isInActiveOnly == true ? 1 : 0,
                    action: '',
                    createdBy: CommService.GetUserId()
                };
        
        $scope.TransferApplicationList = [];
        ServiceTransferApplicationList.GetSet(paramApp).then(function (response) {
            if (response.data.length > 0) {
                $scope.TransferApplicationList = response.data;
                $scope.gvStatus = true;
            }
            else {
                message_info("No data found for selected criteria!")
                $scope.gvStatus = false;
            }
        });
    }

    function IsCommaSeparatedNumbers(str) {
        
        if (str.indexOf(",,") !== -1
            || /^[0-9,.]*$/.test(str) == false)
            return false;
        else
            return true;
    }

    $scope.OpenAddEditApplicationPage = function () {
        if ($scope.ShowBtnInsert == false) {
            message_warning("Unauthorized!", "You are not authorized to do this action.");
            return;
        }
        window.location.href = "AddEditTransferApplication.html";
    }


    $scope.EditTransferApplication = function EditTransferApplication(x) {
        if ($scope.ShowBtnUpdate == false) {
            message_warning("Unauthorized!", "You are not authorized to do this action.");
            return;
        }        
        window.location.href = "AddEditTransferApplication.html?Id=" + x.ID;
    }

    $scope.ViewDeleteModal = function (x) {
        if ($scope.ShowBtnDelete == false) {
            message_warning("Unauthorized!", "You are not authorized to do this action.");
            return;
        }
        $scope.ngClose = x;
        $scope.ngClose.otherRemark = "";
        $("#myModalApplicationDelete").modal('toggle');
    };

    $scope.DeleteTransferApplication = function DeleteTransferApplication(x) {
        debugger
        if (x.IsMutual == '1')
        {
            if (!confirm("Mutual application of " + x.MutualEmployeeName + " Dated: " + x.ApplicationDate + " on Page No. " + x.PageNumber + " will also be deleted. \n\nAre you sure to continue?"))
                return;
        }
        else if (!confirm("Are you sure you want to delete this record?")) {
            return;
        }
        var paramDel =
                {
                    key: 'DELETE',
                    createdBy: CommService.GetUserId(),
                    otherRemark: x.otherRemark,
                    action: x.ID
                };
        ServiceTransferApplicationList.GetSet(paramDel).then(function (response) {
            if (response.data[0].Msg == 'OK') {
                message_success("Success", "Record Deleted Successfully.");
                $("#myModalApplicationDelete").modal('toggle');
                $scope.gvStatus = true;
                PageLoad();
            }
            else {
                message_warning("Error", response.data[0].Msg);
                $scope.gvStatus = false;
            }
        });

    }

    $scope.IsShowAllRadioChanged = function (formData, x) {
        
        $scope.isShowEmpWiseLatestRecords = x == '1' ? true : false;
        $scope.GetSetData(formData);
    }

    $scope.ResetFilters = function ResetFilters() {
        var yearBeginDate1 = new Date(new Date().getUTCFullYear(), 0, 2);
        $('#txtApplicationDate').val(yearBeginDate1.toJSON().slice(0, 10).split('-').reverse().join('-'));
        $scope.ngFormData.employeeName = "";
        $scope.ngFormData.designationID = "";
        $scope.ngFormData.genderID = "";
        $scope.ngFormData.fromOffice = "";
        $scope.ngFormData.fromDeptID = "";
        $scope.ngFormData.fromPlace = "";
        $scope.ngFormData.fromDistrictID = "";
        $scope.ngFormData.toOffice = "";
        $scope.ngFormData.toDeptID = "";
        $scope.ngFormData.toPlace = "";
        $scope.ngFormData.toDistrictID = "";
        $scope.ngFormData.isCMO = false;
        $scope.ngFormData.isPSITDesire = false;
        $scope.ngFormData.isCSITDesire = false;
        $scope.ngFormData.isRepDesire = false;
        $scope.ngFormData.isOfficerDesire = false;
        $scope.ngFormData.isSpouseGovtJob = false;
        $scope.ngFormData.isPH = false;
        $scope.ngFormData.isMutual = false;
        $scope.ngFormData.isCompliance = false;
        $scope.ngFormData.isSelfApplication = false;
        $scope.ngFormData.isTDJSDesire = false;
        $scope.ngFormData.isChronic = false;
        $scope.ngFormData.isComplaint = false;
    };

});
eApp.filter('unsafe', function ($sce) {
    return function (val) {
        return $sce.trustAsHtml(val);
    };
});
eApp.service("ServiceTransferApplicationList", function ($http, $rootScope) {
    var saveSts = '';
    var RspData = [];
    this.GetSet = function (formData) {
        saveSts = $http({
            data: formData,
            method: 'post',
            url: 'Handler/TransferApplicationList.ashx',
            datatype: "json"
        }).success(function (rsp) {
            if (rsp == "TokenExpire") {
                message_error("Token Expired", "Oops! You are not authorized to process any request. Login again.", function () { $rootScope.signOut(); });
            }
            else {
                RspData = rsp;
                return RspData;
            }
        }).error(function (rsp) {
            alert('Error');
        });
        return saveSts;
    };
});
