﻿eApp.controller('Representatives-Ctrl', function ($translate, $rootScope, $scope, $timeout, $filter, cfpLoadingBar, CommService, ServiceRepresentatives, eAppVal, ngDialog, $controller) {
    cfpLoadingBar.start();
    $scope.fakeIntro = true;
    $timeout(function () {
        cfpLoadingBar.complete();
        $scope.fakeIntro = false;
        document.getElementById("wrapper").style.display = "Block";
    }, 750);
    var rec_user_id = "1"
    $scope.currentPage = 1;
    $scope.ddlPageSize = eAppVal.GridPageSize;
    $scope.gvStatus = false;
    $scope.ngClose = {};

    $scope.EditID = '0';

    $scope.btnProcess = true;
    $scope.btnShow = true;
    $scope.txtRepName = '';
    $scope.txtDesignation = '';
    $scope.txtConstituency = '';
    $scope.txtDepartment = '';
    $scope.txtDistrict = '';
    $scope.txtParty = '';
    $scope.txtRemark = '';
    $scope.isMinister = 0;
    $scope.ShowAll = false;
    $scope.IsLoginUserAdmin = false;

    $scope.SaluteList = [];
    $scope.RepresentativeList = [];

    $scope.ShowPage = false;
    $scope.ShowBtnInsert = false;
    $scope.ShowBtnUpdate = false;
    $scope.ShowBtnDelete = false;

    debugger
    if ((window.localStorage.getItem("isLoginUserAdmin") != null
        && window.localStorage.getItem("isLoginUserAdmin") != 'undefined'
        && window.localStorage.getItem("isLoginUserAdmin") == '1')) {
        $scope.IsLoginUserAdmin = true;
    }

    CheckPageAuthentication();

    PageLoad();

    function CheckPageAuthentication() {
        //For Add/Edit pages, provide the parent page name
        CommService.CheckPageAuth('Representatives.html', CommService.GetUserId()).then(function (Rsp) {
            if (Rsp.data[0].PageDisplayStatus == "OK") {
                $scope.ShowPage = (Rsp.data[0].CanView == '0' || Rsp.data[0].CanView == 'false') ? false : true;
                $scope.ShowBtnInsert = (Rsp.data[0].CanInsert == '0' || Rsp.data[0].CanInsert == 'false') ? false : true;
                $scope.ShowBtnUpdate = (Rsp.data[0].CanUpdate == '0' || Rsp.data[0].CanUpdate == 'false') ? false : true;
                $scope.ShowBtnDelete = (Rsp.data[0].CanDelete == '0' || Rsp.data[0].CanDelete == 'false') ? false : true;
            }
            else {
                window.location.href = "401.html";
            }
        });
    }

    function PageLoad() {
        debugger

        FillSaluteList();

        $scope.RepresentativeList = [];
        ServiceRepresentatives.GetSet($scope.ShowAll == true ? 'SELECT_ALL' : 'SELECT', $scope.SaluteID, $scope.txtRepName, $scope.txtDesignation, $scope.txtConstituency, $scope.txtDepartment,
                                      $scope.txtDistrict, $scope.txtParty, $scope.txtRemark, $scope.isMinister, $scope.EditID, CommService.GetUserId()).then(function (response) {
                                          debugger
                                          $scope.RepresentativeList = response.data;
                                          if ($scope.RepresentativeList.length > 0) {
                                              $scope.gvStatus = true;
                                              $scope.btnProcess = true;
                                              $scope.btnShow = true;
                                              $scope.EditID = '0';
                                              $scope.SaluteID = '';
                                              $scope.txtRepName = '';
                                              $scope.txtDesignation = '';
                                              $scope.txtConstituency = '';
                                              $scope.txtDepartment = '';
                                              $scope.txtDistrict = '';
                                              $scope.txtParty = '';
                                              $scope.txtRemark = '';
                                              $scope.isMinister = false;
                                          }
                                          else {
                                              $scope.gvStatus = false;
                                          }
                                      });
    }

    function FillSaluteList() {
        $scope.SaluteList = [];
        ServiceRepresentatives.GetSet('SELECT_SALUTE', "", "", "", "", "", "", "", "", "", "", CommService.GetUserId()).then(function (response) {
            if (response.data.length > 0) {
                $scope.SaluteList = response.data;
            }
        });
    }

    $scope.Save_Click = function () {
        debugger
        $scope.GetSetData($scope.EditID == '0' ? 'INSERT' : 'UPDATE', $scope.EditID);
    };

    $scope.GetSetData = function GetSetData(key, x_id) {
        if (key == 'SELECT') {

            $scope.RepresentativeList = [];
            ServiceRepresentatives.GetSet(key, $scope.SaluteID, $scope.txtRepName, $scope.txtDesignation, $scope.txtConstituency, $scope.txtDepartment,
                                      $scope.txtDistrict, $scope.txtParty, $scope.txtRemark, $scope.isMinister, $scope.EditID, CommService.GetUserId()).then(function (response) {
                                          debugger
                                          $scope.RepresentativeList = response.data;
                                          if ($scope.RepresentativeList.length > 0) {
                                              $scope.gvStatus = true;
                                          }
                                          else {
                                              $scope.gvStatus = false;
                                          }
                                      });
        }
        else if (key == 'INSERT') {
            if ($scope.ShowBtnInsert == false) {
                message_warning("Unauthorized!", "You are not authorized to do this action.");
                return;
            }
            if (confirm("Are you sure you want to save this record?")) {
                $scope.btnProcess = false;
                ServiceRepresentatives.GetSet(key, $scope.SaluteID, $scope.txtRepName, $scope.txtDesignation, $scope.txtConstituency, $scope.txtDepartment,
                                          $scope.txtDistrict, $scope.txtParty, $scope.txtRemark, $scope.isMinister, x_id, CommService.GetUserId()).then(function (response) {
                                              if (response.data[0].Msg == 'OK') {
                                                  message_success("Success", "Record Saved Successfully.");
                                                  $scope.btnProcess = true;
                                                  PageLoad();
                                              } else {
                                                  message_warning("Error", response.data[0].Msg);
                                                  $scope.btnProcess = true;
                                              }
                                          })
            }
        }
        else if (key == 'UPDATE') {
            if ($scope.ShowBtnUpdate == false) {
                message_warning("Unauthorized!", "You are not authorized to do this action.");
                return;
            }
            if (confirm("Are you sure you want to update this record?")) {
                $scope.btnProcess = false;
                ServiceRepresentatives.GetSet(key, $scope.SaluteID, $scope.txtRepName, $scope.txtDesignation, $scope.txtConstituency, $scope.txtDepartment,
                                          $scope.txtDistrict, $scope.txtParty, $scope.txtRemark, $scope.isMinister, x_id, CommService.GetUserId()).then(function (response) {
                                              if (response.data[0].Msg == 'OK') {
                                                  message_success("Success", "Record Updated Successfully.");
                                                  $scope.btnProcess = true;
                                                  PageLoad();
                                              } else {
                                                  message_warning("Error", response.data[0].Msg);
                                                  $scope.btnProcess = true;
                                              }
                                          })
            }
        }
        else if (key == 'DELETE') {
            if ($scope.ShowBtnDelete == false) {
                message_warning("Unauthorized!", "You are not authorized to do this action.");
                return;
            }
            if (confirm("Are you sure you want to delete this record?")) {
                ServiceRepresentatives.GetSet(key, $scope.SaluteID, $scope.txtRepName, $scope.txtDesignation, $scope.txtConstituency, $scope.txtDepartment,
                                          $scope.txtDistrict, $scope.txtParty, $scope.txtRemark, $scope.isMinister, x_id, CommService.GetUserId()).then(function (response) {
                                              if (response.data[0].Msg == 'OK') {
                                                  message_success("Success", "Record Deleted Successfully.");
                                                  $scope.btnProcess = true;
                                                  PageLoad();
                                              } else {
                                                  message_warning("Error", response.data[0].Msg);
                                                  $scope.btnProcess = true;
                                              }
                                          });
            }
        }
    }

    $scope.CheckedChangedShowAll = function CheckedChangedShowAll() {
        $scope.RepresentativeList = [];
        ServiceRepresentatives.GetSet($scope.ShowAll == true ? 'SELECT_ALL' : 'SELECT', $scope.SaluteID, $scope.txtRepName, $scope.txtDesignation, $scope.txtConstituency, $scope.txtDepartment,
                                      $scope.txtDistrict, $scope.txtParty, $scope.txtRemark, $scope.isMinister, $scope.EditID, CommService.GetUserId()).then(function (response) {
            debugger
            $scope.RepresentativeList = response.data;
            if ($scope.RepresentativeList.length > 0) {
                $scope.gvStatus = true;
            }
            else {
                $scope.gvStatus = false;
            }
        });
    }

    $scope.FillValuesForEdit = function FillValuesForEdit(x) {
        $scope.EditID = x.Id;
        $scope.SaluteID = x.SaluteID;
        $scope.txtRepName = x.RepresentativeName;
        $scope.txtDesignation = x.Designation;
        $scope.txtConstituency = x.Constituency;
        $scope.txtDepartment = x.Department;
        $scope.txtDistrict = x.District;
        $scope.txtParty = x.Party;
        $scope.txtRemark = x.Remark;
        $scope.isMinister = x.IsMinister == 1 ? true : false;
    }

    $scope.Reset = function Reset() {
        $scope.EditID = '0';
        $scope.SaluteID = '';
        $scope.txtRepName = '';
        $scope.txtDesignation = '';
        $scope.txtConstituency = '';
        $scope.txtDepartment = '';
        $scope.txtDistrict = '';
        $scope.txtParty = '';
        $scope.txtRemark = '';
        $scope.isMinister = false;
    }
});
eApp.service("ServiceRepresentatives", function ($http, $rootScope) {
    var saveSts = '';
    var RspData = [];
    this.GetSet = function (key, saluteID, name, designation, constituency, department, district, party, remark, isMinister, action, createdBy) {
        var formData = new FormData();
        formData.key = key;
        formData.saluteID = saluteID;
        formData.name = name;
        formData.designation = designation;
        formData.constituency = constituency;
        formData.department = department;
        formData.district = district;
        formData.party = party;
        formData.remark = remark;
        formData.isMinister = isMinister;
        formData.action = action;
        formData.createdBy = createdBy;

        saveSts = $http({
            data: formData,
            method: 'post',
            url: 'Handler/Representatives.ashx',
            datatype: "json"
        }).success(function (rsp) {
            if (rsp == "TokenExpire") {
                message_error("Token Expired", "Oops! You are not authorized to process any request. Login again.", function () { $rootScope.signOut(); });
            }
            else {
                RspData = rsp;
                return RspData;
            }
        }).error(function (rsp) {
            alert('Error');
        });
        return saveSts;
    };
});
