﻿eApp.controller('ProjectMaster-Ctrl', function ($translate, $rootScope, $scope, $timeout, $filter, cfpLoadingBar, CommService, ServiceProjectMaster, eAppVal, ngDialog, $controller) {
    cfpLoadingBar.start();
    $scope.fakeIntro = true;
    $timeout(function () {
        cfpLoadingBar.complete();
        $scope.fakeIntro = false;
        document.getElementById("wrapper").style.display = "Block";
    }, 750);

    $scope.currentPage = 1;
    $scope.ddlPageSize = eAppVal.GridPageSize;
    $scope.gvStatus = false;
    var yearBeginDate = new Date(new Date().getUTCFullYear(), 0, 2);
   

    $scope.btnProcess = true;
    $scope.ShowAll = false;
    $scope.ShowAllColumns = false;
    $scope.IsLoginUserAdmin = false;
    $scope.ngFormData = {};
    
    $scope.ngFormData.txtProjectMaster = "";
    $scope.ngFormData.txtProjectDesc = "";
    $scope.ngFormData.txtProjectStartDt = "";
    $scope.ngFormData.txtProjectEndDt = "";
    $scope.ngFormData.txtProjectGroup = "";
            
    if ((window.localStorage.getItem("isLoginUserAdmin") != null
        && window.localStorage.getItem("isLoginUserAdmin") != 'undefined'
        && window.localStorage.getItem("isLoginUserAdmin") == '1')) {
        $scope.IsLoginUserAdmin = true;
    }

   
    
    PageLoad();

    function PageLoad() {
        var paramApp =
        {
            key: 'SELECT',
                       
            action: '',
            createdBy: CommService.GetUserId()
        };


        $scope.ProjectMasterList = [];
        ServiceProjectMaster.GetSet(paramApp).then(function (response) {
            if (response.data.length > 0) {
                $scope.ProjectMasterList = response.data;

                $scope.gvStatus = true;
            }
            else {
                $scope.gvStatus = false;
            }
        });

    


        CheckPageEditMode();
    }


    function CheckPageEditMode() {
        var url = new URL(window.location.href);
        debugger
        $scope.EditID = url.searchParams.get("Id") != null ? url.searchParams.get("Id") : 0;
        if ($scope.EditID != 0 && $scope.EditID != 'undefined' && $scope.EditID != null) {
            GetDataInEditMode($scope.EditID);
        }
    }
    
    function GetDataInEditMode(id) {
        var paramEdit =
        {
            key: 'SELECT_FOR_EDIT',
            action: id,
            createdBy: CommService.GetUserId()
        };
        ServiceProjectMaster.GetSet(paramEdit).then(function (response) {
            if (response.data.length > 0) {
               
                $scope.ngFormData.txtProjectMaster = response.data[0].ProjectName.replace(/\r\n|\r|\n/g, "</br>");
                $scope.ngFormData.txtProjectDesc = response.data[0].Description;
                $scope.ngFormData.txtProjectStartDt = response.data[0].StartDate;
                $scope.ngFormData.txtProjectEndDt = response.data[0].EndDate;
                $scope.ngFormData.txtProjectGroup = response.data[0].ProjectGroup;

                              
                  }
            else {
                message_warning("Error", "Unable to get data in edit mode");
            }
        });

    }


    $scope.Save_Click = function () {

        //   $scope.GetSetData($scope.EditID == 0 || $scope.EditID == 'undefined' || $scope.EditID == null ? 'INSERT' : 'UPDATE', $scope.EditID);
        debugger

        $scope.Nkey = ($scope.EditID == 0 || $scope.EditID == 'undefined' || $scope.EditID == null ? 'INSERT' : 'UPDATE')

        if (!confirm("Are you sure to save this record?")) {
            return;
        }
        var paramInsert =
        {
            key: $scope.Nkey,
            EditID: $scope.EditID,
           
            ProjectName: $scope.ngFormData.txtProjectMaster.replace(/\r\n|\r|\n/g, "</br>"),
            ProjectDesc: $scope.ngFormData.txtProjectDesc,
            ProjectStartDt: document.getElementById("txtProjectStartDt").value,
            ProjectEndDt: document.getElementById("txtProjectEndDt").value,
            ProjectGroup: $scope.ngFormData.txtProjectGroup,
            

            action: '',
            createdBy: CommService.GetUserId()
        };
        ServiceProjectMaster.GetSet(paramInsert).then(function (response) {

            if (response.data[0].Msg == 'OK') {

                message_success("Success", "Record Saved Successfully.");
                $scope.btnProcess = true;
                window.location.href = "ProjectMaster.html";
            } else {
                message_warning("Error", response.data[0].Msg);
                $scope.btnProcess = true;
            }
        });

    }
  

    $scope.EditProjectMaster = function EditProjectMaster(x) {
        
        window.location.href = "ProjectMaster.html?Id=" + x.ProjectID;
    }

    $scope.DeleteProjectMaster = function DeleteProjectMaster(x) {
      
        if (!confirm("Are you sure you want to delete this record?")) {
            return;
        }
        var paramDel =
        {
            key: 'DELETE',
            action: x.ProjectID,
            createdBy: CommService.GetUserId()

        };
         ServiceProjectMaster.GetSet(paramDel).then(function (response) {
            if (response.data[0].Msg == 'OK') {
                message_success("Success", "Record Deleted Successfully.");
                $scope.gvStatus = true;
                PageLoad();
            }
            else {
                message_warning("Error", response.data[0].Msg);
                $scope.gvStatus = false;
                PageLoad();
            }
        });

    }

    function IsCommaSeparatedNumbers(str) {

        if (str.indexOf(",,") !== -1
            || /^[0-9,.]*$/.test(str) == false)
            return false;
        else
            return true;
    }

    
       

   
    $scope.ResetFilters = function ResetFilters() {
        $scope.ngFormData.txtProjectMaster = "";
       
            };

});
eApp.filter('unsafe', function ($sce) {
    return function (val) {
        return $sce.trustAsHtml(val);
    };
});
eApp.service("ServiceProjectMaster", function ($http, $rootScope) {
    var saveSts = '';
    var RspData = [];
    this.GetSet = function (formData) {
        saveSts = $http({
            data: formData,
            method: 'post',
            url: 'Handler/ProjectMaster.ashx',
            datatype: "json"
        }).success(function (rsp) {
            if (rsp == "TokenExpire") {
                message_error("Token Expired", "Oops! You are not authorized to process any request. Login again.", function () { $rootScope.signOut(); });
            }
            else {
                RspData = rsp;
                return RspData;
            }
        }).error(function (rsp) {
            alert('Error');
        });
        return saveSts;
    };
});
