﻿eApp.controller('ProjectInOutList-Ctrl', function ($translate, $rootScope, $scope, $timeout, $filter, cfpLoadingBar, CommService, ServiceProjectInOutList, eAppVal, ngDialog, $controller) {
    cfpLoadingBar.start();
    $scope.fakeIntro = true;
    $timeout(function () {
        cfpLoadingBar.complete();
        $scope.fakeIntro = false;
        document.getElementById("wrapper").style.display = "Block";
    }, 750);

    $scope.currentPage = 1;
    $scope.ddlPageSize = eAppVal.GridPageSize;
    $scope.gvStatus = false;

    $scope.EditID = '0';
    $scope.InOutType = 0;
    $scope.btnProcess = true;
    $scope.ShowAll = false;
    $scope.ShowAllColumns = false;
    $scope.IsLoginUserAdmin = false;
    $scope.isShowEmpWiseLatestRecords = true;
    $scope.ProjectInOutList = [];
    
    $scope.ngFormData = {};
    
    

    
    PageLoad();

    function PageLoad() {

        FillComboBoxes();

        var paramApp =
        {
            key: 'SELECT',
            ProjectID: $scope.ngFormData.ProjectName,
            ProjectHeadID: $scope.ngFormData.ProjectHead,
            InOutType: $scope.ngFormData.InOut,
            
            action: '',
            createdBy: CommService.GetUserId()
        };

        $scope.ProjectInOutList = [];
        ServiceProjectInOutList.GetSet(paramApp).then(function (response) {
            if (response.data.length > 0) {
                $scope.ProjectInOutList = response.data;

                $scope.gvStatus = true;
            }
            else {
                $scope.gvStatus = false;
            }
        });

    }

    function FillComboBoxes() {

        var paramDes =
        {
            key: 'SELECT_ProjectName',
            createdBy: CommService.GetUserId()
        };
        $scope.ProjectNameList = [];
        ServiceProjectInOutList.GetSet(paramDes).then(function (response) {
            if (response.data.length > 0) {
                $scope.ProjectNameList = response.data;
            }
        });


        var paramDapt =
        {
            key: 'SELECT_ProjectHead',
            createdBy: CommService.GetUserId()
        };
        $scope.ProjectHeadList = [];
        
        ServiceProjectInOutList.GetSet(paramDapt).then(function (response) {
            if (response.data.length > 0) {
                $scope.ProjectHeadList = response.data;
                
            }
        });

      
        
    }

  

    $scope.GetSetData = function GetSetData(formData) {

        $scope.ngFormData = formData;
        var paramApp =
        {
            
            key: 'SELECT',
            ProjectID: $scope.ngFormData.ProjectName,
            ProjectHeadID: $scope.ngFormData.ProjectHead,
            InOutType: $scope.ngFormData.InOut,

            action: '',
            createdBy: CommService.GetUserId()
        };

        $scope.ProjectInOutList = [];
        

        ServiceProjectInOutList.GetSet(paramApp).then(function (response) {
            if (response.data.length > 0) {
                $scope.ProjectInOutList = response.data;
                $scope.gvStatus = true;
            }
            else {
                message_info("No data found for selected criteria!")
                $scope.gvStatus = false;
            }
        });
    }

    function IsCommaSeparatedNumbers(str) {

        if (str.indexOf(",,") !== -1
            || /^[0-9,.]*$/.test(str) == false)
            return false;
        else
            return true;
    }



   
    $scope.ResetFilters = function ResetFilters() {
       
        $scope.ngFormData.ProjectName = "";
        $scope.ngFormData.ProjectHead = "";
    };

});
eApp.filter('unsafe', function ($sce) {
    return function (val) {
        return $sce.trustAsHtml(val);
    };
});
eApp.service("ServiceProjectInOutList", function ($http, $rootScope) {
    var saveSts = '';
    var RspData = [];
    this.GetSet = function (formData) {
        saveSts = $http({
            data: formData,
            method: 'post',
            url: 'Handler/ProjectInOutList.ashx',
            datatype: "json"
        }).success(function (rsp) {
            if (rsp == "TokenExpire") {
                message_error("Token Expired", "Oops! You are not authorized to process any request. Login again.", function () { $rootScope.signOut(); });
            }
            else {
                RspData = rsp;
                return RspData;
            }
        }).error(function (rsp) {
            alert('Error');
        });
        return saveSts;
    };
});
