﻿eApp.controller('ProjectHead-Ctrl', function ($translate, $rootScope, $scope, $timeout, $filter, cfpLoadingBar, CommService, ServiceProjectHead, eAppVal, ngDialog, $controller) {
    cfpLoadingBar.start();
    $scope.fakeIntro = true;
    $timeout(function () {
        cfpLoadingBar.complete();
        $scope.fakeIntro = false;
        document.getElementById("wrapper").style.display = "Block";
    }, 750);

    $scope.currentPage = 1;
    $scope.ddlPageSize = eAppVal.GridPageSize;
    $scope.gvStatus = false;

   

    $scope.btnProcess = true;
    $scope.ShowAll = false;
    $scope.ShowAllColumns = false;
    $scope.IsLoginUserAdmin = false;
    $scope.ngFormData = {};
    
    $scope.ngFormData.txtProjectHead = "";
    
            
    if ((window.localStorage.getItem("isLoginUserAdmin") != null
        && window.localStorage.getItem("isLoginUserAdmin") != 'undefined'
        && window.localStorage.getItem("isLoginUserAdmin") == '1')) {
        $scope.IsLoginUserAdmin = true;
    }

   
    
    PageLoad();

    function PageLoad() {
        var paramApp =
        {
            key: 'SELECT',
            ProjectHName: $scope.ngFormData.txtProjectHead,
            ProjectHSen: $scope.ngFormData.txtProjectHeadSen,
            
            action: '',
            createdBy: CommService.GetUserId()
        };


        $scope.ProjectHeadList = [];
        ServiceProjectHead.GetSet(paramApp).then(function (response) {
            if (response.data.length > 0) {
                $scope.ProjectHeadList = response.data;

                $scope.gvStatus = true;
            }
            else {
                $scope.gvStatus = false;
            }
        });

    


        CheckPageEditMode();
    }


    function CheckPageEditMode() {
        var url = new URL(window.location.href);
        $scope.EditID = url.searchParams.get("Id") != null ? url.searchParams.get("Id") : 0;
        if ($scope.EditID != 0 && $scope.EditID != 'undefined' && $scope.EditID != null) {
            GetDataInEditMode($scope.EditID);
        }
    }

    function GetDataInEditMode(id) {
        var paramEdit =
        {
            key: 'SELECT_FOR_EDIT',
            action: id,
            createdBy: CommService.GetUserId()
        };
        ServiceProjectHead.GetSet(paramEdit).then(function (response) {
            if (response.data.length > 0) {
               
                $scope.ngFormData.txtProjectHead = response.data[0].Head;
                $scope.ngFormData.txtProjectHeadSen = response.data[0].Seniority;
                              
                  }
            else {
                message_warning("Error", "Unable to get data in edit mode");
            }
        });

    }


    $scope.Save_Click = function () {

        //   $scope.GetSetData($scope.EditID == 0 || $scope.EditID == 'undefined' || $scope.EditID == null ? 'INSERT' : 'UPDATE', $scope.EditID);


        $scope.Nkey = ($scope.EditID == 0 || $scope.EditID == 'undefined' || $scope.EditID == null ? 'INSERT' : 'UPDATE')

        if (!confirm("Are you sure to save this record?")) {
            return;
        }
        var paramInsert =
        {
            key: $scope.Nkey,
            EditID: $scope.EditID,
           
            ProjectHName: $scope.ngFormData.txtProjectHead,
            Seniority: $scope.ngFormData.txtProjectHeadSen,

            action: '',
            createdBy: CommService.GetUserId()
        };
        ServiceProjectHead.GetSet(paramInsert).then(function (response) {

            if (response.data[0].Msg == 'OK') {

                message_success("Success", "Record Saved Successfully.");
                $scope.btnProcess = true;
                window.location.href = "ProjectHead.html";
            } else {
                message_warning("Error", response.data[0].Msg);
                $scope.btnProcess = true;
            }
        });

    }
  

    $scope.EditProjectHead = function EditProjectHead(x) {
        
        window.location.href = "ProjectHead.html?Id=" + x.ProjectID;
    }

    $scope.DeleteProjectHead = function DeleteProjectHead(x) {
      
        if (!confirm("Are you sure you want to delete this record?")) {
            return;
        }
        var paramDel =
        {
            key: 'DELETE',
            action: x.ProjectID,
            createdBy: CommService.GetUserId()

        };
         ServiceProjectHead.GetSet(paramDel).then(function (response) {
            if (response.data[0].Msg == 'OK') {
                message_success("Success", "Record Deleted Successfully.");
                $scope.gvStatus = true;
                PageLoad();
            }
            else {
                message_warning("Error", response.data[0].Msg);
                $scope.gvStatus = false;
                PageLoad();
            }
        });

    }

    function IsCommaSeparatedNumbers(str) {

        if (str.indexOf(",,") !== -1
            || /^[0-9,.]*$/.test(str) == false)
            return false;
        else
            return true;
    }

    
       

   
    $scope.ResetFilters = function ResetFilters() {
        $scope.ngFormData.txtProjectHead = "";
       
            };

});
eApp.filter('unsafe', function ($sce) {
    return function (val) {
        return $sce.trustAsHtml(val);
    };
});
eApp.service("ServiceProjectHead", function ($http, $rootScope) {
    var saveSts = '';
    var RspData = [];
    this.GetSet = function (formData) {
        saveSts = $http({
            data: formData,
            method: 'post',
            url: 'Handler/ProjectHead.ashx',
            datatype: "json"
        }).success(function (rsp) {
            if (rsp == "TokenExpire") {
                message_error("Token Expired", "Oops! You are not authorized to process any request. Login again.", function () { $rootScope.signOut(); });
            }
            else {
                RspData = rsp;
                return RspData;
            }
        }).error(function (rsp) {
            alert('Error');
        });
        return saveSts;
    };
});
