﻿var eLogApp = angular.module('eLogApp', ['chieffancypants.loadingBar']);
eLogApp.controller('LoginContr', function ($scope, LoginService, $timeout, cfpLoadingBar, $rootScope) {
    $scope.ErrorMsg = false;
    cfpLoadingBar.start();
    $scope.fakeIntro = true;
    $timeout(function () {
        cfpLoadingBar.complete();
        $scope.fakeIntro = false;
        document.getElementById("fakeIntroid").style.display = "Block";
    }, 750);

    $scope.SSOLogin = function () {
        if ($scope.txtSSOId != null || $scope.txtSSOId != '' || $scope.txtSSOId != undefined) {
            
            window.localStorage.removeItem("userid");            
            window.localStorage.setItem("userid", $scope.txtSSOId);
            window.location.href = "Dashboard.html";
        }
    }

    $scope.SSOLoginSecure = function () {
        debugger
        if (($scope.txtSSOId != null || $scope.txtSSOId != '' || $scope.txtSSOId != undefined) &&
            $scope.txtSSOPwd != null || $scope.txtSSOPwd != '' || $scope.txtSSOPwd != undefined) {
            LoginService.SSOLoginSecure($scope.txtSSOId, $scope.txtSSOPwd).then(function (Rsp) {

                if (Rsp.data.length > 0 && Rsp.data[0].Msg.length > 0)
                {
                    message_error("Not Authorized", Rsp.data[0].Msg);
                }
                else if (Rsp.data.length > 0) {
                    debugger
                    window.localStorage.removeItem("token");
                    window.localStorage.removeItem("userid");
                    window.localStorage.removeItem("isLoginUserAdmin");
                    window.localStorage.removeItem("SessionTransferProposalID");
                    window.localStorage.setItem("token", Rsp.data[0].token);
                    window.localStorage.setItem("userid", $scope.txtSSOId);
                    window.localStorage.setItem("isLoginUserAdmin", Rsp.data[0].IsAdmin);
                    window.localStorage.setItem("SessionTransferProposalID", "0");
                    window.location.href = "Dashboard.html";
                }
                else {
                    message_error("Invalid", "Incorrect login details. Please try again.")
                }
            });
        }
    }

    $scope.LoginSecure = function () {
        debugger
        if (($scope.txtSSOId != null || $scope.txtSSOId != '' || $scope.txtSSOId != undefined) &&
            $scope.txtSSOPwd != null || $scope.txtSSOPwd != '' || $scope.txtSSOPwd != undefined) {
            LoginService.LoginSecure($scope.txtSSOId, $scope.txtSSOPwd).then(function (Rsp) {

                if (Rsp.data.length > 0 && Rsp.data[0].Msg != 'OK') {
                    message_error("Authorization Failed", Rsp.data[0].Msg);
                }
                else if (Rsp.data.length > 0) {
                    debugger
                    window.localStorage.removeItem("token");
                    window.localStorage.removeItem("userid");
                    window.localStorage.removeItem("isLoginUserAdmin");
                    window.localStorage.removeItem("SessionTransferProposalID");
                    window.localStorage.setItem("token", Rsp.data[0].token);
                    window.localStorage.setItem("userid", Rsp.data[0].Username);
                    window.localStorage.setItem("isLoginUserAdmin", Rsp.data[0].IsAdmin);
                    window.localStorage.setItem("SessionTransferProposalID", "0");
                    window.location.href = "Dashboard.html";
                }
                else {
                    message_error("Unauthorized", "Invalid login details.")
                }
            });
        }
    }
});
eLogApp.service('LoginService', function ($http) {
    var saveSts = '';
    var RspData = [];
    this.LoadLogoPath = function () {
        var formData = new FormData();
        formData.key = "LoadLogoPath";
        saveSts = $http({
            data: formData, method: 'post',
            url: document.location.href.substring(0, document.location.href.lastIndexOf('/')) + '/Handler/LogoPath.ashx',
            datatype: "json"
        }).success(function (rsp) {
            RspData = rsp;
            return RspData;
        }).error(function (rsp) {
            //alert('Error');            
        });
        return saveSts;
    };
    this.SSOLogin = function (sso_id) {
        var formData = new FormData();
        formData.key = "SSO_LOGIN";
        formData.UserId = sso_id;
        saveSts = $http({
            data: formData, method: 'post',
            url: document.location.href.substring(0, document.location.href.lastIndexOf('/')) + '/Handler/LogoPath.ashx',
            datatype: "json",
        }).success(function (rsp) {
            RspData = rsp;
            return RspData;
        }).error(function (rsp) {
            console.log("Error");
        });
        return saveSts;
    };
    this.SSOLoginSecure = function (sso_id, pwd) {
        var formData = new FormData();
        formData.key = "SSO_LOGIN_SECURE";
        formData.UserId = sso_id;
        formData.Pwd = pwd;
        saveSts = $http({
            data: formData, method: 'post',
            url: document.location.href.substring(0, document.location.href.lastIndexOf('/')) + '/Handler/LogoPath.ashx',
            datatype: "json",
        }).success(function (rsp) {
            RspData = rsp;
            return RspData;
        }).error(function (rsp) {
            console.log("Error");
        });
        return saveSts;
    };
    this.LoginSecure = function (username, pwd) {
        var formData = new FormData();
        formData.key = "LOGIN_SECURE";
        formData.UserId = username;
        formData.Pwd = pwd;
        saveSts = $http({
            data: formData, method: 'post',
            url: document.location.href.substring(0, document.location.href.lastIndexOf('/')) + '/Handler/LogoPath.ashx',
            datatype: "json",
        }).success(function (rsp) {
            RspData = rsp;
            return RspData;
        }).error(function (rsp) {
            console.log("Error");
        });
        return saveSts;
    };
});
eLogApp.config(function () {
});
eLogApp.run(function ($rootScope, LoginService, $timeout) {
      function LoadLogoPath() {
        LoginService.LoadLogoPath().then(function (Rsp) {
            $.each(Rsp.data, function (key, value) {
                if (value.AppName == 'Outer Logo Path') {
                    window.localStorage.setItem("OuterLogo", value.Path);
                }
                else if (value.AppName == 'Inner Logo Path') {
                    window.localStorage.setItem("InnerLogo", value.Path);
                }
                else if (value.AppName == 'Page Title') {
                    window.localStorage.setItem("PageTitle", value.Path);
                }
                $rootScope.LoginLogo = window.localStorage.getItem("OuterLogo");
                $rootScope.LoginTitle = window.localStorage.getItem("PageTitle");
            });
        });
    }
});


