﻿eApp.controller('EmployeeOuter-Ctrl', function ($translate, $rootScope, $scope, $timeout, $filter, cfpLoadingBar, CommService, ServiceEmployeeOuter, eAppVal, ngDialog, $controller) {
    cfpLoadingBar.start();
    $scope.fakeIntro = true;
    $timeout(function () {
        cfpLoadingBar.complete();
        $scope.fakeIntro = false;
        document.getElementById("wrapper").style.display = "Block";
    }, 750);

    $scope.currentPage = 1;
    $scope.ddlPageSize = eAppVal.GridPageSize;
    $scope.gvStatus = false;
    var yearBeginDate = new Date(new Date().getUTCFullYear(), 0, 2);


    $scope.btnProcess = true;
    $scope.ShowAll = false;
    $scope.ShowAllColumns = false;
    $scope.IsLoginUserAdmin = false;
    $scope.ngFormData = {};

    $scope.ngFormData.txtEmployeeName = "";
    $scope.ngFormData.SaluteID = "";
    $scope.ngFormData.DesignationID = "";
    $scope.ngFormData.DepartmentName = "";
    $scope.ngFormData.txtIPNumber = "";
    $scope.ngFormData.txtMobile = "";
    $scope.ngFormData.txtPEmailId = "";
    $scope.ngFormData.txtOEmailId = "";
    $scope.ngFormData.txtSeniority = "";

    $scope.ngFormData.txtRemark = "";
    

    


    if ((window.localStorage.getItem("isLoginUserAdmin") != null
        && window.localStorage.getItem("isLoginUserAdmin") != 'undefined'
        && window.localStorage.getItem("isLoginUserAdmin") == '1')) {
        $scope.IsLoginUserAdmin = true;
    }



    PageLoad();

    function PageLoad() {
        var paramApp =
        {
            key: 'SELECT',

            action: '',
            createdBy: CommService.GetUserId()
        };


        $scope.EmployeeOuterList = [];
        ServiceEmployeeOuter.GetSet(paramApp).then(function (response) {
            if (response.data.length > 0) {
                $scope.EmployeeOuterList = response.data;

                $scope.gvStatus = true;
            }
            else {
                $scope.gvStatus = false;
            }
        });

        var paramGen =
        {
            key: 'SELECT_SALUTE',
            createdBy: CommService.GetUserId()
        };
        $scope.SaluteList = [];
        ServiceEmployeeOuter.GetSet(paramGen).then(function (response) {
            if (response.data.length > 0) {
                $scope.SaluteList = response.data;
            }
        });


        CheckPageEditMode();
    }


    function CheckPageEditMode() {
        var url = new URL(window.location.href);
        $scope.EditID = url.searchParams.get("Id") != null ? url.searchParams.get("Id") : 0;
        if ($scope.EditID != 0 && $scope.EditID != 'undefined' && $scope.EditID != null) {
            GetDataInEditMode($scope.EditID);
        }
    }

    function GetDataInEditMode(id) {
        var paramEdit =
        {
            key: 'SELECT_FOR_EDIT',
            action: id,
            createdBy: CommService.GetUserId()
        };
        ServiceEmployeeOuter.GetSet(paramEdit).then(function (response) {
            if (response.data.length > 0) {

                $scope.ngFormData.txtEmployeeName = response.data[0].EMPLOYEE_Name,
                $scope.ngFormData.SaluteID =  response.data[0].EMPLOYEE_SALUTE_Id,
                $scope.ngFormData.DesignationID = response.data[0].EMPLOYEE_DESIGNATION,
                $scope.ngFormData.DepartmentName = response.data[0].Department_Name,
                $scope.ngFormData.txtIPNumber = response.data[0].EMPLOYEE_Land_Line_Number,
                $scope.ngFormData.txtMobile = response.data[0].EMPLOYEE_Mobile_Number,
                $scope.ngFormData.txtPEmailId = response.data[0].EMPLOYEE_EmailId2,
                $scope.ngFormData.txtOEmailId = response.data[0].EMPLOYEE_EmailId1,
                $scope.ngFormData.txtSeniority = response.data[0].EMPLOYEE_Seniority_Number,
                $scope.ngFormData.txtRemark = response.data[0].EMPLOYEE_Remark


            }
            else {
                message_warning("Error", "Unable to get data in edit mode");
            }
        });

    }


    $scope.Save_Click = function () {

        //   $scope.GetSetData($scope.EditID == 0 || $scope.EditID == 'undefined' || $scope.EditID == null ? 'INSERT' : 'UPDATE', $scope.EditID);


        $scope.Nkey = ($scope.EditID == 0 || $scope.EditID == 'undefined' || $scope.EditID == null ? 'INSERT' : 'UPDATE')

        if (!confirm("Are you sure to save this record?")) {
            return;
        }
        var paramInsert =
        {
            key: $scope.Nkey,
            EditID: $scope.EditID,

            EmployeeName: $scope.ngFormData.txtEmployeeName,
            SaluteID: $scope.ngFormData.SaluteID,
            DesignationID: $scope.ngFormData.DesignationID,
            DepartmentName: $scope.ngFormData.DepartmentName,
            IPNumber: $scope.ngFormData.txtIPNumber,
            Mobile: $scope.ngFormData.txtMobile,
            PEmailId: $scope.ngFormData.txtPEmailId,
            OEmailId: $scope.ngFormData.txtOEmailId,
            Seniority: $scope.ngFormData.txtSeniority,
            Remark: $scope.ngFormData.txtRemark,

            action: '',
            createdBy: CommService.GetUserId()
        };
        ServiceEmployeeOuter.GetSet(paramInsert).then(function (response) {

            if (response.data[0].Msg == 'OK') {

                message_success("Success", "Record Saved Successfully.");
                $scope.btnProcess = true;
                window.location.href = "EmployeeOuter.html";
            } else {
                message_warning("Error", response.data[0].Msg);
                $scope.btnProcess = true;
            }
        });

    }


    $scope.EditEmployeeOuter = function EditEmployeeOuter(x) {

        window.location.href = "EmployeeOuter.html?Id=" + x.EMPLOYEE_Id;
    }

    $scope.DeleteEmployeeOuter = function DeleteEmployeeOuter(x) {

        if (!confirm("Are you sure you want to delete this record?")) {
            return;
        }
        var paramDel =
        {
            key: 'DELETE',
            action: x.EMPLOYEE_Id,
            createdBy: CommService.GetUserId()

        };
        ServiceEmployeeOuter.GetSet(paramDel).then(function (response) {
            if (response.data[0].Msg == 'OK') {
                message_success("Success", "Record Deleted Successfully.");
                $scope.gvStatus = true;
                PageLoad();
            }
            else {
                message_warning("Error", response.data[0].Msg);
                $scope.gvStatus = false;
                PageLoad();
            }
        });

    }

    function IsCommaSeparatedNumbers(str) {

        if (str.indexOf(",,") !== -1
            || /^[0-9,.]*$/.test(str) == false)
            return false;
        else
            return true;
    }





    $scope.ResetFilters = function ResetFilters() {
        $scope.ngFormData.txtEmployeeOuter = "";

    };

});
eApp.filter('unsafe', function ($sce) {
    return function (val) {
        return $sce.trustAsHtml(val);
    };
});
eApp.service("ServiceEmployeeOuter", function ($http, $rootScope) {
    var saveSts = '';
    var RspData = [];
    this.GetSet = function (formData) {
        saveSts = $http({
            data: formData,
            method: 'post',
            url: 'Handler/EmployeeOuter.ashx',
            datatype: "json"
        }).success(function (rsp) {
            if (rsp == "TokenExpire") {
                message_error("Token Expired", "Oops! You are not authorized to process any request. Login again.", function () { $rootScope.signOut(); });
            }
            else {
                RspData = rsp;
                return RspData;
            }
        }).error(function (rsp) {
            alert('Error');
        });
        return saveSts;
    };
});
