﻿eApp.controller('CreationList-Ctrl', function ($translate, $rootScope, $scope, $timeout, $filter, cfpLoadingBar, CommService, ServiceCreationList, eAppVal, ngDialog, $controller) {
    cfpLoadingBar.start();
    $scope.fakeIntro = true;
    $timeout(function () {
        cfpLoadingBar.complete();
        $scope.fakeIntro = false;
        document.getElementById("wrapper").style.display = "Block";
    }, 750);

    $scope.currentPage = 1;
    $scope.ddlPageSize = eAppVal.GridPageSize;
    $scope.gvStatus = false;

    $scope.EditID = '0';

    $scope.btnProcess = true;
    $scope.ShowAll = false;
    $scope.ShowAllColumns = false;
    $scope.IsLoginUserAdmin = false;
    $scope.isShowEmpWiseLatestRecords = true;
    $scope.CreationList = [];
    $scope.ngFormData = {};
    var yearBeginDate = new Date(new Date().getUTCFullYear(), 0, 2);
    $scope.ngFormData.applicationDate = yearBeginDate.toJSON().slice(0, 10).split('-').reverse().join('-');
    $scope.ngFormData.designationID = "";
    $scope.ngFormData.fromOffice = "";
    $scope.ngFormData.fromDepartmentID = "";
    $scope.ngFormData.fromPlace = "";
    $scope.ngFormData.fromDistrictID = "";
    $scope.ngFormData.PostStatus = "";
    $scope.ngFormData.PostType = "";
    $scope.ngFormData.isExtra = 0;
    $scope.ngFormData.isRemoved = false;

    $scope.ShowPage = false;
    $scope.ShowBtnInsert = false;
    $scope.ShowBtnUpdate = false;
    $scope.ShowBtnDelete = false;
   

    if ((window.localStorage.getItem("isLoginUserAdmin") != null
        && window.localStorage.getItem("isLoginUserAdmin") != 'undefined'
        && window.localStorage.getItem("isLoginUserAdmin") == '1')) {
        $scope.IsLoginUserAdmin = true;
    }

    CheckPageAuthentication();

    PageLoad();

    function CheckPageAuthentication() {
        //For Add/Edit pages, provide the parent page name
        CommService.CheckPageAuth('CreationList.html', CommService.GetUserId()).then(function (Rsp) {
            if (Rsp.data[0].PageDisplayStatus == "OK") {
                $scope.ShowPage = (Rsp.data[0].CanView == '0' || Rsp.data[0].CanView == 'false') ? false : true;
                $scope.ShowBtnInsert = (Rsp.data[0].CanInsert == '0' || Rsp.data[0].CanInsert == 'false') ? false : true;
                $scope.ShowBtnUpdate = (Rsp.data[0].CanUpdate == '0' || Rsp.data[0].CanUpdate == 'false') ? false : true;
                $scope.ShowBtnDelete = (Rsp.data[0].CanDelete == '0' || Rsp.data[0].CanDelete == 'false') ? false : true;
            }
            else {
                window.location.href = "401.html";
            }
        });
    }

    function PageLoad() {

        FillComboBoxes();

        $scope.CreationList = [];

        var paramApp =
        {
            key: 'SELECT',
            
            designationID: $scope.ngFormData.designationID,
            fromOffice: $scope.ngFormData.fromOffice,
            fromDepartmentID: $scope.ngFormData.fromDepartmentID,
            fromPlace: $scope.ngFormData.fromPlace,
            fromDistrictID: $scope.ngFormData.fromDistrictID,
            PostStatus: $scope.ngFormData.PostStatus,
            PostType: $scope.ngFormData.PostType,
            isExtra: $scope.ngFormData.isExtra,
            isRemoved: $scope.ngFormData.isRemoved == true ? 0: 1,
            
                
            action: '',
            createdBy: CommService.GetUserId()
        };

        $scope.CreationList = [];
        ServiceCreationList.GetSet(paramApp).then(function (response) {
            if (response.data.length > 0) {
                $scope.CreationList = response.data;

                $scope.gvStatus = true;
            }
            else {
                $scope.gvStatus = false;
            }
        });

    }

    function FillComboBoxes() {

        var paramDes =
        {
            key: 'SELECT_DESIGNATIONS',
            createdBy: CommService.GetUserId()
        };
        $scope.DesignationList = [];
        ServiceCreationList.GetSet(paramDes).then(function (response) {
            if (response.data.length > 0) {
                $scope.DesignationList = response.data;
            }
        });


        var paramDapt =
        {
            key: 'SELECT_DEPARTMENTS',
            createdBy: CommService.GetUserId()
        };
        $scope.FromDepartmentList = [];
        
        ServiceCreationList.GetSet(paramDapt).then(function (response) {
            if (response.data.length > 0) {
                $scope.FromDepartmentList = response.data;
                
            }
        });

        var paramDist =
        {
            key: 'SELECT_DISTRICTS',
            createdBy: CommService.GetUserId()
        };
        $scope.FromDistrictList = [];
       
        ServiceCreationList.GetSet(paramDist).then(function (response) {
            if (response.data.length > 0) {
                $scope.FromDistrictList = response.data;
                
            }
        });
        var paramOffice =
        {
            key: 'SELECT_Office',
            createdBy: CommService.GetUserId()
        };
        $scope.fromOfficeList = [];
        ServiceCreationList.GetSet(paramOffice).then(function (response) {
            if (response.data.length > 0) {
                $scope.FromOfficeList = response.data;
            }
        });

        var paramPlace =
        {
            key: 'SELECT_Place',
            createdBy: CommService.GetUserId()
        };
        $scope.FromPlaceList = [];
        ServiceCreationList.GetSet(paramPlace).then(function (response) {
            if (response.data.length > 0) {
                $scope.FromPlaceList = response.data;
            }
        });
        
    }
   
   
    $scope.GetSetData = function GetSetData(formData) {

        $scope.ngFormData = formData;
        var paramApp =
        {
            key: 'SELECT',

            designationID: $scope.ngFormData.designationID,
            fromOffice: $scope.ngFormData.fromOffice,
            fromDepartmentID: $scope.ngFormData.fromDepartmentID,
            fromPlace: $scope.ngFormData.fromPlace,
            fromDistrictID: $scope.ngFormData.fromDistrictID,
            PostStatus: $scope.ngFormData.PostStatus,
            PostType: $scope.ngFormData.PostType,
            isExtra: $scope.ngFormData.isExtra,
            isRemoved: $scope.ngFormData.isRemoved == true ? 0 : 1,

            action: '',
            createdBy: CommService.GetUserId()
        };

        $scope.CreationList = [];
        ServiceCreationList.GetSet(paramApp).then(function (response) {
            if (response.data.length > 0) {
                $scope.CreationList = response.data;
                $scope.gvStatus = true;
            }
            else {
                message_info("No data found for selected criteria!")
                $scope.gvStatus = false;
            }
        });
    }

    function IsCommaSeparatedNumbers(str) {

        if (str.indexOf(",,") !== -1
            || /^[0-9,.]*$/.test(str) == false)
            return false;
        else
            return true;
    }

    $scope.AddEditCreationList = function () {
        if ($scope.ShowBtnInsert == false) {
            message_warning("Unauthorized!", "You are not authorized to do this action.");
            return;
        }
        window.location.href = "AddEditCreation.html";
    }


    $scope.EditCreationList = function EditCreationList(x) {
        if ($scope.ShowBtnUpdate == false) {
            message_warning("Unauthorized!", "You are not authorized to do this action.");
            return;
        }
        window.location.href = "AddEditCreation.html?Id=" + x.CreationId;
    }

    $scope.DeleteCreationList = function DeleteCreationList(x) {
        if ($scope.ShowBtnDelete == false) {
            message_warning("Unauthorized!", "You are not authorized to do this action.");
            return;
        }
        if (!confirm("Are you sure you want to delete this record?")) {
            return;
        }
        var paramDel =
        {
            key: 'DELETE',
            action: x.CreationId,
            createdBy: CommService.GetUserId()
            
        };
        ServiceCreationList.GetSet(paramDel).then(function (response) {
            if (response.data[0].Msg == 'OK') {
                message_success("Success", "Record Deleted Successfully.");
                $scope.gvStatus = true;
                PageLoad();
            }
            else {
                message_warning(response.data[0].Msg, "Please contact administrator.");
            }
        });
    }

    
    $scope.ActivateCreation = function ActivateCreation(x) {
        if ($scope.ShowBtnUpdate == false) {
            message_warning("Unauthorized!", "You are not authorized to do this action.");
            return;
        }
        if (!confirm("Are you sure you want ACTIVATE this record?")) {
            return;
        }
        var paramDel =
        {
            key: 'ACTIVATE',
            action: x.CreationId,
            createdBy: CommService.GetUserId()

        };
        ServiceCreationList.GetSet(paramDel).then(function (response) {
            if (response.data[0].Msg == 'OK') {
                message_success("Success", "Record Activated Successfully.");
                $scope.gvStatus = true;
                PageLoad();
            }
            else {
                message_warning(response.data[0].Msg, "Please contact administrator.");
            }
        });
    }
  

    $scope.ResetFilters = function ResetFilters() {
        var yearBeginDate1 = new Date(new Date().getUTCFullYear(), 0, 2);
        $('#txtApplicationDate').val(yearBeginDate1.toJSON().slice(0, 10).split('-').reverse().join('-'));
       
        $scope.ngFormData.designationID = "";
        $scope.ngFormData.genderID = "";
        $scope.ngFormData.fromOffice = "";
        $scope.ngFormData.fromDeptID = "";
        $scope.ngFormData.fromPlace = "";
        $scope.ngFormData.fromDistrictID = "";
        $scope.ngFormData.isRemoved = "";
        $scope.ngFormData.isExtra = 0;
$scope.ngFormData.fromDepartmentID = "";
$scope.ngFormData.PostStatus = "";
$scope.ngFormData.PostType = "";
        
    };

});
eApp.filter('unsafe', function ($sce) {
    return function (val) {
        return $sce.trustAsHtml(val);
    };
});
eApp.service("ServiceCreationList", function ($http, $rootScope) {
    var saveSts = '';
    var RspData = [];
    this.GetSet = function (formData) {
        saveSts = $http({
            data: formData,
            method: 'post',
            url: 'Handler/CreationList.ashx',
            datatype: "json"
        }).success(function (rsp) {
            if (rsp == "TokenExpire") {
                message_error("Token Expired", "Oops! You are not authorized to process any request. Login again.", function () { $rootScope.signOut(); });
            }
            else {
                RspData = rsp;
                return RspData;
            }
        }).error(function (rsp) {
            alert('Error');
        });
        return saveSts;
    };
});
