﻿eApp.controller('ComplianceReport-Ctrl', function ($translate, $rootScope, $scope, $timeout, $filter, cfpLoadingBar, CommService, ServiceComplianceReport, eAppVal, ngDialog, $controller) {
    cfpLoadingBar.start();
    $scope.fakeIntro = true;
    $timeout(function () {
        cfpLoadingBar.complete();
        $scope.fakeIntro = false;
        document.getElementById("wrapper").style.display = "Block";
    }, 750);
    var rec_user_id = "1"
    $scope.currentPage = 1;
    $scope.ddlPageSize = eAppVal.GridPageSize;
    $scope.gvStatus = false;
    $scope.ngClose = {};
    $scope.btnProcess = true;
    $scope.ProposalID = "";
    $scope.ProposalName = "";
    $scope.ComplianceRemark = "";
    $scope.IsLoginUserAdmin = false;
    $scope.ShowAllColumns = false;
    //$scope.IsSelectReport = true;
    $scope.ProposalList = [];
    $scope.ComplianceApplicationList = [];
    $scope.TransferApplicationReportList = {};

    $scope.ngFormData = {};
    $scope.ngFormData.proposalID = "";
    $scope.ngFormData.proposalName = ""; 
    $scope.ngFormData.complianceRemark = "";

    $scope.ShowPage = false;
    $scope.ShowBtnInsert = false;
    $scope.ShowBtnUpdate = false;
    $scope.ShowBtnDelete = false;

    debugger
    if ((window.localStorage.getItem("isLoginUserAdmin") != null
        && window.localStorage.getItem("isLoginUserAdmin") != 'undefined'
        && window.localStorage.getItem("isLoginUserAdmin") == '1')) {
        $scope.IsLoginUserAdmin = true;
    }

    CheckPageAuthentication();

    PageLoad();

    function PageLoad() {
        debugger
        FillComboBoxes();

        GetDataOnPageLoad('SELECT_REPORT');

        document.getElementById('ProposalID').disabled = true;//$scope.IsSelectReport;
    }


    function CheckPageAuthentication() {
        CommService.CheckPageAuth('ComplianceReport.html', CommService.GetUserId()).then(function (Rsp) {
            if (Rsp.data[0].PageDisplayStatus == "OK") {
                $scope.ShowPage = (Rsp.data[0].CanView == '0' || Rsp.data[0].CanView == 'false') ? false : true;
                $scope.ShowBtnInsert = (Rsp.data[0].CanInsert == '0' || Rsp.data[0].CanInsert == 'false') ? false : true;
                $scope.ShowBtnUpdate = (Rsp.data[0].CanUpdate == '0' || Rsp.data[0].CanUpdate == 'false') ? false : true;
                $scope.ShowBtnDelete = (Rsp.data[0].CanDelete == '0' || Rsp.data[0].CanDelete == 'false') ? false : true;
            }
            else {
                window.location.href = "401.html";
            }
        });
    }

    function GetDataOnPageLoad(key) {
        //Get Data on Page Load
        $scope.ComplianceApplicationList = [];
        if ($scope.ShowPage == false) {
            message_warning("Unauthorized!", "You are not authorized to do this action.");
            return;
        }

        var paramTLP =
           {
               key: key,
               proposalID: $scope.ngFormData.proposalID,
               complianceRemark: $scope.ngFormData.complianceRemark,
               action: 0,
               createdBy: CommService.GetUserId()
           };
        ServiceComplianceReport.GetSet(paramTLP).then(function (response) {
            debugger
            $scope.ComplianceApplicationList = response.data;
            if ($scope.ComplianceApplicationList.length > 0) {
                $scope.gvStatus = true;
            }
            else {
                //message_info("No data found for selected criteria")
                $scope.gvStatus = false;
            }
        });

    }

    function FillComboBoxes() {
        debugger
        var paramProp =
                {
                    key: 'SELECT_PROPOSALS',
                    createdBy: CommService.GetUserId()
                };
        $scope.ProposalList = [];
        ServiceComplianceReport.GetSet(paramProp).then(function (response) {
            if (response.data.length > 0) {
                $scope.ProposalList = response.data;
            }
        });
    }

    $scope.GetSetData = function GetSetData(key, x_id) {

        if (key == '')
        {
            key = $scope.IsSelectReport == true ? 'SELECT_REPORT' : 'SELECT_APPLICATIONS';
        }

        if (key == 'SELECT_APPLICATIONS') {
            if ($scope.ShowPage == false) {
                message_warning("Unauthorized!", "You are not authorized to do this action.");
                return;
            }
            if ($scope.ngFormData.proposalID == 'undefined' || $scope.ngFormData.proposalID == "" || $scope.ngFormData.proposalID == 0) {
                $scope.ComplianceApplicationList = [];
                message_warning("Please select proposal");
                return;
            }
            $scope.ComplianceApplicationList = [];
            var paramTL =
               {
                   key: key,
                   proposalID: $scope.ngFormData.proposalID,
                   complianceRemark: $scope.ngFormData.complianceRemark,
                   action: x_id,
                   createdBy: CommService.GetUserId()
               };
            ServiceComplianceReport.GetSet(paramTL).then(function (response) {
                debugger
                $scope.ComplianceApplicationList = response.data;
                if ($scope.ComplianceApplicationList.length > 0) {
                    $scope.gvStatus = true;
                }
                else {
                    message_info("No data found for selected criteria")
                    $scope.gvStatus = false;
                }
            });
        }
        if (key == 'SELECT_REPORT') {
            //if ($scope.ngFormData.proposalID == 'undefined' || $scope.ngFormData.proposalID == "" || $scope.ngFormData.proposalID == 0) {
            //    message_warning("Please select proposal");
            //    return;
            //}
            $scope.ComplianceApplicationList = [];
            if ($scope.ShowPage == false) {
                message_warning("Unauthorized!", "You are not authorized to do this action.");
                return;
            }
            var paramTL =
               {
                   key: key,
                   proposalID: $scope.ngFormData.proposalID,
                   complianceRemark: $scope.ngFormData.complianceRemark,
                   action: x_id,
                   createdBy: CommService.GetUserId()
               };
            ServiceComplianceReport.GetSet(paramTL).then(function (response) {
                debugger
                $scope.ComplianceApplicationList = response.data;
                if ($scope.ComplianceApplicationList.length > 0) {
                    $scope.gvStatus = true;
                }
                else {
                    message_info("No data found for selected criteria")
                    $scope.gvStatus = false;
                }
            });
        }
        if (key == 'MARK_COMPLIANCE')
        {
            if ($scope.ShowBtnUpdate == false) {
                message_warning("Unauthorized!", "You are not authorized to do this action.");
                return;
            }

            if ($scope.ngFormData.proposalID == 'undefined' || $scope.ngFormData.proposalID == "" || $scope.ngFormData.proposalID == 0) {
                message_warning("Please select proposal");
                return;
            }

            if ($scope.ngFormData.complianceRemark == "")
            {
                message_warning("Please enter Compliance Remark.");
                return;
            }

            if (x_id == "") {
                message_warning("Please select applications to be complianced");
                return;
            }
            
            if(!IsCommaSeparatedNumbers(x_id))
            {
                message_warning("Invalid", "comma seperated values are invalid");
                return;
            }
            else if(confirm("Are you sure you want to mark application as complianced?"))
            {
                var paramPromo =
                   {
                       key: key,
                       proposalID: $scope.ngFormData.proposalID,
                       complianceRemark: $scope.ngFormData.complianceRemark,
                       action: x_id,
                       createdBy: CommService.GetUserId()
                   };
                ServiceComplianceReport.GetSet(paramPromo).then(function (response) {
                    debugger
                    if (response.data[0].Msg == 'OK') {
                        $("#myModalRemark").modal('toggle');
                        message_success("Success", "Application(s) complianced successfully!");

                        $scope.ProposalChanged($scope.ngFormData.proposalID);

                        $scope.ngFormData.complianceRemark = "";
                    }
                    else {
                        message_warning("Error", response.data[0].Msg);
                    }
                });
            }
        }
    }

    function IsCommaSeparatedNumbers(str) {
        debugger
        if (str.indexOf(",,") !== -1
            || /^[0-9,.]*$/.test(str) == false)
            return false;
        else
            return true;
    }   

    $scope.ProposalChanged = function ProposalChanged(id) {
        
        //$scope.GetSetData('SELECT_APPLICATIONS', id);
        $scope.GetSetData($scope.IsSelectReport == true ? 'SELECT_REPORT' : 'SELECT_APPLICATIONS', id);
    }

    $scope.IsSelectReportChanged = function (x) {

        if (x == '1')
        {
            $scope.IsSelectReport = true;
            $scope.ngFormData.proposalID = '';
            document.getElementById('ProposalID').disabled = true;
            $scope.ComplianceApplicationList = [];
            //$scope.GetSetData('SELECT_REPORT');
        }
        else if (x == '0')
        {
            $scope.IsSelectReport = false;
            $scope.ngFormData.proposalID = '';
            document.getElementById('ProposalID').disabled = false;
            $scope.ComplianceApplicationList = [];
        }
        else {
            x = '1';
            $scope.IsSelectReport = true;
            $scope.ComplianceApplicationList = [];
            message_warning("UNAUTHORIZED!", "Only Admin user(s) are authorized for Compliance Report operations.");

        }        
        
        //$scope.GetSetData($scope.IsSelectReport == true ? 'SELECT_REPORT' : 'SELECT_APPLICATIONS');
    }

    $scope.Reset = function Reset() {
        if(confirm("Are you sure you want to reset?"))
            window.location.href = "ComplianceReport.html";
    }

    $scope.ShowComplianceRemarkModal = function ShowComplianceRemarkModal() {
        if ($scope.ngFormData.proposalID == 'undefined' || $scope.ngFormData.proposalID == "" || $scope.ngFormData.proposalID == 0) {
            message_warning("Please select proposal");
            return;
        }
        var applicationIDs = "";
        if([ applicationIDs,
            $.grep($scope.ComplianceApplicationList, function (p) {
                return p.Selected == 1
            }).map(function (p) {
                return p.ApplicationIDs;
            })
        ].filter(Boolean).join().replaceAll(' ', '') == '')
        {
            message_warning("Please select applications to be complianced");
            return;
        }

        $scope.ngFormData.complianceRemark = "";
        $("#myModalRemark").modal('toggle');
    }        

    $scope.GetIDsAndSubmitForCompliance = function GetIDsAndSubmitForCompliance() {
        debugger
        var applicationIDs = "";

        applicationIDs = [
            applicationIDs,
            $.grep($scope.ComplianceApplicationList, function (p) {
                return p.Selected == 1
            }).map(function (p) {
                return p.ApplicationIDs;
            })
        ].filter(Boolean).join().replaceAll(' ','');
                
        $scope.GetSetData('MARK_COMPLIANCE', applicationIDs);
    }

    //$scope.exportDataDownload = (function (tableId) { // ex: '#my-table'
    //    debugger
    //    var uri = 'data:application/vnd.ms-excel;base64,'
    //        , template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>'
    //        , base64 = function (s) { return window.btoa(unescape(encodeURIComponent(s))) }
    //        , format = function (s, c) { return s.replace(/{(\w+)}/g, function (m, p) { return c[p]; }) }
    //    return function (tableId) {
    //        if (!tableId.nodeType) tableId = document.getElementById(tableId)
    //        var ctx = { worksheet: 'download' || 'Worksheet', tableId: tableId.innerHTML }
    //        debugger
    //        document.getElementById('downloadExcelLink').href = uri + base64(format(template, ctx));
    //        document.getElementById('downloadExcelLink').download = 'download';
    //        document.getElementById('downloadExcelLink').click();
    //    }
    //})();

});
eApp.filter('unsafe', function ($sce) {
    return function (val) {
        return $sce.trustAsHtml(val);
    };
});
eApp.service("ServiceComplianceReport", function ($http, $rootScope) {
    var saveSts = '';
    var RspData = [];
    this.GetSet = function (formData) {
        saveSts = $http({
            data: formData,
            method: 'post',
            url: 'Handler/ComplianceReport.ashx',
            datatype: "json"
        }).success(function (rsp) {
            if (rsp == "TokenExpire") {
                message_error("Token Expired", "Oops! You are not authorized to process any request. Login again.", function () { $rootScope.signOut(); });
            }
            else {
                RspData = rsp;
                return RspData;
            }
        }).error(function (rsp) {
            alert('Error');
        });
        return saveSts;
    };
});
