﻿eApp.controller('CategoryList-Ctrl', function ($translate, $rootScope, $scope, $timeout, $filter, cfpLoadingBar, CommService, ServiceCategoryList, eAppVal, ngDialog, $controller) {
    cfpLoadingBar.start();
    $scope.fakeIntro = true;
    $timeout(function () {
        cfpLoadingBar.complete();
        $scope.fakeIntro = false;
        document.getElementById("wrapper").style.display = "Block";
    }, 750);

    $scope.currentPage = 1;
    $scope.ddlPageSize = eAppVal.GridPageSize;
    $scope.ShowPage = false;
    $scope.ShowBtnInsert = false;
    $scope.ShowBtnUpdate = false;
    $scope.ShowBtnDelete = false;

    $scope.EditID = '0';

    $scope.ShowAll = false;
    $scope.ShowAllColumns = false;
    $scope.IsLoginUserAdmin = false;
    $scope.ngFormData = {};

    $scope.ngFormData.CategoryListName = "";
    $scope.ngFormData.CategoryListNameHindi = "";



    if ((window.localStorage.getItem("isLoginUserAdmin") != null
        && window.localStorage.getItem("isLoginUserAdmin") != 'undefined'
        && window.localStorage.getItem("isLoginUserAdmin") == '1')) {
        $scope.IsLoginUserAdmin = true;
    }

    CheckPageAuthentication();

    PageLoad();

    function CheckPageAuthentication() {
        //For Add/Edit pages, provide the parent page name
        CommService.CheckPageAuth('CategoryList.html', CommService.GetUserId()).then(function (Rsp) {
            if (Rsp.data[0].PageDisplayStatus == "OK") {
                $scope.ShowPage = (Rsp.data[0].CanView == '0' || Rsp.data[0].CanView == 'false') ? false : true;
                $scope.ShowBtnInsert = (Rsp.data[0].CanInsert == '0' || Rsp.data[0].CanInsert == 'false') ? false : true;
                $scope.ShowBtnUpdate = (Rsp.data[0].CanUpdate == '0' || Rsp.data[0].CanUpdate == 'false') ? false : true;
                $scope.ShowBtnDelete = (Rsp.data[0].CanDelete == '0' || Rsp.data[0].CanDelete == 'false') ? false : true;
            }
            else {
                window.location.href = "401.html";
            }
        });
    }

    function PageLoad() {
        var paramApp =
        {
            key: 'SELECT',
            CategoryName: $scope.ngFormData.CategoryName,
            CategoryNameHindi: $scope.ngFormData.CategoryNameHindi,
            action: '',
            createdBy: CommService.GetUserId()
        };


        $scope.CategoryList = [];
        ServiceCategoryList.GetSet(paramApp).then(function (response) {
            if (response.data.length > 0) {
                $scope.CategoryList = response.data;

                $scope.ShowPage = true;
            }
            else {
                message_info("No data found for selected criteria!")
                $scope.ShowPage = false;
            }
        });

    }


  
    function IsCommaSeparatedNumbers(str) {

        if (str.indexOf(",,") !== -1
            || /^[0-9,.]*$/.test(str) == false)
            return false;
        else
            return true;
    }

    $scope.AddEditCategoryList = function () {

        if ($scope.ShowBtnInsert == false) {
            message_warning("Unauthorized!", "You are not authorized to do this action.");
            return;
        }
        window.location.href = "AddEditCategoryList.html";
    }


    $scope.EditCategoryList = function EditCategoryList(x) {

        if ($scope.ShowBtnUpdate == false) {
            message_warning("Unauthorized!", "You are not authorized to do this action.");
            return;
        }
        window.location.href = "AddEditCategoryList.html?Id=" + x.CategoryId;
    }

    $scope.DeleteCategoryList = function DeleteCategoryList(x) {
        if ($scope.ShowBtnDelete == false) {
            message_warning("Unauthorized!", "You are not authorized to do this action.");
            return;
        }
        if (!confirm("Are you sure you want to delete this record?")) {
            return;
        }
        var paramDel =
        {
            key: 'DELETE',
            action: x.CategoryId,
            createdBy: CommService.GetUserId()

        };
        ServiceCategoryList.GetSet(paramDel).then(function (response) {
            if (response.data[0].Msg == 'OK') {
                message_success("Success", "Record Deleted Successfully.");
                $scope.ShowPage = true;
                PageLoad();
            }
            else {
                message_warning("Error", response.data[0].Msg);
                $scope.ShowPage = false;
                PageLoad();
            }
        });

    }



});
eApp.filter('unsafe', function ($sce) {
    return function (val) {
        return $sce.trustAsHtml(val);
    };
});
eApp.service("ServiceCategoryList", function ($http, $rootScope) {
    var saveSts = '';
    var RspData = [];
    this.GetSet = function (formData) {
        saveSts = $http({
            data: formData,
            method: 'post',
            url: 'Handler/CategoryList.ashx',
            datatype: "json"
        }).success(function (rsp) {
            if (rsp == "TokenExpire") {
                message_error("Token Expired", "Oops! You are not authorized to process any request. Login again.", function () { $rootScope.signOut(); });
            }
            else {
                RspData = rsp;
                return RspData;
            }
        }).error(function (rsp) {
            alert('Error');
        });
        return saveSts;
    };
});
