﻿using System;
using System.Data;
using System.Web;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
/// <summary>
/// Summary description for OnlineUserCs
/// </summary>
public class OnlineUserCs
{
    DataSet ds;
    static DataView dv = new DataView();
    static DataTable dt = new DataTable();
    static DataRow Dr;
    public string id { get; set; }
    public string UserId { get; set; }
    public string Name { get; set; }
    public string IpAddress { get; set; }
    public string DateTime { get; set; }
    public string LoginStatus { get; set; }
    private bool _SaveAuth, _UpdateAuth, _DeleteAuth, _ViewAuth;
    private string _NotExist, _PageDisplaySts;
    public string NotExist
    {
        get
        {
            return _NotExist;
        }
        set
        {
            _NotExist = value;
        }
    }
    public string PageDisplaySts
    {
        get
        {
            return _PageDisplaySts;
        }
        set
        {
            _PageDisplaySts = value;
        }
    }
    public bool ViewAuth
    {
        get
        {
            return _ViewAuth;
        }
        set
        {
            _ViewAuth = value;
        }
    }
    public bool SaveAuth
    {
        get
        {
            return _SaveAuth;
        }
        set
        {
            _SaveAuth = value;
        }
    }
    public bool UpdateAuth
    {
        get
        {
            return _UpdateAuth;
        }
        set
        {
            _UpdateAuth = value;
        }
    }
    public bool DeleteAuth
    {
        get
        {
            return _DeleteAuth;
        }
        set
        {
            _DeleteAuth = value;
        }
    }
    APIProcedure objApi = new APIProcedure();
    public static DataTable GetLoginUser()
    {
        return dt;
    }
    public static int OnlineChechUser(string UserId)
    {
        int Cnt = 0;
        if (dt.Rows.Count > 0)
        {
            dv = dt.DefaultView;
            dv.RowFilter = "UserId='" + UserId + "'";
            Cnt = dv.Count;
        }
        return Cnt;
    }
    public static DataView SearchOnlineUser(string UserId)
    {
        if (dt.Rows.Count > 0)
        {
            dv = dt.DefaultView;
            dv.RowFilter = "UserId='" + UserId + "'";
        }
        return dv;
    }
    public static void StoreLoginUser(string UserId, string Name)
    {
        if (OnlineChechUser(UserId) == 0)
        {
            BindTable(UserId, Name);
        }
    }

    public static void BindTable(string UserId, string Name)
    {
        string ipaddress = "";
        try
        {
            System.Web.HttpContext context = System.Web.HttpContext.Current;
            ipaddress = context.Request.ServerVariables["HTTP_X_FORWARDED_FOR"];

            if (!string.IsNullOrEmpty(ipaddress))
            {
                string[] addresses = ipaddress.Split(',');
                if (addresses.Length != 0)
                {
                    ipaddress = addresses[0];
                }
            }

            ipaddress = context.Request.ServerVariables["REMOTE_ADDR"];
        }
        catch { }
        if (dt.Rows.Count <= 0)
        {
            DataColumnCollection columns = dt.Columns;

            if (!(columns.Contains("id")) == true)
            {


                dt.Columns.Add("id", typeof(int));
                dt.Columns.Add("UserId", typeof(string));
                dt.Columns.Add("Name", typeof(string));
                dt.Columns.Add("IpAddress", typeof(string));
                dt.Columns.Add("DateTime", typeof(string));
                dt.Columns.Add("LoginStatus", typeof(string));
            }
        }

        Dr = dt.NewRow();
        Dr["id"] = dt.Rows.Count + 1;
        Dr["UserId"] = UserId;
        Dr["Name"] = Name;
        Dr["IpAddress"] = ipaddress;
        Dr["DateTime"] = System.DateTime.Now.ToString("dd/MM/yyyy hh:ss:tt");
        Dr["LoginStatus"] = "Active";
        dt.Rows.Add(Dr);
        dt.AcceptChanges();
    }
    public static void LogoutUser(string UserId)
    {
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            if (dt.Rows[i]["UserId"].ToString().ToLower() == UserId.ToLower())
            {
                dt.Rows.RemoveAt(i);
                dt.AcceptChanges();
            }
        }
    }
    public void GetPageAuthentication(string User_Role_I, string FormPath_V)
    {
        ds = objApi.ByProcedure("ProcCheckRoleAthentication", new string[] { "User_Role_I", "FormPath_V" }, new string[] { User_Role_I, FormPath_V }, "BYDataset");
        if (ds.Tables[0].Rows.Count > 0)
        {
            NotExist = ds.Tables[0].Rows[0]["Role_V"].ToString();
            SaveAuth = bool.Parse(ds.Tables[0].Rows[0]["SaveChk"].ToString());
            UpdateAuth = bool.Parse(ds.Tables[0].Rows[0]["UpdateChk"].ToString());
            DeleteAuth = bool.Parse(ds.Tables[0].Rows[0]["DeleteChk"].ToString());
            ViewAuth = bool.Parse(ds.Tables[0].Rows[0]["ViewChk"].ToString());
            PageDisplaySts = ds.Tables[0].Rows[0]["PageDisplaySts"].ToString();
        }
        else
        {
            PageDisplaySts = "";
            NotExist = "NotExist";
            SaveAuth = false;
            UpdateAuth = false;
            ViewAuth = false;
            DeleteAuth = false;
        }
    }
    public void GetPageAuthenticationWithBtn(string User_Role_I, string FormPath_V, Button SaveBtnID = null, Button UpdateBtnID = null,
        Button DeleteBtnID = null, HtmlAnchor NewEntryID = null, string QueryStringIDVal = null)
    {
        ds = objApi.ByProcedure("ProcCheckRoleAthentication", new string[] { "User_Role_I", "FormPath_V" }, new string[] { User_Role_I, FormPath_V }, "BYDataset");
        if (ds.Tables[0].Rows.Count > 0)
        {
            NotExist = ds.Tables[0].Rows[0]["Role_V"].ToString();
            SaveAuth = bool.Parse(ds.Tables[0].Rows[0]["SaveChk"].ToString());
            UpdateAuth = bool.Parse(ds.Tables[0].Rows[0]["UpdateChk"].ToString());
            DeleteAuth = bool.Parse(ds.Tables[0].Rows[0]["DeleteChk"].ToString());
            ViewAuth = bool.Parse(ds.Tables[0].Rows[0]["ViewChk"].ToString());
            PageDisplaySts = ds.Tables[0].Rows[0]["PageDisplaySts"].ToString();
            // Save Authentication

            // Update Or Delete Authentication
            if (QueryStringIDVal != null)
            {
                if (UpdateBtnID != null)
                {
                    UpdateBtnID.Visible = UpdateAuth;
                }
                if (SaveBtnID == UpdateBtnID)
                {
                    if (SaveBtnID != null)
                    {
                        SaveBtnID.Visible = UpdateAuth;
                    }
                }
                else
                {
                    SaveBtnID.Visible = false;
                }


                if (DeleteBtnID != null)
                {
                    DeleteBtnID.Visible = DeleteAuth;
                }
            }
            else
            {
                if (SaveBtnID != null)
                {
                    SaveBtnID.Visible = SaveAuth;
                }
                if (NewEntryID != null)
                {
                    NewEntryID.Visible = SaveAuth;
                }
                if (SaveBtnID != UpdateBtnID)
                {
                    if (UpdateBtnID != null)
                    {
                        UpdateBtnID.Visible = false;
                    }
                }
                if (DeleteBtnID != null)
                {
                    DeleteBtnID.Visible = false;
                }

            }
        }
        else
        {
            PageDisplaySts = "";
            NotExist = "NotExist";
            SaveAuth = false;
            UpdateAuth = false;
            ViewAuth = false;
            DeleteAuth = false;
        }
        if (NotExist == "NotExist")
        {
            HttpContext.Current.Response.Redirect("~/Login.html");
        }
    }

    public static bool CheckToken(HttpContext context)
    {
        if (context.Request.Headers.Get("__RequestSecureToken") != null)
        {
            string token = context.Request.Headers.Get("__RequestSecureToken");
            try
            {
                DataSet ds = new DataSet();
                {
                    ds = new APIProcedure().ByProcedure("USP_SSO_LOGIN",
                       new string[] { "app_action", "token" }, new string[] { "CHECK_TOKEN", token }, "USPADDSETTING");
                }
                if (ds.Tables[0].Rows.Count == 0 || (ds.Tables[0].Rows.Count > 0 && string.IsNullOrEmpty(Convert.ToString(ds.Tables[0].Rows[0][0]))))
                {
                    return false;
                }
            }
            catch { }
        }
        return true;
    }
}
